/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashSet;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.util.CaselessStringKey;

public class RenderedImageAdapter
extends PlanarImage {
    protected RenderedImage theImage;
    private Rectangle tileIndexBounds;

    static String[] mergePropertyNames(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = null;
        if (stringArray == null || stringArray.length == 0) {
            stringArray3 = stringArray2;
        } else if (stringArray2 == null || stringArray2.length == 0) {
            stringArray3 = stringArray;
        } else {
            HashSet<CaselessStringKey> hashSet = new HashSet<CaselessStringKey>((stringArray.length + stringArray2.length) / 2);
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                hashSet.add(new CaselessStringKey(stringArray2[n3]));
                ++n3;
            }
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                hashSet.add(new CaselessStringKey(stringArray[n5]));
                ++n5;
            }
            int n6 = hashSet.size();
            CaselessStringKey[] caselessStringKeyArray = new CaselessStringKey[n6];
            hashSet.toArray(caselessStringKeyArray);
            stringArray3 = new String[n6];
            int n7 = 0;
            while (n7 < n6) {
                stringArray3[n7] = caselessStringKeyArray[n7].getName();
                ++n7;
            }
        }
        if (stringArray3 != null && stringArray3.length == 0) {
            stringArray3 = null;
        }
        return stringArray3;
    }

    public RenderedImageAdapter(RenderedImage renderedImage) {
        super(renderedImage != null ? new ImageLayout(renderedImage) : null, null, null);
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.theImage = renderedImage;
        this.tileIndexBounds = new Rectangle(this.theImage.getMinTileX(), this.theImage.getMinTileY(), this.theImage.getNumXTiles(), this.theImage.getNumYTiles());
    }

    public final RenderedImage getWrappedImage() {
        return this.theImage;
    }

    public final Raster getTile(int n2, int n3) {
        return this.tileIndexBounds.contains(n2, n3) ? this.theImage.getTile(n2, n3) : null;
    }

    public final Raster getData() {
        return this.theImage.getData();
    }

    public final Raster getData(Rectangle rectangle) {
        return this.theImage.getData(rectangle);
    }

    public final WritableRaster copyData(WritableRaster writableRaster) {
        return this.theImage.copyData(writableRaster);
    }

    public final String[] getPropertyNames() {
        return RenderedImageAdapter.mergePropertyNames(super.getPropertyNames(), this.theImage.getPropertyNames());
    }

    public final Object getProperty(String string) {
        Object object = super.getProperty(string);
        if (object == Image.UndefinedProperty) {
            object = this.theImage.getProperty(string);
        }
        return object;
    }

    public final Class getPropertyClass(String string) {
        Object object;
        Class<?> clazz = super.getPropertyClass(string);
        if (clazz == null && (object = this.getProperty(string)) != Image.UndefinedProperty) {
            clazz = object.getClass();
        }
        return clazz;
    }
}

