/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.HashSet;
import java.util.Iterator;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.Snapshot;
import javax.media.jai.SnapshotProxy;

public class SnapshotImage
extends PlanarImage
implements TileObserver {
    private PlanarImage source;
    private Snapshot tail = null;
    private HashSet activeTiles = new HashSet();

    public SnapshotImage(PlanarImage planarImage) {
        super(new ImageLayout(planarImage), null, null);
        this.source = planarImage;
        if (planarImage instanceof WritableRenderedImage) {
            WritableRenderedImage writableRenderedImage = (WritableRenderedImage)((Object)planarImage);
            writableRenderedImage.addTileObserver(this);
            Point[] pointArray = writableRenderedImage.getWritableTileIndices();
            if (pointArray != null) {
                int n2 = pointArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Point point = pointArray[n3];
                    this.activeTiles.add(new Point(point.x, point.y));
                    ++n3;
                }
            }
        }
    }

    protected PlanarImage getTrueSource() {
        return this.source;
    }

    void setTail(Snapshot snapshot) {
        this.tail = snapshot;
    }

    Snapshot getTail() {
        return this.tail;
    }

    private Raster createTileCopy(int n2, int n3) {
        int n4 = this.tileXToX(n2);
        int n5 = this.tileYToY(n3);
        Point point = new Point(n4, n5);
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        this.source.copyData(writableRaster);
        return writableRaster;
    }

    public PlanarImage createSnapshot() {
        if (this.source instanceof WritableRenderedImage) {
            Snapshot snapshot = new Snapshot(this);
            Iterator iterator = this.activeTiles.iterator();
            while (iterator.hasNext()) {
                Point point = (Point)iterator.next();
                Raster raster = this.createTileCopy(point.x, point.y);
                snapshot.addTile(raster, point.x, point.y);
            }
            if (this.tail == null) {
                this.tail = snapshot;
            } else {
                this.tail.setNext(snapshot);
                snapshot.setPrev(this.tail);
                this.tail = snapshot;
            }
            return new SnapshotProxy(snapshot);
        }
        return this.source;
    }

    public void tileUpdate(WritableRenderedImage writableRenderedImage, int n2, int n3, boolean bl2) {
        if (bl2) {
            if (this.tail != null && !this.tail.hasTile(n2, n3)) {
                this.tail.addTile(this.createTileCopy(n2, n3), n2, n3);
            }
            this.activeTiles.add(new Point(n2, n3));
        } else {
            this.activeTiles.remove(new Point(n2, n3));
        }
    }

    public Raster getTile(int n2, int n3) {
        return this.source.getTile(n2, n3);
    }
}

