/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public abstract class SourcelessOpImage
extends OpImage {
    private static ImageLayout layoutHelper(int n2, int n3, int n4, int n5, SampleModel sampleModel, ImageLayout imageLayout) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(n2);
        imageLayout2.setMinY(n3);
        imageLayout2.setWidth(n4);
        imageLayout2.setHeight(n5);
        imageLayout2.setSampleModel(sampleModel);
        if (!imageLayout2.isValid(16)) {
            imageLayout2.setTileGridXOffset(imageLayout2.getMinX(null));
        }
        if (!imageLayout2.isValid(32)) {
            imageLayout2.setTileGridYOffset(imageLayout2.getMinY(null));
        }
        return imageLayout2;
    }

    public SourcelessOpImage(ImageLayout imageLayout, Map map, SampleModel sampleModel, int n2, int n3, int n4, int n5) {
        super(null, SourcelessOpImage.layoutHelper(n2, n3, n4, n5, sampleModel, imageLayout), map, false);
    }

    public boolean computesUniqueTiles() {
        return false;
    }

    public Raster computeTile(int n2, int n3) {
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.sampleModel.getWidth(), this.sampleModel.getHeight());
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        this.computeRect((PlanarImage[])null, writableRaster, rectangle2);
        return writableRaster;
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        throw new IllegalArgumentException(JaiI18N.getString("SourcelessOpImage0"));
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        throw new IllegalArgumentException(JaiI18N.getString("SourcelessOpImage0"));
    }
}

