/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public abstract class UntiledOpImage
extends OpImage {
    private static ImageLayout layoutHelper(ImageLayout imageLayout, Vector vector) {
        if (vector.size() < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic5"));
        }
        RenderedImage renderedImage = (RenderedImage)vector.get(0);
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setTileGridXOffset(imageLayout2.getMinX(renderedImage));
        imageLayout2.setTileGridYOffset(imageLayout2.getMinY(renderedImage));
        imageLayout2.setTileWidth(imageLayout2.getWidth(renderedImage));
        imageLayout2.setTileHeight(imageLayout2.getHeight(renderedImage));
        return imageLayout2;
    }

    public UntiledOpImage(Vector vector, Map map, ImageLayout imageLayout) {
        super(OpImage.checkSourceVector(vector, true), UntiledOpImage.layoutHelper(imageLayout, vector), map, true);
    }

    public UntiledOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(OpImage.vectorize(renderedImage), UntiledOpImage.layoutHelper(imageLayout, OpImage.vectorize(renderedImage)), map, true);
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n2) {
        return this.getBounds();
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n2) {
        if (n2 < 0 || n2 >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return this.getSource(n2).getBounds();
    }

    public Raster computeTile(int n2, int n3) {
        Object object;
        Point point = new Point(this.getMinX(), this.getMinY());
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.getBounds();
        int n4 = this.getNumSources();
        Raster[] rasterArray = new Raster[n4];
        int n5 = 0;
        while (n5 < n4) {
            PlanarImage planarImage = this.getSource(n5);
            object = this.mapDestRect(rectangle, n5);
            rasterArray[n5] = planarImage.getData((Rectangle)object);
            ++n5;
        }
        this.computeImage(rasterArray, writableRaster, rectangle);
        int n6 = 0;
        while (n6 < n4) {
            PlanarImage planarImage;
            object = rasterArray[n6];
            if (object != null && (planarImage = this.getSourceImage(n6)).overlapsMultipleTiles(((Raster)object).getBounds())) {
                this.recycleTile((Raster)object);
            }
            ++n6;
        }
        return writableRaster;
    }

    protected abstract void computeImage(Raster[] var1, WritableRaster var2, Rectangle var3);

    public Point[] getTileDependencies(int n2, int n3, int n4) {
        PlanarImage planarImage = this.getSource(n4);
        int n5 = planarImage.getMinTileX();
        int n6 = planarImage.getMinTileY();
        int n7 = n5 + planarImage.getNumXTiles() - 1;
        int n8 = n6 + planarImage.getNumYTiles() - 1;
        Point[] pointArray = new Point[(n7 - n5 + 1) * (n8 - n6 + 1)];
        int n9 = 0;
        int n10 = n6;
        while (n10 <= n8) {
            int n11 = n5;
            while (n11 <= n7) {
                pointArray[n9++] = new Point(n11, n10);
                ++n11;
            }
            ++n10;
        }
        return pointArray;
    }
}

