/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PolyWarpSolver;
import java.awt.geom.Point2D;
import javax.media.jai.JaiI18N;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpCubic;
import javax.media.jai.WarpGeneralPolynomial;
import javax.media.jai.WarpQuadratic;

public abstract class WarpPolynomial
extends Warp {
    protected float[] xCoeffs;
    protected float[] yCoeffs;
    protected float preScaleX;
    protected float preScaleY;
    protected float postScaleX;
    protected float postScaleY;
    protected int degree;

    public WarpPolynomial(float[] fArray, float[] fArray2, float f2, float f3, float f4, float f5) {
        if (fArray == null || fArray2 == null || fArray.length < 1 || fArray2.length < 1 || fArray.length != fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial0"));
        }
        int n2 = fArray.length;
        this.degree = -1;
        while (n2 > 0) {
            ++this.degree;
            n2 -= this.degree + 1;
        }
        if (n2 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial0"));
        }
        this.xCoeffs = (float[])fArray.clone();
        this.yCoeffs = (float[])fArray2.clone();
        this.preScaleX = f2;
        this.preScaleY = f3;
        this.postScaleX = f4;
        this.postScaleY = f5;
    }

    public WarpPolynomial(float[] fArray, float[] fArray2) {
        this(fArray, fArray2, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public float[] getXCoeffs() {
        return (float[])this.xCoeffs.clone();
    }

    public float[] getYCoeffs() {
        return (float[])this.yCoeffs.clone();
    }

    public float[][] getCoeffs() {
        float[][] fArrayArray = new float[][]{(float[])this.xCoeffs.clone(), (float[])this.yCoeffs.clone()};
        return fArrayArray;
    }

    public float getPreScaleX() {
        return this.preScaleX;
    }

    public float getPreScaleY() {
        return this.preScaleY;
    }

    public float getPostScaleX() {
        return this.postScaleX;
    }

    public float getPostScaleY() {
        return this.postScaleY;
    }

    public int getDegree() {
        return this.degree;
    }

    public static WarpPolynomial createWarp(float[] fArray, int n2, float[] fArray2, int n3, int n4, float f2, float f3, float f4, float f5, int n5) {
        int n6 = (n5 + 1) * (n5 + 2);
        if (n2 + n6 > fArray.length || n3 + n6 > fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial1"));
        }
        float[] fArray3 = PolyWarpSolver.getCoeffs(fArray, n2, fArray2, n3, n4, f2, f3, f4, f5, n5);
        int n7 = fArray3.length / 2;
        float[] fArray4 = new float[n7];
        float[] fArray5 = new float[n7];
        int n8 = 0;
        while (n8 < n7) {
            fArray4[n8] = fArray3[n8];
            fArray5[n8] = fArray3[n8 + n7];
            ++n8;
        }
        if (n5 == 1) {
            return new WarpAffine(fArray4, fArray5, f2, f3, f4, f5);
        }
        if (n5 == 2) {
            return new WarpQuadratic(fArray4, fArray5, f2, f3, f4, f5);
        }
        if (n5 == 3) {
            return new WarpCubic(fArray4, fArray5, f2, f3, f4, f5);
        }
        return new WarpGeneralPolynomial(fArray4, fArray5, f2, f3, f4, f5);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        double d2 = (point2D.getX() + 0.5) * (double)this.preScaleX;
        double d3 = (point2D.getY() + 0.5) * (double)this.preScaleY;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        int n3 = 0;
        while (n3 <= this.degree) {
            int n4 = 0;
            while (n4 <= n3) {
                double d6 = Math.pow(d2, n3 - n4) * Math.pow(d3, n4);
                d4 += (double)this.xCoeffs[n2] * d6;
                d5 += (double)this.yCoeffs[n2] * d6;
                ++n2;
                ++n4;
            }
            ++n3;
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(d4 * (double)this.postScaleX - 0.5, d5 * (double)this.postScaleY - 0.5);
        return point2D2;
    }
}

