/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class BandSelectDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "BandSelect"}, {"LocalName", "BandSelect"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("BandSelectDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/BandSelectDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("BandSelectDescriptor1")}};
    private static final Class[] paramClasses = new Class[]{array$I == null ? (array$I = BandSelectDescriptor.class$("[I")) : array$I};
    private static final String[] paramNames = new String[]{"bandIndices"};
    private static final Object[] paramDefaults = new Object[]{OperationDescriptor.NO_PARAMETER_DEFAULT};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};
    static /* synthetic */ Class array$I;

    public BandSelectDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        int[] nArray = (int[])parameterBlock.getObjectParameter(0);
        if (nArray.length < 1) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("BandSelectDescriptor2"));
            return false;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        int n2 = renderedImage.getSampleModel().getNumBands();
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] < 0 || nArray[n3] >= n2) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("BandSelectDescriptor3"));
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, int[] nArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("BandSelect", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("bandIndices", nArray);
        return JAI.create("BandSelect", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, int[] nArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("BandSelect", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("bandIndices", nArray);
        return JAI.createRenderable("BandSelect", parameterBlockJAI, renderingHints);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

