/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class FileStoreDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "FileStore"}, {"LocalName", "FileStore"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("FileStoreDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/FileStoreDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("FileStoreDescriptor1")}, {"arg1Desc", JaiI18N.getString("FileStoreDescriptor2")}, {"arg2Desc", JaiI18N.getString("FileStoreDescriptor3")}, {"arg3Desc", JaiI18N.getString("FileStoreDescriptor11")}};
    private static final String[] paramNames = new String[]{"filename", "format", "param", "checkFileLocally"};
    private static final Class[] paramClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FileStoreDescriptor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FileStoreDescriptor.class$("java.lang.String")) : class$java$lang$String, class$com$sun$media$jai$codec$ImageEncodeParam == null ? (class$com$sun$media$jai$codec$ImageEncodeParam = FileStoreDescriptor.class$("com.sun.media.jai.codec.ImageEncodeParam")) : class$com$sun$media$jai$codec$ImageEncodeParam, class$java$lang$Boolean == null ? (class$java$lang$Boolean = FileStoreDescriptor.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    private static final Object[] paramDefaults = new Object[]{OperationDescriptor.NO_PARAMETER_DEFAULT, "tiff", null, Boolean.TRUE};
    private static final String[] supportedModes = new String[]{"rendered"};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$media$jai$codec$ImageEncodeParam;
    static /* synthetic */ Class class$java$lang$Boolean;

    public FileStoreDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        String string2 = (String)parameterBlock.getObjectParameter(1);
        ImageCodec imageCodec = ImageCodec.getCodec(string2);
        if (imageCodec == null) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("FileStoreDescriptor4"));
            return false;
        }
        ImageEncodeParam imageEncodeParam = (ImageEncodeParam)parameterBlock.getObjectParameter(2);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (!imageCodec.canEncodeImage(renderedImage, imageEncodeParam)) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("FileStoreDescriptor5"));
            return false;
        }
        String string3 = (String)parameterBlock.getObjectParameter(0);
        if (string3 == null) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("FileStoreDescriptor6"));
            return false;
        }
        Boolean bl2 = (Boolean)parameterBlock.getObjectParameter(3);
        if (bl2.booleanValue()) {
            try {
                File file = new File(string3);
                if (file.exists()) {
                    if (!file.canWrite()) {
                        stringBuffer.append(this.getName() + " " + JaiI18N.getString("FileStoreDescriptor7"));
                        return false;
                    }
                } else {
                    if (!file.createNewFile()) {
                        stringBuffer.append(this.getName() + " " + JaiI18N.getString("FileStoreDescriptor8"));
                        return false;
                    }
                    file.delete();
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("FileStoreDescriptor9") + " " + iOException.getMessage());
                return false;
            }
            catch (SecurityException securityException) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("FileStoreDescriptor10") + " " + securityException.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean isImmediate() {
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, String string, String string2, ImageEncodeParam imageEncodeParam, Boolean bl2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("FileStore", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("filename", string);
        parameterBlockJAI.setParameter("format", string2);
        parameterBlockJAI.setParameter("param", imageEncodeParam);
        parameterBlockJAI.setParameter("checkFileLocally", bl2);
        return JAI.create("FileStore", parameterBlockJAI, renderingHints);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

