/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class PiecewiseDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Piecewise"}, {"LocalName", "Piecewise"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("PiecewiseDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/PiecewiseDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", "The breakpoint array."}};
    private static final Class[] paramClasses = new Class[]{array$$$F == null ? (array$$$F = PiecewiseDescriptor.class$("[[[F")) : array$$$F};
    private static final String[] paramNames = new String[]{"breakPoints"};
    private static final Object[] paramDefaults = new Object[]{new float[][][]{new float[][]{{0.0f, 255.0f}, {0.0f, 255.0f}}}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};
    static /* synthetic */ Class array$$$F;

    public PiecewiseDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float[][][] fArray = (float[][][])parameterBlock.getObjectParameter(0);
        if (fArray.length != 1 && fArray.length != renderedImage.getSampleModel().getNumBands()) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("PiecewiseDescriptor1"));
            return false;
        }
        int n2 = fArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (fArray[n3].length != 2) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("PiecewiseDescriptor2"));
                return false;
            }
            if (fArray[n3][0].length != fArray[n3][1].length) {
                stringBuffer.append(this.getName() + " " + JaiI18N.getString("PiecewiseDescriptor3"));
                return false;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = fArray[n4][0].length - 1;
            float[] fArray2 = fArray[n4][0];
            int n6 = 0;
            while (n6 < n5) {
                if (fArray2[n6] >= fArray2[n6 + 1]) {
                    stringBuffer.append(this.getName() + " " + JaiI18N.getString("PiecewiseDescriptor4"));
                    return false;
                }
                ++n6;
            }
            ++n4;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, float[][][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Piecewise", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("breakPoints", fArray);
        return JAI.create("Piecewise", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, float[][][] fArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Piecewise", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("breakPoints", fArray);
        return JAI.createRenderable("Piecewise", parameterBlockJAI, renderingHints);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

