/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListImpl;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RemoteImage;
import javax.media.jai.TileCache;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileCodecDescriptor;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderFactory;
import javax.media.jai.tilecodec.TileEncoder;
import javax.media.jai.tilecodec.TileEncoderFactory;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public final class SerializableRenderedImage
implements RenderedImage,
Serializable {
    private static final int SERVER_TIMEOUT = 60000;
    private static final String CLOSE_MESSAGE = "CLOSE";
    private static final String CLOSE_ACK = "CLOSE_ACK";
    private Object UID;
    private transient boolean isServer;
    private boolean isSourceRemote;
    private transient RenderedImage source;
    private int minX;
    private int minY;
    private int width;
    private int height;
    private int minTileX;
    private int minTileY;
    private int numXTiles;
    private int numYTiles;
    private int tileWidth;
    private int tileHeight;
    private int tileGridXOffset;
    private int tileGridYOffset;
    private transient SampleModel sampleModel = null;
    private transient ColorModel colorModel = null;
    private transient Vector sources = null;
    private transient Hashtable properties = null;
    private boolean useDeepCopy;
    private Rectangle imageBounds;
    private transient Raster imageRaster;
    private InetAddress host;
    private int port;
    private transient boolean serverOpen = false;
    private transient ServerSocket serverSocket = null;
    private transient Thread serverThread;
    private String formatName;
    private transient OperationRegistry registry;
    private static transient Hashtable remoteReferenceCount;
    private boolean useTileCodec = false;
    private transient TileDecoderFactory tileDecoderFactory = null;
    private transient TileEncoderFactory tileEncoderFactory = null;
    private TileCodecParameterList encodingParam = null;
    private TileCodecParameterList decodingParam = null;
    static /* synthetic */ Class class$java$awt$image$Raster;

    private static synchronized void incrementRemoteReferenceCount(Object object) {
        if (remoteReferenceCount == null) {
            remoteReferenceCount = new Hashtable();
            remoteReferenceCount.put(object, new Integer(1));
        } else {
            Integer n2 = (Integer)remoteReferenceCount.get(object);
            if (n2 == null) {
                remoteReferenceCount.put(object, new Integer(1));
            } else {
                remoteReferenceCount.put(object, new Integer(n2 + 1));
            }
        }
    }

    private static synchronized void decrementRemoteReferenceCount(Object object) {
        Integer n2;
        if (remoteReferenceCount != null && (n2 = (Integer)remoteReferenceCount.get(object)) != null) {
            if (n2 == 1) {
                remoteReferenceCount.remove(object);
            } else {
                remoteReferenceCount.put(object, new Integer(n2 - 1));
            }
        }
    }

    SerializableRenderedImage() {
    }

    public SerializableRenderedImage(RenderedImage renderedImage, boolean bl2, OperationRegistry operationRegistry, String string, TileCodecParameterList tileCodecParameterList, TileCodecParameterList tileCodecParameterList2) throws NotSerializableException {
        this(renderedImage, bl2, false);
        TileCodecDescriptor tileCodecDescriptor;
        if (string == null) {
            return;
        }
        this.formatName = string;
        if (operationRegistry == null) {
            operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        }
        this.registry = operationRegistry;
        if (tileCodecParameterList == null) {
            tileCodecDescriptor = this.getTileCodecDescriptor("tileEncoder", string);
            tileCodecParameterList = tileCodecDescriptor.getDefaultParameters("tileEncoder");
        } else if (!string.equals(tileCodecParameterList.getFormatName())) {
            throw new IllegalArgumentException(JaiI18N.getString("UseTileCodec0"));
        }
        if (tileCodecParameterList2 == null) {
            tileCodecDescriptor = this.getTileCodecDescriptor("tileDecoder", string);
            tileCodecParameterList2 = tileCodecDescriptor.getDefaultParameters("tileDecoder");
        } else if (!string.equals(tileCodecParameterList2.getFormatName())) {
            throw new IllegalArgumentException(JaiI18N.getString("UseTileCodec1"));
        }
        this.tileEncoderFactory = (TileEncoderFactory)operationRegistry.getFactory("tileEncoder", string);
        this.tileDecoderFactory = (TileDecoderFactory)operationRegistry.getFactory("tileDecoder", string);
        if (this.tileEncoderFactory == null || this.tileDecoderFactory == null) {
            throw new RuntimeException(JaiI18N.getString("UseTileCodec2"));
        }
        this.encodingParam = tileCodecParameterList;
        this.decodingParam = tileCodecParameterList2;
        this.useTileCodec = true;
    }

    public SerializableRenderedImage(RenderedImage renderedImage, boolean bl2) {
        this(renderedImage, bl2, true);
    }

    public SerializableRenderedImage(RenderedImage renderedImage) {
        this(renderedImage, false, true);
    }

    private SerializableRenderedImage(RenderedImage renderedImage, boolean bl2, boolean bl3) {
        DataBuffer dataBuffer;
        String[] stringArray;
        this.UID = ImageUtil.generateID(this);
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage0"));
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel != null && SerializerFactory.getSerializer(sampleModel.getClass()) == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage2"));
        }
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null && SerializerFactory.getSerializer(colorModel.getClass()) == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage3"));
        }
        if (bl3 && (stringArray = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY())) != null && (dataBuffer = stringArray.getDataBuffer()) != null && SerializerFactory.getSerializer(dataBuffer.getClass()) == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderedImage4"));
        }
        this.isServer = true;
        this.useDeepCopy = bl2;
        this.source = renderedImage;
        this.isSourceRemote = renderedImage instanceof RemoteImage;
        this.minX = renderedImage.getMinX();
        this.minY = renderedImage.getMinY();
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        this.minTileX = renderedImage.getMinTileX();
        this.minTileY = renderedImage.getMinTileY();
        this.numXTiles = renderedImage.getNumXTiles();
        this.numYTiles = renderedImage.getNumYTiles();
        this.tileWidth = renderedImage.getTileWidth();
        this.tileHeight = renderedImage.getTileHeight();
        this.tileGridXOffset = renderedImage.getTileGridXOffset();
        this.tileGridYOffset = renderedImage.getTileGridYOffset();
        this.sampleModel = renderedImage.getSampleModel();
        this.colorModel = renderedImage.getColorModel();
        this.sources = new Vector();
        this.sources.add(renderedImage);
        this.properties = new Hashtable();
        stringArray = renderedImage.getPropertyNames();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.properties.put(stringArray[n2], renderedImage.getProperty(stringArray[n2]));
                ++n2;
            }
        }
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        try {
            this.host = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException.getMessage());
        }
        this.serverOpen = false;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        Rectangle rectangle;
        if (this.isServer || this.isSourceRemote) {
            return this.source.copyData(writableRaster);
        }
        if (writableRaster == null) {
            rectangle = this.imageBounds;
            SampleModel sampleModel = this.getSampleModel().createCompatibleSampleModel(rectangle.width, rectangle.height);
            writableRaster = Raster.createWritableRaster(sampleModel, new Point(rectangle.x, rectangle.y));
        } else {
            rectangle = writableRaster.getBounds().intersection(this.imageBounds);
        }
        if (!rectangle.isEmpty()) {
            int n2 = PlanarImage.XToTileX(rectangle.x, this.tileGridXOffset, this.tileWidth);
            int n3 = PlanarImage.YToTileY(rectangle.y, this.tileGridYOffset, this.tileHeight);
            int n4 = PlanarImage.XToTileX(rectangle.x + rectangle.width - 1, this.tileGridXOffset, this.tileWidth);
            int n5 = PlanarImage.YToTileY(rectangle.y + rectangle.height - 1, this.tileGridYOffset, this.tileHeight);
            SampleModel[] sampleModelArray = new SampleModel[]{this.getSampleModel()};
            int n6 = RasterAccessor.findCompatibleTag(sampleModelArray, writableRaster.getSampleModel());
            RasterFormatTag rasterFormatTag = new RasterFormatTag(this.getSampleModel(), n6);
            RasterFormatTag rasterFormatTag2 = new RasterFormatTag(writableRaster.getSampleModel(), n6);
            int n7 = n3;
            while (n7 <= n5) {
                int n8 = n2;
                while (n8 <= n4) {
                    Raster raster = this.getTile(n8, n7);
                    Rectangle rectangle2 = rectangle.intersection(raster.getBounds());
                    RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTag, this.getColorModel());
                    RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle2, rasterFormatTag2, null);
                    ImageUtil.copyRaster(rasterAccessor, rasterAccessor2);
                    ++n8;
                }
                ++n7;
            }
        }
        return writableRaster;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Raster getData() {
        if (this.isServer || this.isSourceRemote) {
            return this.source.getData();
        }
        return this.getData(this.imageBounds);
    }

    public Raster getData(Rectangle rectangle) {
        Raster raster = null;
        if (this.isServer || this.isSourceRemote) {
            raster = this.source.getData(rectangle);
        } else if (this.useDeepCopy) {
            raster = this.imageRaster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        } else {
            Object object;
            Object object2;
            Socket socket = this.connectToServer();
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            InputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                outputStream = socket.getOutputStream();
                objectOutputStream = new ObjectOutputStream(outputStream);
                inputStream = socket.getInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
            }
            catch (IOException iOException) {
                this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage7"), new ImagingException(JaiI18N.getString("SerializableRenderedImage7"), iOException));
            }
            try {
                objectOutputStream.writeObject(rectangle);
            }
            catch (IOException iOException) {
                this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage10"), new ImagingException(JaiI18N.getString("SerializableRenderedImage10"), iOException));
            }
            Object object3 = null;
            try {
                object3 = objectInputStream.readObject();
            }
            catch (IOException iOException) {
                this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage8"), new ImagingException(JaiI18N.getString("SerializableRenderedImage8"), iOException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage9"), new ImagingException(JaiI18N.getString("SerializableRenderedImage9"), classNotFoundException));
            }
            if (this.useTileCodec) {
                object2 = (byte[])object3;
                raster = this.decodeRasterFromByteArray((byte[])object2);
            } else {
                if (!(object3 instanceof SerializableState)) {
                    raster = null;
                }
                object2 = (SerializableState)object3;
                object = object2.getObjectClass();
                raster = (class$java$awt$image$Raster == null ? (class$java$awt$image$Raster = SerializableRenderedImage.class$("java.awt.image.Raster")) : class$java$awt$image$Raster).isAssignableFrom((Class<?>)object) ? (Raster)object2.getObject() : null;
            }
            try {
                objectOutputStream.flush();
                socket.shutdownOutput();
                socket.shutdownInput();
                objectOutputStream.close();
                outputStream.close();
                objectInputStream.close();
                inputStream.close();
                socket.close();
            }
            catch (IOException iOException) {
                object = JaiI18N.getString("SerializableRenderedImage11");
                this.sendExceptionToListener((String)object, new ImagingException((String)object, iOException));
            }
            if (this.imageBounds.equals(rectangle)) {
                this.closeClient();
                this.imageRaster = raster;
                this.useDeepCopy = true;
            }
        }
        return raster;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMinTileX() {
        return this.minTileX;
    }

    public int getMinTileY() {
        return this.minTileY;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getNumXTiles() {
        return this.numXTiles;
    }

    public int getNumYTiles() {
        return this.numYTiles;
    }

    public Object getProperty(String string) {
        Object v2 = this.properties.get(string);
        return v2 == null ? Image.UndefinedProperty : v2;
    }

    public String[] getPropertyNames() {
        String[] stringArray = null;
        if (!this.properties.isEmpty()) {
            stringArray = new String[this.properties.size()];
            Enumeration enumeration = this.properties.keys();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n2++] = (String)enumeration.nextElement();
            }
        }
        return stringArray;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public Vector getSources() {
        return this.sources;
    }

    public Raster getTile(int n2, int n3) {
        Object object;
        if (this.isServer || this.isSourceRemote) {
            return this.source.getTile(n2, n3);
        }
        TileCache tileCache = JAI.getDefaultInstance().getTileCache();
        if (tileCache != null && (object = tileCache.getTile(this, n2, n3)) != null) {
            return object;
        }
        object = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
        Rectangle rectangle = ((Rectangle)object).intersection(new Rectangle(this.tileXToX(n2), this.tileYToY(n3), this.getTileWidth(), this.getTileHeight()));
        Raster raster = this.getData(rectangle);
        if (tileCache != null) {
            tileCache.add(this, n2, n3, raster);
        }
        return raster;
    }

    public Object getImageID() {
        return this.UID;
    }

    private int tileXToX(int n2) {
        return PlanarImage.tileXToX(n2, this.getTileGridXOffset(), this.getTileWidth());
    }

    private int tileYToY(int n2) {
        return PlanarImage.tileYToY(n2, this.getTileGridYOffset(), this.getTileHeight());
    }

    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getWidth() {
        return this.width;
    }

    private synchronized void openServer() throws IOException, SocketException {
        if (!this.serverOpen) {
            this.serverSocket = new ServerSocket(0);
            this.serverSocket.setSoTimeout(60000);
            this.port = this.serverSocket.getLocalPort();
            this.serverOpen = true;
            this.serverThread = new Thread(new TileServer());
            this.serverThread.setDaemon(true);
            this.serverThread.start();
            SerializableRenderedImage.incrementRemoteReferenceCount(this);
        }
    }

    private void closeClient() {
        Socket socket = this.connectToServer();
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectInputStream = new ObjectInputStream(socket.getInputStream());
        }
        catch (IOException iOException) {
            this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage7"), new ImagingException(JaiI18N.getString("SerializableRenderedImage7"), iOException));
        }
        try {
            objectOutputStream.writeObject(CLOSE_MESSAGE);
        }
        catch (IOException iOException) {
            this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage13"), new ImagingException(JaiI18N.getString("SerializableRenderedImage13"), iOException));
        }
        try {
            objectInputStream.readObject();
        }
        catch (IOException iOException) {
            this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage8"), new ImagingException(JaiI18N.getString("SerializableRenderedImage8"), iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage9"), new ImagingException(JaiI18N.getString("SerializableRenderedImage9"), classNotFoundException));
        }
        try {
            objectOutputStream.flush();
            socket.shutdownOutput();
            objectOutputStream.close();
            outputStream.close();
            objectInputStream.close();
            socket.close();
        }
        catch (IOException iOException) {
            this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage11"), new ImagingException(JaiI18N.getString("SerializableRenderedImage11"), iOException));
        }
    }

    private Socket connectToServer() {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            socket.setSoLinger(true, 1);
        }
        catch (IOException iOException) {
            this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage14"), new ImagingException(JaiI18N.getString("SerializableRenderedImage14"), iOException));
        }
        return socket;
    }

    private byte[] encodeRasterToByteArray(Raster raster) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TileEncoder tileEncoder = this.tileEncoderFactory.createEncoder(byteArrayOutputStream, this.encodingParam, raster.getSampleModel());
        try {
            tileEncoder.encode(raster);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage15"), new ImagingException(JaiI18N.getString("SerializableRenderedImage15"), iOException));
            return null;
        }
    }

    private Raster decodeRasterFromByteArray(byte[] byArray) {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (this.tileDecoderFactory == null) {
            if (this.registry == null) {
                this.registry = JAI.getDefaultInstance().getOperationRegistry();
            }
            this.tileDecoderFactory = (TileDecoderFactory)this.registry.getFactory("tileDecoder", this.formatName);
            object = this.decodingParam;
            if (object != null) {
                TileCodecDescriptor tileCodecDescriptor = this.getTileCodecDescriptor("tileDecoder", this.formatName);
                ParameterListDescriptor parameterListDescriptor = tileCodecDescriptor.getParameterListDescriptor("tileDecoder");
                this.decodingParam = new TileCodecParameterList(this.formatName, new String[]{"tileDecoder"}, parameterListDescriptor);
                String[] stringArray = parameterListDescriptor.getParamNames();
                if (stringArray != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        this.decodingParam.setParameter(stringArray[n2], ((ParameterListImpl)object).getObjectParameter(stringArray[n2]));
                        ++n2;
                    }
                }
            } else {
                this.decodingParam = this.getTileCodecDescriptor("tileDecoder", this.formatName).getDefaultParameters("tileDecoder");
            }
        }
        object = this.tileDecoderFactory.createDecoder(byteArrayInputStream, this.decodingParam);
        try {
            return object.decode();
        }
        catch (IOException iOException) {
            this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage16"), new ImagingException(JaiI18N.getString("SerializableRenderedImage16"), iOException));
            return null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.isServer) {
            if (this.serverOpen) {
                this.serverOpen = false;
                try {
                    this.serverThread.join(120000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {}
            }
        } else {
            this.closeClient();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        if (!this.useDeepCopy) {
            try {
                this.openServer();
            }
            catch (Exception exception) {
                if (exception instanceof SocketException && this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.serverOpen = false;
                this.useDeepCopy = true;
            }
        }
        objectOutputStream.defaultWriteObject();
        if (this.isSourceRemote) {
            object = this.source.getClass().getName();
            objectOutputStream.writeObject(this.source.getProperty((String)object + ".serverName"));
            objectOutputStream.writeObject(this.source.getProperty((String)object + ".id"));
        }
        object = this.properties;
        boolean bl2 = false;
        Enumeration enumeration = ((Hashtable)object).keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            if (this.properties.get(k2) instanceof Serializable) continue;
            if (!bl2) {
                object = (Hashtable)this.properties.clone();
                bl2 = true;
            }
            ((Hashtable)object).remove(k2);
        }
        objectOutputStream.writeObject(SerializerFactory.getState(this.sampleModel, null));
        objectOutputStream.writeObject(SerializerFactory.getState(this.colorModel, null));
        objectOutputStream.writeObject(object);
        if (this.useDeepCopy) {
            if (this.useTileCodec) {
                objectOutputStream.writeObject(this.encodeRasterToByteArray(this.source.getData()));
            } else {
                objectOutputStream.writeObject(SerializerFactory.getState(this.source.getData(), null));
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Serializable serializable;
        Object object;
        this.isServer = false;
        this.source = null;
        this.serverOpen = false;
        this.serverSocket = null;
        this.serverThread = null;
        this.colorModel = null;
        objectInputStream.defaultReadObject();
        if (this.isSourceRemote) {
            object = (String)objectInputStream.readObject();
            serializable = (Long)objectInputStream.readObject();
            this.source = new RemoteImage((String)object + "::" + (Long)serializable, (RenderedImage)null);
        }
        object = (SerializableState)objectInputStream.readObject();
        this.sampleModel = (SampleModel)object.getObject();
        serializable = (SerializableState)objectInputStream.readObject();
        this.colorModel = (ColorModel)serializable.getObject();
        this.properties = (Hashtable)objectInputStream.readObject();
        if (this.useDeepCopy) {
            if (this.useTileCodec) {
                this.imageRaster = this.decodeRasterFromByteArray((byte[])objectInputStream.readObject());
            } else {
                SerializableState serializableState = (SerializableState)objectInputStream.readObject();
                this.imageRaster = (Raster)serializableState.getObject();
            }
        }
    }

    private TileCodecDescriptor getTileCodecDescriptor(String string, String string2) {
        if (this.registry == null) {
            return (TileCodecDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor(string, string2);
        }
        return (TileCodecDescriptor)this.registry.getDescriptor(string, string2);
    }

    void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = JAI.getDefaultInstance().getImagingListener();
        imagingListener.errorOccurred(string, exception, this, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TileServer
    implements Runnable {
        private TileServer() {
        }

        public void run() {
            while (SerializableRenderedImage.this.serverOpen) {
                Socket socket = null;
                try {
                    socket = SerializableRenderedImage.this.serverSocket.accept();
                    socket.setSoLinger(true, 1);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (SocketException socketException) {
                    SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage5"), new ImagingException(JaiI18N.getString("SerializableRenderedImage5"), socketException));
                }
                catch (IOException iOException) {
                    SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage6"), new ImagingException(JaiI18N.getString("SerializableRenderedImage6"), iOException));
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                ObjectInputStream objectInputStream = null;
                ObjectOutputStream objectOutputStream = null;
                try {
                    inputStream = socket.getInputStream();
                    outputStream = socket.getOutputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    objectOutputStream = new ObjectOutputStream(outputStream);
                }
                catch (IOException iOException) {
                    SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage7"), new ImagingException(JaiI18N.getString("SerializableRenderedImage7"), iOException));
                }
                Object object = null;
                try {
                    object = objectInputStream.readObject();
                }
                catch (IOException iOException) {
                    SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage8"), new ImagingException(JaiI18N.getString("SerializableRenderedImage8"), iOException));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage9"), new ImagingException(JaiI18N.getString("SerializableRenderedImage9"), classNotFoundException));
                }
                if (object instanceof String && ((String)object).equals(SerializableRenderedImage.CLOSE_MESSAGE)) {
                    try {
                        objectOutputStream.writeObject(SerializableRenderedImage.CLOSE_ACK);
                    }
                    catch (IOException iOException) {
                        SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage17"), new ImagingException(JaiI18N.getString("SerializableRenderedImage17"), iOException));
                    }
                    SerializableRenderedImage.decrementRemoteReferenceCount(this);
                } else if (object instanceof Rectangle) {
                    Raster raster = SerializableRenderedImage.this.source.getData((Rectangle)object);
                    if (SerializableRenderedImage.this.useTileCodec) {
                        byte[] byArray = SerializableRenderedImage.this.encodeRasterToByteArray(raster);
                        try {
                            objectOutputStream.writeObject(byArray);
                        }
                        catch (IOException iOException) {
                            SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage10"), new ImagingException(JaiI18N.getString("SerializableRenderedImage10"), iOException));
                        }
                    } else {
                        try {
                            objectOutputStream.writeObject(SerializerFactory.getState(raster, null));
                        }
                        catch (IOException iOException) {
                            SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage10"), new ImagingException(JaiI18N.getString("SerializableRenderedImage10"), iOException));
                        }
                    }
                }
                try {
                    objectOutputStream.flush();
                    socket.shutdownOutput();
                    socket.shutdownInput();
                    objectOutputStream.close();
                    objectInputStream.close();
                    outputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (IOException iOException) {
                    SerializableRenderedImage.this.sendExceptionToListener(JaiI18N.getString("SerializableRenderedImage10"), new ImagingException(JaiI18N.getString("SerializableRenderedImage10"), iOException));
                }
            }
        }
    }
}

