/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class SocketHubAppender
extends AppenderSkeleton {
    static final int DEFAULT_PORT = 4560;
    private int port = 4560;
    private Vector oosList = new Vector();
    private ServerMonitor serverMonitor = null;
    private boolean locationInfo = false;

    public SocketHubAppender() {
    }

    public SocketHubAppender(int _port) {
        this.port = _port;
        this.startServer();
    }

    public void activateOptions() {
        this.startServer();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("closing SocketHubAppender " + this.getName());
        this.closed = true;
        this.cleanUp();
        LogLog.debug("SocketHubAppender " + this.getName() + " closed");
    }

    public void cleanUp() {
        LogLog.debug("stopping ServerSocket");
        this.serverMonitor.stopMonitor();
        this.serverMonitor = null;
        LogLog.debug("closing client connections");
        while (this.oosList.size() != 0) {
            ObjectOutputStream oos = (ObjectOutputStream)this.oosList.elementAt(0);
            if (oos == null) continue;
            try {
                oos.close();
            }
            catch (IOException e2) {
                LogLog.error("could not close oos.", e2);
            }
            this.oosList.removeElementAt(0);
        }
    }

    public void append(LoggingEvent event) {
        if (event == null || this.oosList.size() == 0) {
            return;
        }
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        for (int streamCount = 0; streamCount < this.oosList.size(); ++streamCount) {
            ObjectOutputStream oos = null;
            try {
                oos = (ObjectOutputStream)this.oosList.elementAt(streamCount);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                // empty catch block
            }
            if (oos == null) break;
            try {
                oos.writeObject(event);
                oos.flush();
                oos.reset();
                continue;
            }
            catch (IOException e3) {
                this.oosList.removeElementAt(streamCount);
                LogLog.debug("dropped connection");
                --streamCount;
            }
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int _port) {
        this.port = _port;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean _locationInfo) {
        this.locationInfo = _locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    private void startServer() {
        this.serverMonitor = new ServerMonitor(this.port, this.oosList);
    }

    private class ServerMonitor
    implements Runnable {
        private int port;
        private Vector oosList;
        private boolean keepRunning;
        private Thread monitorThread;

        public ServerMonitor(int _port, Vector _oosList) {
            this.port = _port;
            this.oosList = _oosList;
            this.keepRunning = true;
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.start();
        }

        public synchronized void stopMonitor() {
            if (this.keepRunning) {
                LogLog.debug("server monitor thread shutting down");
                this.keepRunning = false;
                try {
                    this.monitorThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.monitorThread = null;
                LogLog.debug("server monitor thread shut down");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.port);
                serverSocket.setSoTimeout(1000);
            }
            catch (Exception e2) {
                LogLog.error("exception setting timeout, shutting down server socket.", e2);
                this.keepRunning = false;
                return;
            }
            try {
                try {
                    serverSocket.setSoTimeout(1000);
                }
                catch (SocketException e3) {
                    LogLog.error("exception setting timeout, shutting down server socket.", e3);
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e4) {
                        // empty catch block
                    }
                    return;
                }
                while (this.keepRunning) {
                    Socket socket = null;
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (InterruptedIOException e5) {
                    }
                    catch (SocketException e6) {
                        LogLog.error("exception accepting socket, shutting down server socket.", e6);
                        this.keepRunning = false;
                    }
                    catch (IOException e7) {
                        LogLog.error("exception accepting socket.", e7);
                    }
                    if (socket == null) continue;
                    try {
                        InetAddress remoteAddress = socket.getInetAddress();
                        LogLog.debug("accepting connection from " + remoteAddress.getHostName() + " (" + remoteAddress.getHostAddress() + ")");
                        ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
                        this.oosList.addElement(oos);
                    }
                    catch (IOException e8) {
                        LogLog.error("exception creating output stream on socket.", e8);
                    }
                }
            }
            finally {
                try {
                    serverSocket.close();
                }
                catch (IOException e9) {}
            }
        }
    }
}

