--[[
Methods that are easier to define in Lua.
This also has the superclass setup.

13 Nov 08	drd		Better error handling in doEvery()
18 Aug 08	drd		Animation sequences
22 Apr 08	drd		Created

--]]

if ghf == nil then
	ghf = {}
end
if ghf.Sprite == nil then
	ghf.Sprite = {superclass = ghf.GameNode}
end

--[[
Sample usage:
	sprite:animate(
		{alpha = 0.5, duration = 100},							-- Over 100 ms
		{x = 10, y = 10, style="easeInOut", duration = 50},		-- (ModifierLocationLine)
		{delay = 10},
		{dx = -10, dy = 20},									-- Move immediately by the delta (ModifierLocation)
		{frame = 3},											-- Cell#
		{frame = {...}, loop=2, direction="switch"},			-- Cell#s (ModifierFrame) !!! not implemented
		{delay = waitFunction},									-- Delay until waitFunction(sprite) returns false
		{														-- Nested table means the two actions happen at the same time
			{sprite = s1, visible = true},
			{sprite = s2, visible = false}
		},
		{rotation = 45},
		{drotation = -45, duration = 1000},
		{skew = 0.1, duration = 500},
		{dskew = 0.05, duration = 200},
		{skewx = 0.5, skewy = -0.1, duration = 200},
		{path={...}, loop=true},								-- (ModifierLocationPolygonicPath) !!! not implemented
		{call = function() print("Still animating") end},
		{call = function(aSprite) aSprite:setObsolete() end},
		{command = "doSomething"},								-- Receive this in HandleCommand(command, sprite)
		{command = "doSomething", target = dialog}
	)

Note that although this is a Sprite method, this is only for convenience; modifiers
will be added to AnimTree and not a Sprite
--]]
function ghf.Sprite:animate(...)
	local	nArgs = select('#', ...)

	-- See if we're passed a single argument which is an array of animations
	if nArgs == 1 then
		local	firstArg = select(1, ...)
		if type(firstArg) == "table" then
			local	subArg = firstArg[1]
			if type(subArg) == "table" then
				self:animate(unpack(firstArg))
				return
			end
		end
	end

	-- Validate arguments
	for i = 1, nArgs do
		local	arg = select(i, ...)	-- Get i-th parameter
		if type(arg) ~= "table" then
			error("Must specify each animation as a table", 2)
		end
	end

	self:beginAnimation()
	for i = 1, nArgs do
		local	arg = select(i, ...)	-- Get i-th parameter
		local	s
		if arg == nil then
			print("ERROR: nil action")
		else
			if #arg == 0 then
				self:addSequentialAnimation(i, arg)
			else
				self:beginSimultaneousAnimation()
				local	j, a
				for j, a in ipairs(arg) do
					if a == nil then
						print("ERROR: nil action in simultaneous group")
					else
						self:addSequentialAnimation(0, a)
					end
				end
				self:endSimultaneousAnimation()
			end
		end
	end
end

function ghf.Sprite:doEveryTick(aFunction)
	function self:tick(time)
		aFunction(time)
	end	
end

function ghf.Sprite:doEvery(aMilliseconds, aFunction)
	if aMilliseconds < 0 then
		error("doEvery time can't be negative (" .. aMilliseconds .. ")")
	end

	self:animate(
		{delay = aMilliseconds},
		{call = function()
			local	success, d = pcall(aFunction)
			if success == false then
				print("doEvery:", d)
				error(d)
			end
			if d == false then
				return
			end
			if d == nil then
				d = aMilliseconds
			end
			self:doEvery(d, aFunction)
		end}
	)
end

-------------------

if ghf.Button == nil then
	ghf.Button = {superclass = ghf.Sprite}
end

-------------------

if ghf.Label == nil then
	ghf.Label = {superclass = ghf.Sprite}
end

-------------------

if ghf.Dialog == nil then
	ghf.Dialog = {superclass = ghf.Sprite}
end

-------------------

if ghf.DiaRestaurantSelectionlog == nil then
	ghf.RestaurantSelection = {superclass = ghf.Sprite}
end

-------------------

if ghf.Calender == nil then
	ghf.Calender = {superclass = ghf.Sprite}
end
