--=============================================================================
-- Global helper functions
--=============================================================================
function transitionAnimation()
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)

	local background = scene:child("BACKGROUND")
	background:animate(	
		{delay=1000},
		{command="play", target=background}
	)
end

function showMapScene()
	local background = scene:child("BACKGROUND")
	local black = scene:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})

	black:animate(
		{alpha=1, duration=1000},
		{command="clear", target=background},
		{command="endMovie", target=background},
		{command="updateObjects", target=background},
		{command="updateLayout", target=background},
		{command="enableInput", target=background},
		{alpha=0, duration=1000},
		{call=function() black:setObsolete() end }
	)
end

function addBars(parent)
	local bar1 = parent:newChildSprite({x=0, y=0, image="BLACK_BEAM", section="interstitial"})
	local bar2 = parent:newChildSprite({x=0, y=520, image="BLACK_BEAM", section="interstitial"})
	bar1:setAlpha(0)
	bar2:setAlpha(0)
	return bar1, bar2
end

function moveCalender(onscreen)
	local calender = scene:child("CALENDER")
	if (onscreen) then
		calender:animate({x=535, duration=500})
	else
		calender:animate({x=800, duration=500})
	end
	calender:setEnabled(onscreen)
end

function moveRestSelection(onscreen)
	local restSelection = scene:child("RESTAURANT_SELECTION")
	if (onscreen) then
		restSelection:animate({y=0, duration=500})
	else
		restSelection:animate({y=-restSelection:height(), duration=500})
	end
	restSelection:setEnabled(onscreen)
end

function moveButtons(onscreen)
	local shop = scene:child("BUTTON_SHOP")
	local start = scene:child("BUTTON_START")
	local movie = scene:child("BUTTON_MOVIE")
	local trophy = scene:child("BUTTON_TROPHY")
	local guibar = scene:child("GUIBAR")
	local h = 600 - guibar:height()

	if (onscreen) then
		shop:animate({x=shop:x(), y=580, duration=500})
		start:animate({x=start:x(), y=580, duration=500})
		trophy:animate({x=trophy:x(), y=580, duration=500})
		movie:animate({x=movie:x(), y=580, duration=500})
		guibar:animate({x=guibar:x(), y=h, duration=500})		
	else
		shop:animate({x=shop:x(), y=700, duration=500})
		start:animate({x=start:x(), y=700, duration=500})
		trophy:animate({x=trophy:x(), y=700, duration=500})
		movie:animate({x=movie:x(), y=700, duration=500})
		guibar:animate({x=guibar:x(), y=h + 120, duration=500})		
	end
end

function lerp(val1, val2, fact)
	return val1 + fact * (val2 - val1)
end

function jcurve(fact)
	return fact * fact
end

function rcurve(fact)
	local temp = (fact - 1.0)
	temp = temp * temp
	return 1.0 - temp
end

function scurve(fact)
	local temp = (3 - fact - fact)
	temp = temp * fact * fact
	return temp
end

--=============================================================================
-- Drive-thru scene
--=============================================================================
restaurant0 = {}

restaurant0.sceneRoot = nil
restaurant0.rootIntro = nil
restaurant0.introNode = nil

restaurant0.signBlink = nil
restaurant0.blinkNoiseDelay = 0
restaurant0.carLight = nil
restaurant0.carLightBack = nil
restaurant0.hood = nil
restaurant0.smokeRoot = nil
restaurant0.particleRoot = nil
restaurant0.shadowCar = nil
restaurant0.shadowTruck = nil

restaurant0.frameTimer = 0

restaurant0.frame = {}

restaurant0.carSoundLoopBase = nil
restaurant0.carSoundLoopCount = 0
restaurant0.carSoundLoopCountToMax = 2
restaurant0.carSoundLoopCountStartFadeout = 10
restaurant0.carSoundLoopCountEndFadeout = 12

function restaurant0.carSoundLoop()
	local volume = 1.0
	restaurant0.carSoundLoopCount = restaurant0.carSoundLoopCount + 1
	if (restaurant0.carSoundLoopCount < restaurant0.carSoundLoopCountToMax) then
	elseif (restaurant0.carSoundLoopCount >= restaurant0.carSoundLoopCountStartFadeout) then
		if (restaurant0.carSoundLoopCount >= restaurant0.carSoundLoopCountEndFadeout) then
			restaurant0.carSoundLoopBase:doEvery(0, nil)
		end
	end
	-- This is dodgy...  I know the sound is 5 seconds long...
	return 5000
end

function restaurant0:simpleAnimation()
	local background = scene:child("BACKGROUND")
	local black = background:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	
	black:animate(		
		{alpha=1, duration=1000},
		{command="updateObjects", target=background},
		{command="updateBackground", target=background},	
		{alpha=0, duration=1000},
		{call=function() 
			moveCalender(true)
			moveButtons(true)
			moveRestSelection(true)
			black:setObsolete() end}			
	)
end

function restaurant0:extendedAnimation()
	restaurant0.sceneRoot = scene:child("BACKGROUND")
	local intro0, xPos = restaurant0:setupScene(restaurant0.sceneRoot)
	intro0:setAlpha(0)
	local white = restaurant0.sceneRoot:newChildSprite({x=0, y=0, image="FAKE_STEAM", section="sceneintroduction"})
	white:setAlpha(0)
	white:setScale(200)
	local label = scene:child("DAYS_AGO")
	--label:moveInFrontOf(white)
	local black = restaurant0.sceneRoot:newChildSprite({x=0, y=0, image="INTRO_LEFT", section="sceneintroduction"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	local bar1, bar2 = addBars(restaurant0.sceneRoot)
	
	restaurant0:setupFrames()
	
	intro0:relocatePivotPoint(139, 203)
	intro0:setScale(3.11)
	
	local carSoundRoot = restaurant0.sceneRoot:newChildSprite({x=0, y=0})
	
	black:animate(
		{alpha=1, duration=1000},
		{delay=1000},
		{alpha=0, duration=2000},
		{call=function() black:setObsolete() end}
	)
	label:animate(
		{delay=3000},
		{
			{visible=true},
			{alpha=1, duration=500},
			{sound="SOUND_SOMETIMEAGO:sceneintroduction"},
		},
		{delay=4000},
		{
			{alpha=0, sprite=label, duration=1000},
			{alpha=0, duration=1000, sprite=white},
		},
		{delSound="SOUND_BROKENCAR_LOOP", section="sceneintroduction", fadeInTime=1000, maxVolTime=10000, fadeOutTime=3000, sprite=scene, target=carSoundRoot}
	)
	scene:animate(
		{delay=1000},
		{alpha=1, sprite=bar1},
		{alpha=1, sprite=bar2},
		{alpha=1, sprite=white},
		{alpha=1, sprite=intro0},
		{particle="PARTICLE_CARSMOKE", section="sceneselection", target=restaurant0.smokeRoot},
		{particle="PARTICLE_CARSPARKLES", section="sceneselection", target=restaurant0.sparksRoot},
		{command="updateObjects", target=restaurant0.sceneRoot},
		--{command="playMusic track=INTRO_MUSIC section=interstitial", target=restaurant0.sceneRoot},
		{delay=7000},
		{call=function() restaurant0.rootIntro:doOften(frame1) end},
		--{sound="SOUND_BROKENCAR_LOOP:sceneintroduction"},
		{delay=1000},
		{call=function() white:setObsolete() end}
	)
	
	restaurant0.blinkNoiseDelay = 21000
	restaurant0.signBlink:doOften(updateSignTimer)
end

function restaurant0:setupScene(parent)
	if (parent ~= nil) then
		local intro1 = parent:newChildSprite({x=0, y=0})
		local intro2 = intro1:newChildSprite({x=0, y=0, image="INTRO_LEFT", section="sceneintroduction"})
		local xPos = intro2:width() - 10
		local intro3 = intro2:newChildSprite({x=xPos, y=0, image="INTRO_MIDDLE_0", section="sceneintroduction"})
		xPos = xPos + intro3:width() - 10
		local intro4 = intro2:newChildSprite({x=xPos, y=0, image="INTRO_RIGHT", section="sceneintroduction"})
		restaurant0.rootIntro = intro1
		restaurant0.introNode = intro2
		
		restaurant0.signBlink = intro2:newChildSprite({x=1712.0, y=288.0, image="INTRO_BETTY_SIGN", section="sceneintroduction"})
		restaurant0.signBlink:setAlpha(0)
		restaurant0.signBlink:doEvery(0, restaurant0.blinkSign)
		
		restaurant0.smokeRoot	= restaurant0.introNode:newChildSprite({x=547, y=496})
		restaurant0.hood		= restaurant0.introNode:newChildSprite({x=494, y=409, image="INTRO_CAR_HOOD", section="sceneintroduction"})
		restaurant0.sparksRoot	= restaurant0.introNode:newChildSprite({x=544, y=424})
		
		restaurant0.luggageLidBase = restaurant0.introNode:newChildSprite({x=578, y=263})
		restaurant0.luggageLid	= restaurant0.luggageLidBase:newChildSprite({x=0, y=0, image="INTRO_LUGGAGE_LID", section="sceneintroduction"})
		restaurant0.luggageLid:setPivotPoint(19, 10)
		restaurant0.luggageLid.clockwise = false
		restaurant0.luggageLid.rotTime = 0
		
		restaurant0.luggageLidBase:doOften(dangleLid)
		
		restaurant0.shadowCar = restaurant0.rootIntro:newChildSprite({x=-550.0, y=330.0, image="INTRO_CAR", section="sceneintroduction"})
		restaurant0.shadowTruck = restaurant0.rootIntro:newChildSprite({x=-550.0, y=300.0, image="INTRO_TRUCK", section="sceneintroduction"})
		
		restaurant0.shadowCar:setAlpha(0)
		restaurant0.shadowTruck:setAlpha(0)
		
		-- Bird
		local bird = intro2:newChildSprite({x=755, y=224, image="BIRD", section="sceneintroduction"})
		bird:animate(
			{delay=17500},
			{startframe=0, frametime=500}
		)
		
		restaurant0.carLight = intro2:newChildSprite({x=529, y=439, image="CAR_BLINK",		section="sceneintroduction"})
		restaurant0.carLightBack = intro2:newChildSprite({x=319, y=418, image="CAR_BLINK_BACK", section="sceneintroduction"})
		restaurant0.carLight:setAlpha(0)
		restaurant0.carLightBack:setAlpha(0)
		restaurant0.carLight:doEvery(0, restaurant0.blinkLight)
		return intro1, xPos
	end
	return nil, 0
end

function frame1(obj, time)
	
	if (restaurant0:frameUpdate(1, time)) then
		restaurant0:onFrameComplete(1)
		obj:animate(
			restaurant0.rootIntro:doOften(frame2)
		)
	end

end

function frame2(obj, time)

	if (restaurant0:frameUpdate(2, time)) then
		obj:animate(
			restaurant0.rootIntro:doOften(frame3)
		)
	end

end

function frame3(obj, time)

	if (restaurant0:frameUpdate(3, time)) then
		obj:animate(
			restaurant0.rootIntro:doOften(frame4)
		)
	end

end

function frame4(obj, time)

	if (restaurant0:frameUpdate(4, time)) then
		obj:animate(
			restaurant0.rootIntro:doOften(frame5)
		)
	end

end

function frame5(obj, time)

	if (restaurant0:frameUpdate(5, time)) then
		endFrames(obj)
	end

end

function endFrames(obj)

	obj:animate(
		{command="play", target=restaurant0.sceneRoot}
	)
	obj:doOften(nil)
	
end

function getStyleFraction(style, fraction)
	if (style == "easeIn") then
		return jcurve(fraction)
	end
	if (style == "easeOut") then
		return rcurve(fraction)
	end
	if (style == "easeInOut") then
		return scurve(fraction)
	end
	return fraction
end

function restaurant0:frameUpdate(frameNumber, time)
	local ended = false
	if (frameNumber <= 5) then
		local fraction = 0.0
		local frameInfo = restaurant0.frame[frameNumber]
		
		restaurant0.frameTimer = restaurant0.frameTimer + time
		if (restaurant0.frameTimer < frameInfo.duration) then
			fraction = restaurant0.frameTimer / frameInfo.duration
		else
			fraction = 1.0
			ended = true
		end
		
		if (ended) then
			restaurant0.rootIntro:relocatePivotPoint(frameInfo.endPivotX, frameInfo.endPivotY)
			restaurant0.rootIntro:setScale(frameInfo.endScale)
			restaurant0.introNode:setX(frameInfo.endPosX)
			restaurant0.frameTimer = 0
		else
			-- Sort out the style
			local pivotFraction = getStyleFraction(frameInfo.pivotStyle, fraction)
			local scaleFraction = getStyleFraction(frameInfo.scaleStyle, fraction)
			local posFraction = getStyleFraction(frameInfo.posStyle, fraction)
			
			-- Now the params
			local xPos = lerp(frameInfo.startPosX, frameInfo.endPosX, posFraction)
			local scale = lerp(frameInfo.startScale, frameInfo.endScale, scaleFraction)
			local pivotPosX = lerp(frameInfo.startPivotX, frameInfo.endPivotX, pivotFraction)
			local pivotPosY = lerp(frameInfo.startPivotY, frameInfo.endPivotY, pivotFraction)
			
			restaurant0.rootIntro:setPivotPoint(pivotPosX, pivotPosY)
			restaurant0.rootIntro:setScale(scale)
			restaurant0.introNode:setX(xPos)
		end
	else
		ended = true
	end
	
	return ended
end

function restaurant0:onFrameComplete(frameNumber)
	if (frameNumber == 1) then
		-- Sort out the car & truck
		restaurant0.shadowCar:setAlpha(1)
		restaurant0.shadowTruck:setAlpha(1)
		
		restaurant0.shadowCar:animate(
			{delay=10150},
			{sound="SOUND_CARDRIVINGBY_1:sceneintroduction"},
			{delay=400},
			{x=1600, duration=600}
		)
		
		restaurant0.shadowTruck:animate(
			{delay=13300},
			{sound="SOUND_CARDRIVINGBY_2:sceneintroduction"},
			{delay=400},
			{x=1600, duration=800}
		)
	end
end

function restaurant0:setupFrames()

	restaurant0.frame[1] = {}
	restaurant0.frame[1].duration = 2000
	restaurant0.frame[1].startPosX = 0.0
	restaurant0.frame[1].endPosX = -10.0
	restaurant0.frame[1].startPivotX = 139
	restaurant0.frame[1].startPivotY = 203
	restaurant0.frame[1].endPivotX = 190
	restaurant0.frame[1].endPivotY = 250
	restaurant0.frame[1].startScale = 3.11
	restaurant0.frame[1].endScale = 2.22
	restaurant0.frame[1].pivotStyle = "easeIn"
	restaurant0.frame[1].scaleStyle = "easeIn"
	restaurant0.frame[1].posStyle = "easeIn"
	
	restaurant0.frame[2] = {}
	restaurant0.frame[2].duration = 4600
	restaurant0.frame[2].startPosX = -10.0
	restaurant0.frame[2].endPosX = -40.0
	restaurant0.frame[2].startPivotX = 190
	restaurant0.frame[2].startPivotY = 250
	restaurant0.frame[2].endPivotX = 500
	restaurant0.frame[2].endPivotY = 500
	restaurant0.frame[2].startScale = 2.22
	restaurant0.frame[2].endScale = 1.21
	restaurant0.frame[2].pivotStyle = "easeOut"
	restaurant0.frame[2].scaleStyle = "easeOut"
	restaurant0.frame[2].posStyle = "easeOut"
	
	restaurant0.frame[3] = {}
	restaurant0.frame[3].duration = 4150
	restaurant0.frame[3].startPosX = -40.0
	restaurant0.frame[3].endPosX = -560.0
	restaurant0.frame[3].startPivotX = 500
	restaurant0.frame[3].startPivotY = 500
	restaurant0.frame[3].endPivotX = 50
	restaurant0.frame[3].endPivotY = 500
	restaurant0.frame[3].startScale = 1.21
	restaurant0.frame[3].endScale = 1.11
	restaurant0.frame[3].pivotStyle = "easeIn"
	restaurant0.frame[3].scaleStyle = "easeIn"
	restaurant0.frame[3].posStyle = "easeIn"
	
	restaurant0.frame[4] = {}
	restaurant0.frame[4].duration = 8500
	restaurant0.frame[4].startPosX = -560.0
	restaurant0.frame[4].endPosX = -1310.0
	restaurant0.frame[4].startPivotX = 50
	restaurant0.frame[4].startPivotY = 500
	restaurant0.frame[4].endPivotX = 500
	restaurant0.frame[4].endPivotY = 400
	restaurant0.frame[4].startScale = 1.11
	restaurant0.frame[4].endScale = 1.11
	restaurant0.frame[4].pivotStyle = "easeOut"
	restaurant0.frame[4].scaleStyle = ""
	restaurant0.frame[4].posStyle = "easeOut"
	
	restaurant0.frame[5] = {}
	restaurant0.frame[5].duration = 4200
	restaurant0.frame[5].startPosX = -1310.0
	restaurant0.frame[5].endPosX = -1310.0
	restaurant0.frame[5].startPivotX = 500
	restaurant0.frame[5].startPivotY = 400
	restaurant0.frame[5].endPivotX = 650
	restaurant0.frame[5].endPivotY = 400
	restaurant0.frame[5].startScale = 1.11
	restaurant0.frame[5].endScale = 2.57
	restaurant0.frame[5].pivotStyle = "easeOut"
	restaurant0.frame[5].scaleStyle = "easeIn"
	restaurant0.frame[5].posStyle = ""
	
end

function updateSignTimer(self, timer)
	restaurant0.blinkNoiseDelay = restaurant0.blinkNoiseDelay - timer
end

function restaurant0:blinkSign()
	local showTime = math.random(100, 400)
	local hideTime = math.random(1000, 3000)
	
	if (restaurant0.signBlink ~= nil) then
		if (restaurant0.blinkNoiseDelay > 0) then
			restaurant0.signBlink:animate(
				{alpha=1},
				{delay=showTime},
				{alpha=0}
			)
		else
			restaurant0.signBlink:animate(
				{sound="SOUND_NEONLETTER:sceneintroduction"},
				{delay=200},
				{alpha=1},
				{delay=showTime},
				{alpha=0}
			)
			showTime = showTime + 200
		end
	end
	
	return (hideTime + showTime)
end

function restaurant0:blinkLight()
	local showTime = 500
	local hideTime = 500
	
	if (restaurant0.carLight ~= nil) then
		restaurant0.carLight:animate(
			{alpha=1},
			{delay=showTime},
			{alpha=0}
		)
	end
	
	if (restaurant0.carLightBack ~= nil) then
		restaurant0.carLightBack:animate(
			{alpha=1},
			{delay=showTime},
			{alpha=0}
		)
	end
	
	return (hideTime + showTime)
end

function calcSwingFraction(currTime, swingMaxTime)
	local fraction = currTime
	while (fraction > swingMaxTime) do
		fraction = fraction - swingMaxTime
	end
	fraction = fraction / swingMaxTime
	return math.sin(2.0 * math.pi * ((fraction - 0.5) * 2.0))
end

function dangleLid(obj, time)
	if (restaurant0.luggageLid ~= nil) then
		restaurant0.luggageLid.rotTime = restaurant0.luggageLid.rotTime + time
		local fraction = calcSwingFraction(restaurant0.luggageLid.rotTime, 2000)
		restaurant0.luggageLid:setRotation(fraction * 0.17)
	end
end
