restaurant1 = {}

restaurant1.sceneRoot = nil
restaurant1.introBackground = nil
restaurant1.crowBase = nil
restaurant1.windmill = nil

restaurant1.suitcase = nil
restaurant1.towTruck = nil
restaurant1.towWheel1 = nil
restaurant1.towWheel2 = nil
restaurant1.towRim1 = nil
restaurant1.towRim2 = nil
restaurant1.towWheelSuspension1 = nil
restaurant1.towWheelSuspension2 = nil
restaurant1.towDriver = nil
restaurant1.towCable = nil

restaurant1.emilyCarFrameBase = nil
restaurant1.emilyCar = nil
restaurant1.emilyCarInterior = nil
restaurant1.emily = nil
restaurant1.emilyCarExhaust = nil
restaurant1.emilyCarExhaustSparks = nil
restaurant1.emilyWheelSuspension1 = nil
restaurant1.emilyCarWheel1 = nil
restaurant1.emilyCarWheel2 = nil

restaurant1.crowCount = 0

function restaurant1:extendedAnimation()
	restaurant1.sceneRoot = scene:child("BACKGROUND")
	local intro1, xPos = restaurant1:setupScene(restaurant1.sceneRoot)
	intro1:setAlpha(0)
	local black = restaurant1.sceneRoot:newChildSprite({x=0, y=0, image="INTRO_FARM_4", section="interstitial1"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	local bar1, bar2 = addBars(restaurant1.sceneRoot)
	
	restaurant1.introBackground = intro1
	
	local car = restaurant1:setupCar(restaurant1.sceneRoot)
	--restaurant1:createCrows()
	
	local endPos = xPos
	local tempPos = endPos - 100
	local moveSpeed = 11000 / endPos
	
	restaurant1.crowCount = 0
	intro1:doEvery(0.8 * (moveSpeed*tempPos), restaurant1.spawnCrow)
	
	black:animate(
		{alpha=1, duration=1000},
		{command="updateObjects", target=restaurant1.sceneRoot},
		--{command="playMusic track=INTRO_MUSIC section=interstitial1", target=restaurant1.sceneRoot},
		{call=function() intro1:setAlpha(1) bar1:setAlpha(1) bar2:setAlpha(1) end},
		{call=function()
			car:animate({x=390, duration=3045})
			end
		},
		{
			{alpha=0, duration=1000},
			{call=function()
				intro1:animate(
					{call=function() restaurant1:spawnFirstCrow() end},
					{sound="SOUND_TOWING:interstitial1"},
					{x=-tempPos, duration=moveSpeed*tempPos},
					{x=-endPos, duration=moveSpeed*200, style="easeOut"},
					{call=function() intro1:relocatePivotPoint((xPos + 400), 425) end},
					{scale=1.5, duration=2500, style="easeInOut"},
					{command="play", target=restaurant1.sceneRoot}
				)
				car:animate(
					{x=1300, duration=6000}
				)
				end
			}
		},
		{call=function() black:setObsolete() end}
	)
end

function restaurant1:setupScene(parent)
	if (parent ~= nil) then
		local intro1 = parent:newChildSprite({x=0, y=0, image="INTRO_FARM_1", section="interstitial1"})
		local xPos = intro1:width() - 10
		local intro2 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_FARM_2", section="interstitial1"})
		xPos = xPos + intro2:width() - 10
		local intro3 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_FARM_3", section="interstitial1"})
		xPos = xPos + intro3:width() - 10
		local intro4 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_FARM_4", section="interstitial1"})
		restaurant1.windmill = intro1:newChildSprite({x=1955, y=296, image="INTRO_WINDMILL", section="interstitial1", anchorpoint="center"})
		restaurant1.windmill.moveTimer = 5000
		--restaurant1.crowBase = intro1:newChildSprite({x=666, y=361})
		--local corn = intro1:newChildSprite({x=666, y=361, image="INTRO_CORN", section="interstitial1"})
		intro1:doEvery(restaurant1.windmill.moveTimer, restaurant1.spinWindmill)
		return intro1, xPos
	end
	return nil, 0
end

function restaurant1:setupCar(parent)

	if (parent ~= nil) then
		-- base sprite for everything
		local base = parent:newChildSprite({x=-400, y=290})
		-- tow truck
		local towDriverBase = base:newChildSprite({x=202, y=120})
		restaurant1.towDriver = towDriverBase:newChildSprite({x=0, y=0, image="INTRO_TOW_DRIVER", section="interstitial1", anchorpoint="bottom"})
		restaurant1.towDriver.moveTimer = 50
		restaurant1.towDriver.currTimer = 0
		
		local towTruckBase = base:newChildSprite({x=167, y=223})
		local towWheelBase = towTruckBase:newChildSprite({x=-5, y=-15, image="INTRO_TOW_WHEELBASE", section="interstitial1", anchorpoint="bottom", name="TOW_WHEELBASE"})
		--restaurant1.towTruck = towTruckBase:newChildSprite({x=0, y=0, image="INTRO_TOW_TRUCK", section="interstitial1", anchorpoint="bottom"})
		restaurant1.towTruck = towTruckBase
		restaurant1.towTruck.moveTimer = 50
		restaurant1.towTruck.currTimer = 0
		local towTruckShell = towTruckBase:newChildSprite({x=0, y=0, image="INTRO_TOW_TRUCK", section="interstitial1", anchorpoint="bottom"})
		restaurant1.towCable = restaurant1.towTruck:newChildSprite({x=-149, y=-214, image="INTRO_TOW_ROPE", section="interstitial1", anchorpoint="topright"})
		
		local towWheelAxle1 = towWheelBase:newChildSprite({x=-105, y=-20})
		local towWheelAxle2 = towWheelBase:newChildSprite({x=120, y=-20})
		restaurant1.towWheelSuspension1 = towWheelBase:newChildSprite({x=-105, y=-20})
		restaurant1.towWheelSuspension2 = towWheelBase:newChildSprite({x=120, y=-20})
		restaurant1.towWheel1 = restaurant1.towWheelSuspension1:newChildSprite({x=0, y=0, image="INTRO_WHOLE_WHEEL", section="interstitial1", anchorpoint="center"})
		restaurant1.towWheel2 = restaurant1.towWheelSuspension2:newChildSprite({x=0, y=0, image="INTRO_WHOLE_WHEEL", section="interstitial1", anchorpoint="center"})
		
		restaurant1.towWheel1:setPivotPoint({x=31, y=31})
		restaurant1.towWheel2:setPivotPoint({x=31, y=31})
		
		local towRim1 = restaurant1.towWheelSuspension1:newChildSprite({x=0, y=0, image="INTRO_RIM", section="interstitial1", anchorpoint="center"})
		local towRim2 = restaurant1.towWheelSuspension2:newChildSprite({x=0, y=0, image="INTRO_RIM", section="interstitial1", anchorpoint="center"})
		
		
		-- animate the wheels...
		towWheelBase:doEvery(500, restaurant1.spinTowWheels)
		restaurant1.towWheelSuspension1.bounceTimer = 100
		restaurant1.towWheelSuspension2.bounceTimer = 100
		towWheelAxle1:doEvery(100, restaurant1.bounceTowWheel1)
		towWheelAxle2:doEvery(100, restaurant1.bounceTowWheel2)
		-- ...and the driver...
		towDriverBase:doEvery(restaurant1.towDriver.moveTimer, restaurant1.moveDriver)
		-- and the tow truck...
		towTruckBase:doEvery(restaurant1.towTruck.moveTimer, restaurant1.moveTruck)
		
		-- car
		local carExhaustBase = base:newChildSprite({x=-94, y=140})
		local carWheelBase = base:newChildSprite({x=-195, y=235})
		local carBase = base:newChildSprite({x=-195, y=235})
		local carWheelAxle1 = carWheelBase:newChildSprite({x=-87, y=-121, image="INTRO_CAR_WHEELARCHES", section="interstitial1", name="WHEELARCHES"})
		
		restaurant1.emilyCarFrameBase = carBase:newChildSprite({x=0, y=0})
		restaurant1.emilyCarInterior = restaurant1.emilyCarFrameBase:newChildSprite({x=-3, y=-128, image="INTRO_CAR_INTERIOR", section="interstitial1", anchorpoint="bottom"})
		local steeringWheel = restaurant1.emilyCarFrameBase:newChildSprite({x=39, y=-138, image="INTRO_STEERING_WHEEL", section="interstitial1", anchorpoint="bottom"})
		restaurant1.emily = restaurant1.emilyCarFrameBase:newChildSprite({x=5, y=-119, image="INTRO_EMILY", section="interstitial1", anchorpoint="bottom"})
		restaurant1.suitcase = restaurant1.emilyCarFrameBase:newChildSprite({x=-138, y=-286, image="INTRO_SUITCASE", section="interstitial1", anchorpoint="top"})
		restaurant1.emilyCar = restaurant1.emilyCarFrameBase:newChildSprite({x=0, y=0, image="INTRO_CAR", section="interstitial1", anchorpoint="bottom"})
		restaurant1.emilyCarExhaust = carExhaustBase:newChildSprite({x=0, y=0, image="INTRO_BROKEN_EXHAUST", section="interstitial1", anchorpoint="topright"})
		restaurant1.emilyCarExhaustSparks = carBase:newChildSprite({x=-78, y=-12})
		restaurant1.emilyWheelSuspension1 = carWheelAxle1:newChildSprite({x=0, y=0})
		restaurant1.emilyCarWheel1 = restaurant1.emilyWheelSuspension1:newChildSprite({x=34, y=80, image="INTRO_WHOLE_WHEEL", section="interstitial1", anchorpoint="center"})
		restaurant1.emilyCarWheel2 = carWheelBase:newChildSprite({x=101, y=-82, image="INTRO_BROKEN_WHEEL", section="interstitial1", anchorpoint="center"})
		
		restaurant1.emilyCarWheel1:setPivotPoint({x=31, y=31})
		
		local emilyRim1 = restaurant1.emilyWheelSuspension1:newChildSprite({x=34, y=80, image="INTRO_RIM", section="interstitial1", anchorpoint="center"})
		
		restaurant1.emilyCar.currTimer = 0
		restaurant1.emilyCar.moveTimer = 100
		restaurant1.emilyCarWheel1.moveTimer = 0
		restaurant1.emilyWheelSuspension1.bounceTimer = 100
		restaurant1.emilyCarWheel2.clockwise = false
		
		restaurant1.suitcase.moveTimer = 500
		restaurant1.suitcase.clockwise = false
		
		restaurant1.emilyCarExhaust.clockwise = false
		restaurant1.emilyCarExhaust.moveTimer = 100
		
		carBase:doEvery(restaurant1.emilyCar.moveTimer, restaurant1.bounceEmilyCar)
		restaurant1.emilyCarFrameBase:doEvery(restaurant1.suitcase.moveTimer, restaurant1.moveSuitcase)
		carExhaustBase:doEvery(restaurant1.emilyCarExhaust.moveTimer, restaurant1.bounceExhaust)
		carWheelAxle1:doEvery(restaurant1.emilyWheelSuspension1.bounceTimer, restaurant1.bounceCarWheel1)
		carWheelBase:doEvery(500, restaurant1.spinCarWheels)
		
		return base
	end
	return nil
end

function restaurant1:simpleAnimation()
	local background = scene:child("BACKGROUND")
	local black = background:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	
	black:animate(		
		{alpha=1, duration=1000},
		{command="updateObjects", target=background},
		{command="updateBackground", target=background},	
		{alpha=0, duration=1000},
		{call=function() 
			moveCalender(true)
			moveButtons(true)
			moveRestSelection(true)
			black:setObsolete() end}
	)
end


--===================================================
--=
--===================================================
function restaurant1:spinTowWheels()
	
	if (restaurant1.towWheel1 ~= nil) then
		restaurant1.towWheel1:animate({drotation=360, duration=500})
	end
	
	if (restaurant1.towWheel2 ~= nil) then
		restaurant1.towWheel2:animate({drotation=360, duration=500})
	end
	
end

function restaurant1:bounceTowWheel1()
	if (restaurant1.towWheelSuspension1 ~= nil) then
		local startY = restaurant1.towWheelSuspension1:y()
		local endY = math.random(startY - 15, startY)
		local bumpDuration = math.random(100, 150)
		restaurant1.towWheelSuspension1:animate(
			{y=endY, duration=bumpDuration},
			{y=startY, duration=bumpDuration}
		)
		restaurant1.towWheelSuspension1.bounceTimer = math.random(300, 900)
		return restaurant1.towWheelSuspension1.bounceTimer
	end
end

function restaurant1:bounceTowWheel2()
	if (restaurant1.towWheelSuspension2 ~= nil) then
		local startY = restaurant1.towWheelSuspension2:y()
		local endY = math.random(startY - 15, startY)
		local bumpDuration = math.random(100, 150)
		restaurant1.towWheelSuspension2:animate(
			{y=endY, duration=bumpDuration},
			{y=startY, duration=bumpDuration}
		)
		restaurant1.towWheelSuspension2.bounceTimer = math.random(300, 900)
		return restaurant1.towWheelSuspension2.bounceTimer
	end
end

function restaurant1:bounceCarWheel1()

	if (restaurant1.emilyWheelSuspension1 ~= nil) then
		local startY = restaurant1.emilyWheelSuspension1:y()
		local endY = math.random(startY - 15, startY)
		local bumpDuration = math.random(100, 150)
		restaurant1.emilyWheelSuspension1:animate(
			{y=endY, duration=bumpDuration},
			{y=startY, duration=bumpDuration}
		)
		restaurant1.emilyWheelSuspension1.bounceTimer = math.random(300, 900)
		return restaurant1.emilyWheelSuspension1.bounceTimer
	end
	
end

function restaurant1:spinCarWheels()

	if (restaurant1.emilyCarWheel1 ~= nil) then
		restaurant1.emilyCarWheel1:animate({drotation=360, duration=500})
	end
	
	if (restaurant1.emilyCarWheel2 ~= nil) then
		local rot = 15
		if (restaurant1.emilyCarWheel2.clockwise) then
			rot = -rot
			restaurant1.emilyCarWheel2.clockwise = false
		else
			restaurant1.emilyCarWheel2.clockwise = true
		end
		restaurant1.emilyCarWheel2:animate({rotation=rot, duration=500, style="easeInOut"})
	end
end

function restaurant1:bounceEmilyCar()
	if (restaurant1.emilyCar ~= nil) then
	
		restaurant1.emilyCar.currTimer = restaurant1.emilyCar.currTimer - restaurant1.emilyCar.moveTimer
		if (restaurant1.emilyCar.currTimer <= 0) then
			local delRot = math.random(-2, 2)
			local delY = math.random(0, 3)
			local startY = restaurant1.emilyCar:y()
			restaurant1.emilyCarFrameBase:animate(
				{
					{drotation=delRot, duration=100, style="easeInOut"},
					{y=startY - delY, duration=100, style="easeInOut"},
				},
				{
					{rotation=0, duration=100, style="easeInOut"},
					{y=startY, duration=100, style="easeInOut"},
				}
			)
			
			-- Now emily
			if (restaurant1.emily ~= nil) then
				local delRot = math.random(-2, 2)
				local delY = math.random(0, 2)
				local startY = restaurant1.emily:y()
				restaurant1.emily:animate(
					{
						{drotation=delRot, duration=95, style="easeInOut"},
						{y=startY - delY, duration=95, style="easeInOut"},
					},
					{
						{rotation=0, duration=95, style="easeInOut"},
						{y=startY, duration=95, style="easeInOut"},
					}
				)
			end
			
			if (restaurant1.suitcase ~= nil) then
				
			end
			
			restaurant1.emilyCar.currTimer = math.random(200, 310)
		end
		
	end
end

function restaurant1:moveSuitcase()
	if (restaurant1.suitcase ~= nil) then
		local rot = 10
		if (restaurant1.suitcase.clockwise) then
			rot = -rot
			restaurant1.suitcase.clockwise = false
		else
			restaurant1.suitcase.clockwise = true
		end
		restaurant1.suitcase.moveTimer = math.random(400, 800)
		restaurant1.suitcase:animate({rotation=rot, duration=restaurant1.suitcase.moveTimer, style="easeInOut"})
		return restaurant1.suitcase.moveTimer
	end
end

function restaurant1:bounceExhaust()
	if (restaurant1.emilyCarExhaust ~= nil) then
		local rot = 3
		if (restaurant1.emilyCarExhaust.clockwise) then
			rot = 0
			restaurant1.emilyCarExhaust.clockwise = false
			-- and trigger the particle effect
			scene:animate(
				{delay=200},
				{particle="EXHAUST_SPARKS", section="interstitial1", looped=false, target=restaurant1.emilyCarExhaustSparks}
			)
		else
			restaurant1.emilyCarExhaust.clockwise = true
		end
		restaurant1.emilyCarExhaust.moveTimer = math.random(100, 300)
		restaurant1.emilyCarExhaust:animate({rotation=rot, duration=restaurant1.emilyCarExhaust.moveTimer, style="easeInOut"})
		return restaurant1.emilyCarExhaust.moveTimer
	end
end

function restaurant1:moveDriver()
	if (restaurant1.towDriver ~= nil) then
		restaurant1.towDriver.currTimer = restaurant1.towDriver.currTimer - restaurant1.towDriver.moveTimer
		if (restaurant1.towDriver.currTimer <= 0) then
			local delRot = math.random(1, 8)
			local delY = math.random(1, 5)
			local delX = math.random(1, 5)
			local startX = restaurant1.towDriver:x()
			local startY = restaurant1.towDriver:y()
			restaurant1.towDriver:animate(
				{
					{drotation=delRot, duration=110},
					{x=startX + delX, duration=80},
					{y=startY - delY, duration=100},
				},
				{
					{rotation=0, duration=110},
					{x=startX, duration=80},
					{y=startY, duration=100},
				}
			)
			restaurant1.towDriver.currTimer = math.random(220, 310)
		end
	end
end

function restaurant1:moveTruck()
	if (restaurant1.towTruck ~= nil) then
		restaurant1.towTruck.currTimer = restaurant1.towTruck.currTimer - restaurant1.towTruck.moveTimer
		
		if (restaurant1.towTruck.currTimer <= 0) then
			local delRot = math.random(-4, 4)
			local delY = math.random(1, 3)
			local startY = restaurant1.towTruck:y()
			restaurant1.towTruck:animate(
				{
					{drotation=delRot, duration=180},
					{y=startY - delY, duration=140},
				},
				{
					{rotation=0, duration=150},
					{y=startY, duration=160},
				}
			)
			restaurant1.towTruck.currTimer = math.random(330, 510)
			
			if (restaurant1.towCable ~= nil) then
				restaurant1.towCable:animate(
					{drotation=-delRot, duration=180},
					{rotation=0, duration=140}
				)
			end			
		end
	end
end

function restaurant1:spinWindmill()
	if (restaurant1.windmill ~= nil) then
		restaurant1.windmill:animate(
			{drotation=360, duration=restaurant1.windmill.moveTimer}
		)
	end
end

function restaurant1:spawnCrow()
	
	if (restaurant1.introBackground ~= nil and restaurant1.crowCount < 3) then
		-- just off the screen
		local startX = 805 - restaurant1.introBackground:x()
		local endX = restaurant1.introBackground:x() - 50
		local startY = math.random(85, 200)
		local timeTaken = math.random(15000, 30000)
		local timeFactor = 15000 / timeTaken
		local crowBase = restaurant1.introBackground:newChildSprite({x=startX, y=startY})
		local crow = crowBase:newChildSprite({x=0, y=0, image="INTRO_SPARROW", section="interstitial1"})
		
		crow.bounceHeight = 6 * timeFactor
		crow.bounceTimer = 0
		crow.bounceMaxTimer = 40 * 16 -- Frametime * nr Frames
		
		crow:setScale(timeFactor)
		crowBase:animate(
			{
				{x=endX, duration=timeTaken},
				{startframe=0, frametime=40, loops="forever", sprite=crow},
			},
			{delay=timeTaken + 1000},
			{call=function() crowBase:setObsolete() end}
		)
		
		crow:doOften(bounceBirdy)
		restaurant1.crowCount = restaurant1.crowCount + 1
	end
	return math.random(1000, 1500)
end

function restaurant1:spawnFirstCrow()
	
	if (restaurant1.introBackground ~= nil) then
		-- just off the screen
		local startX = 805
		local endX = -50
		local startY = math.random(75, 200)
		local timeTaken = 4000
		local timeFactor = 4000 / timeTaken
		local crowBase = restaurant1.introBackground:newChildSprite({x=startX, y=startY})
		local crow = crowBase:newChildSprite({x=0, y=0, image="INTRO_SPARROW", section="interstitial1"})
		
		crow.bounceHeight = 6 * timeFactor
		crow.bounceTimer = 0
		crow.bounceMaxTimer = 40 * 16 -- Frametime * nr Frames
		
		crow:setScale(timeFactor)
		crowBase:animate(
			{
				{x=endX, duration=timeTaken},
				{startframe=0, frametime=40, loops="forever", sprite=crow},
			},
			{delay=timeTaken + 1000},
			{call=function() crow:setObsolete() end}
		)
		crow:doOften(bounceBirdy)
	end
end

function bounceBirdy(bird, time)
	
	if (bird ~= nil) then
		bird.bounceTimer = bird.bounceTimer + time
		
		local yPos = 0
		if (bird.bounceTimer >= bird.bounceMaxTimer) then
			bird.bounceTimer = 0
		else
			local relTime = bird.bounceTimer / bird.bounceMaxTimer
			yPos = (bird.bounceHeight * math.sin(math.pi * relTime * 2))
		end
		
		bird:setY(yPos)
	end
	
end

function restaurant1:createCrows()

	if (restaurant1.crowBase ~= nil) then
		local nrCrows = 3
		local crowStartYMin = 20
		local crowStartYMax = 80
		local crowStartX = 100
		local crowStartXStepMin = 10
		local crowStartXStepMax = 30
		--local crowStartXMin = 100
		--local crowStartXMax = 300
		local crowEndXMinSpread = 200
		local crowEndXMaxSpread = 600
		local crowWaitDelayBase = 6000
		local endy = -restaurant1.crowBase:y()- 40
		
		for i=1, nrCrows, 1 do
			local baseOffsetX = math.random(crowStartXStepMin, crowStartXStepMax)
			local startX = crowStartX + baseOffsetX
			local startY = math.random(crowStartYMin, crowStartYMax)
			local endX = startX + math.random(crowEndXMinSpread, crowEndXMaxSpread)
			local crow = restaurant1.crowBase:newChildSprite({x=startX, y=startY, image="INTRO_CROW", section="interstitial1"})
			local crowFlightTime = math.random(3500, 5500)
			local crowDelay = crowWaitDelayBase + (5 * startX)
			crowStartX = startX
			crow:animate(
				{delay=crowDelay},
				{
					{x=endX, y=endy, duration=crowFlightTime},
					{startframe=0, frametime=50, loops="forever"},
				},
				{delay=crowFlightTime},
				{call=function() crow:setObsolete() end}
			)
		end
	end
end