restaurant2 = {}
restaurant2.car = nil
restaurant2.intro1 = nil
restaurant2.sceneBackground = nil

restaurant2.slomoSoundPlayed = false

function restaurant2:extendedAnimation()
	local treePos = 2800
	local animDuration = 13000

	restaurant2.sceneBackground = scene:child("BACKGROUND")	
	restaurant2.intro1, xPos = restaurant2:setupScene(restaurant2.sceneBackground)
	restaurant2.intro1:setAlpha(0)
	restaurant2.intro1.xPos = xPos
	restaurant2.intro1.speed1 = 340
	restaurant2.intro1.speed2 = 60
	restaurant2.intro1.xs1 = 2350
	restaurant2.intro1.xe1 = 2460
	restaurant2.intro1.xs2 = 2570
	restaurant2.intro1.xe2 = 2650
	restaurant2.intro1.curSpeed = restaurant2.intro1.speed1
	restaurant2.intro1.done = false

	for i=1, 3, 1 do
		restaurant2:addButterFly(restaurant2.intro1, 2000, 3200)
	end
	
	restaurant2:setupBallAnim(restaurant2.intro1)
	restaurant2:setupSwingAnim(restaurant2.intro1)

	for i=1, 2, 1 do
		restaurant2:addButterFly(restaurant2.intro1, 2000, 3200)
	end

	restaurant2:addParallaxItem(restaurant2.sceneBackground, "INTRO_SHADOW_HOUSE1", 500, 553, 1.05)
	restaurant2:addParallaxItem(restaurant2.sceneBackground, "INTRO_SHADOW_HOUSE2", 2500, 553, 1.05)

	restaurant2.car = restaurant2:setupCar(restaurant2.sceneBackground)

	for i=1, 3, 1 do
		restaurant2:addButterFly(restaurant2.intro1, 2000, 3200)
	end

	restaurant2:addParallaxItem(restaurant2.sceneBackground, "INTRO_LANTERN_FRONT", 50, 553, 1.3)
	restaurant2:addParallaxItem(restaurant2.sceneBackground, "INTRO_LANTERN_FRONT", 1600, 553, 1.3)
	restaurant2:addParallaxItem(restaurant2.sceneBackground, "INTRO_LANTERN_FRONT", 3200, 553, 1.3)

	local black = restaurant2.sceneBackground:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	local bar1, bar2 = addBars(restaurant2.sceneBackground)

	local carSoundBase = restaurant2.car:newChildSprite({x=0, y=0})
	-- movement is roughly at 3.855 ms/pixel
	black:animate(
		{alpha=1, duration=1000},
		{command="updateObjects", target=restaurant2.sceneBackground},
		--{command="playMusic track=INTRO_MUSIC section=interstitial2", target=restaurant2.sceneBackground},
		{
			{call=function() restaurant2.intro1:setAlpha(1) bar1:setAlpha(1) bar2:setAlpha(1) end},
			{alpha=0, duration=1000},
			{x=1200, y=restaurant2.car:y(), duration=7000, sprite=restaurant2.car},
			{call=function() restaurant2.intro1:doOften(intro1DoOften) end},
		},
		{call=function() black:setObsolete() end}
	)
	-- sort out the car sounds
	carSoundBase:animate(
		{delay=1000},
		{delSound="SOUND_DRIVING", section="interstitial2", fadeInTime=1000, maxVolTime=5000, fadeOutTime=3000, sprite=scene, target=carSoundBase},
		{delay=9500},
		{sound="SOUND_CAR_STOPS:interstitial2"}
	)
	
	local soundBase = restaurant2.intro1:newChildSprite({x=0, y=0})
	soundBase:animate(
		{delay=7500},
		{sound="SOUND_SLOMO:interstitial2"},
		{delay=4500},
		{call=function() soundBase:setObsolete() end}
	)
end

function restaurant2:addParallaxItem(parent, imageName, xPos, yPos, speedF)
	if (parent ~= nil) then	
		local item = parent:newChildSprite({x=800, y=yPos, image=imageName, section="interstitial2"})
		item:setAnchorPoint("bottomleft")
		item.xPos = xPos
		item.speedF = speedF
		item:doOften(parallaxDoOften)
		return item
	end
	return nil
end

function parallaxDoOften(s, time)

	if (restaurant2.intro1.done) then 
		s:doOften(nil)
	end
			
	if ((-restaurant2.intro1:x()) > s.xPos) then
		if ((s:x() + s:width()) > 0 and restaurant2.intro1.curSpeed > 11) then
			local speed = restaurant2.intro1.curSpeed * s.speedF
			local nx = (time / 1000) * speed
			s:animate({x= s:x() - nx, y = s:y()})
		else
			s:doOften(nil)
			if ((s:x() + s:width()) <= 0) then
				s:setObsolete()
			end
		end
	end
end

function intro1DoOften(s, time)
	local cx = -s:x()
	if (restaurant2.intro1.done == false) then			
		if (cx < s.xs1) then
			s.curSpeed = s.speed1
		elseif (cx < s.xe1) then			
			local f = (cx - s.xs1) / (s.xe1 - s.xs1)						
			s.curSpeed = lerp(s.speed1, s.speed2, f)
		elseif (cx < s.xs2) then
			s.curSpeed = s.speed2
		elseif (cx < s.xe2) then
			local f = (cx - s.xs2) / (s.xe2 - s.xs2)						
			s.curSpeed = lerp(s.speed2, s.speed1, f)		
		elseif (cx >= (s.xPos) - 100) then
			local f = (cx - (s.xPos - 100)) / (100)
			s.curSpeed = lerp(s.speed1, 10, f)
		end

		local nx = (time / 1000) * s.curSpeed
		s:animate({x = s:x() - nx, y = s:y()})			

		if (s.curSpeed <= 10.2) then
			restaurant2.intro1.done = true
		end
	else
		s.curSpeed = 0
		s:animate(
			{x = -s.xPos},
			{command="play", target=restaurant2.sceneBackground})
		s:doOften(nil)
	end
end

function restaurant2:setupScene(parent)
	if (parent ~= nil) then
		local intro1 = parent:newChildSprite({x=0, y=0, image="INTRO_CANDY_0", section="interstitial2"})
		local xPos = intro1:width()
		local intro2 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_CANDY_1", section="interstitial2"})
		xPos = xPos + intro2:width()
		local intro3 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_CANDY_2", section="interstitial2"})
		xPos = xPos + intro3:width()
		local intro4 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_CANDY_3", section="interstitial2"})
		xPos = xPos + intro4:width()
		local intro5 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_CANDY_4", section="interstitial2"})
		xPos = xPos + intro5:width()
		local intro6 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_CANDY_5", section="interstitial2"})
				
		return intro1, xPos
	end
	return nil, 0
end

function restaurant2:setupCar(parent)
	if (parent ~= nil) then
		local base = parent:newChildSprite({x=-200, y=385})
		base.speed = 370
		base.wheelLength = 200

		base:newChildSprite({x=-277, y=28, image="INTRO_CAR_SHADOW", section="interstitial2"})		
		base:newChildSprite({x=-289, y=63, image="INTRO_EXHAUST", section="interstitial2"})
		base:newChildSprite({x=-275, y=18, image="INTRO_CAR_BACK", section="interstitial2"})
		local interior = base:newChildSprite({x=-178, y=-90, image="INTRO_CAR_INTERIOR", section="interstitial2"})
		base:newChildSprite({x=-165, y=-95, image="INTRO_EMILY", section="interstitial2"})
		base:newChildSprite({x=-102, y=-59, image="INTRO_STEERING_WHEEL", section="interstitial2"})
		
		local wheelSuspension1 = base:newChildSprite({x=-66, y=35})
		base.wheel1 = wheelSuspension1:newChildSprite({x=0, y=0, image="INTRO_WHEEL", section="interstitial2"})
		wheelSuspension1:newChildSprite({x=23, y=23, image="INTRO_RIM", section="interstitial2"})

		local wheelSuspension2 = base:newChildSprite({x=-267, y=35})
		base.wheel2 = wheelSuspension2:newChildSprite({x=0, y=0, image="INTRO_WHEEL", section="interstitial2"})
		wheelSuspension2:newChildSprite({x=23, y=23, image="INTRO_RIM", section="interstitial2"})
		
		local carExterior = base:newChildSprite({x=-300, y=-280, image="INTRO_CAR", section="interstitial2"})
		carExterior:doEvery(0, function() 
			local dur = math.random(100, 150)			
			local offset = math.random(-2, 2)
			carExterior:animate({x=-300, y=-280 + offset, duration = dur})
			interior:animate({x=-178, y=-90 + offset, duration = dur})
			return dur
			end)
		
		base.wheel1:setPivotPoint({x=42, y=42})
		base.wheel1:doOften(function(s, time)
			s:setRotation(s:rotation() + ((((time / 1000) * base.speed) / base.wheelLength) * (2 * math.pi)))
			if (restaurant2.intro1.done) then 
				s:doOften(nil)
			end
		end)

		base.wheel2:setPivotPoint({x=42, y=42})
		base.wheel2:doOften(function(s, time)
			s:setRotation(s:rotation() + ((((time / 1000) * base.speed) / base.wheelLength) * (2 * math.pi)))
			if (restaurant2.intro1.done) then 
				s:doOften(nil)
			end	
		end)
		
		return base
	end
	return nil
end	

function restaurant2:setupBallAnim(parent)
	if (parent ~= nil) then
		parent:newChildSprite({x=2450, y=250, image="INTRO_BALL_GIRL", section="interstitial2"})
		parent:newChildSprite({x=2580, y=250, image="INTRO_BALL_BOY", section="interstitial2"})

		local ball = parent:newChildSprite({x=2520, y=253, image="INTRO_BALL", section="interstitial2"})
		ball.left = false
		ball.speed = 8
		ball.x1 = 2511
		ball.x2 = 2599
		ball.startY = ball:y()
		ball:doOften(ballOften)
		
	end
end

function ballOften(ball, time)

	if (restaurant2.intro1.done) then 
		ball:doOften(nil)
	end

	ball.speed = (8 / restaurant2.intro1.speed2) * restaurant2.intro1.curSpeed

	if (ball:x() >= ball.x2) then
		ball.left = true
	elseif (ball:x() <= ball.x1) then
		ball.left = false
	end
	
	local nx = (time / 1000) * ball.speed
	if (ball.left) then
		nx = math.max(ball.x1, ball:x() - nx)
	else
		nx = math.min(ball.x2, ball:x() + nx)
	end
	
	-- calc y offset
	yOffset = math.sin(math.pi * ((ball.x2 - nx) / (ball.x2 - ball.x1))) * 30
	ball:animate({x = nx, y = ball.startY - yOffset})
end

function restaurant2:setupSwingAnim(parent)
	if (parent ~= nil) then
		parent:newChildSprite({x=3046, y=237, image="INTRO_SWING_GIRL", section="interstitial2"})
		local swing = parent:newChildSprite({x=3158, y=117, image="INTRO_SWING", section="interstitial2"})
		
		swing.left = false
		swing:doOften(swingOften)		
	end
end

function swingOften(swing, time)

	if (restaurant2.intro1.done) then 
		swing:doOften(nil)
	end

	swing.speed = (0.1 / restaurant2.intro1.speed2) * restaurant2.intro1.curSpeed

	if (swing:rotation() >= 0.50) then
		swing.left = true
	elseif (swing:rotation() <= -0.50) then
		swing.left = false
	end
	
	rot = (time / 1000) * swing.speed
	if (swing.left) then
		swing:setRotation(swing:rotation() - rot)
	else
		swing:setRotation(swing:rotation() + rot)
	end	
end

function restaurant2:addButterFly(parent, xMin, xMax)
	if (parent ~= nil) then
		local xPos = math.random(xMin, xMax)
		local yPos = math.random(80, 400)
		
		local butName = "INTRO_BUTTERFLY_4"
		local idx = math.random(0, 4)
		if (idx == 0) then
			butName = "INTRO_BUTTERFLY_1"
		elseif (idx == 1) then
			butName = "INTRO_BUTTERFLY_2"
		elseif (idx == 2) then
			butName = "INTRO_BUTTERFLY_3"
		elseif (idx == 3) then
			butName = "INTRO_BUTTERFLY_4"
		end
				
		local but = parent:newChildSprite({x=xPos, y=yPos, image=butName, section="interstitial2"})
		but:animate({startframe=0, frametime=160, loops="forever"})
		but.speed = math.random(5, 9)
		but:doEvery(0, function() return butterflyDoEvery(but) end)
	end
end

function butterflyDoEvery(but)	
	
	if (restaurant2.intro1.done) then 
		but:setObsolete()
		return
	end

	but.s = (but.speed / restaurant2.intro1.speed2) * restaurant2.intro1.curSpeed
	local dur = math.random(2000, 4000)
	local dist = but.s * (dur / 1000)
	
	local dx = math.random(dist / 2, dist - 1)
	local dy = math.sqrt((dist * dist) - (dx * dx))
	
	but:setFlipImageHorizontal(false)
	
	if ((but:x() - dx > 2000) and (math.random(0, 2) == 0 or but:x() + dx > 3200)) then
		dx = -dx
		but:setFlipImageHorizontal(true)
	end
	
	if ((but:y() - dy > 0) and (math.random(0, 2) == 0 or but:y() + dy > 400)) then	
		dy = -dy
	end
		
	but:animate({dx=dx, dy=dy, duration=dur, style="easeInOut"})
	
	return dur
end

function restaurant2:simpleAnimation()
	local background = scene:child("BACKGROUND")
	local black = background:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	
	black:animate(		
		{alpha=1, duration=1000},
		{command="updateObjects", target=background},
		{command="updateBackground", target=background},
		{alpha=0, duration=1000},
		{call=function() 
			moveCalender(true)
			moveButtons(true)
			moveRestSelection(true)
			black:setObsolete() end}
	)
end
