restaurant3 = {}

restaurant3.sceneRoot = nil
restaurant3.introBackground = nil
restaurant3.roadBackground = nil

restaurant3.whiteLight1 = nil
restaurant3.whiteLight2 = nil
restaurant3.yellowLight = nil

-- Car stuff
restaurant3.car = nil
restaurant3.bodyBase = nil
restaurant3.wheelBase = nil
restaurant3.passengerBase = nil
restaurant3.carBase = nil

restaurant3.wheels = nil
restaurant3.passengers = nil
restaurant3.bodywork = nil

function restaurant3:extendedAnimation()
	restaurant3.sceneRoot = scene:child("BACKGROUND")
	local intro3, xPos, yPos = restaurant3:setupScene(restaurant3.sceneRoot)
	
	restaurant3.whiteLight1.clockwise = false
	restaurant3.whiteLight2.clockwise = true
	restaurant3.yellowLight.clockwise = false
	
	local initialTime = math.random(1000, 3000)
	restaurant3.whiteLight1:doEvery(initialTime, restaurant3.moveLight1)
	initialTime = math.random(1000, 3000)
	restaurant3.whiteLight2:doEvery(initialTime, restaurant3.moveLight2)
	initialTime = math.random(1000, 3000)
	restaurant3.yellowLight:doEvery(initialTime, restaurant3.moveLight3)
	
	intro3:setAlpha(0)
	intro3:setX(-xPos)
	intro3:setY(-yPos)
	local black = restaurant3.sceneRoot:newChildSprite({x=0, y=0, image="INTRO_STREET_5", section="interstitial3"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	local bar1, bar2 = addBars(restaurant3.sceneRoot)
	
	restaurant3.introBackground = intro3
	restaurant3.car = restaurant3:setupCar(restaurant3.roadBackground)
	
	local useSkiddingAnimation = true
	
	black:animate(
		{alpha=1, duration=1000},
		{command="updateObjects", target=restaurant3.sceneRoot},
		{command="updateBackground", target=restaurant3.sceneRoot},	
		--{command="playMusic track=INTRO_MUSIC section=interstitial3", target=restaurant3.sceneRoot},
		{call=function() intro3:setAlpha(1) bar1:setAlpha(1) bar2:setAlpha(1) end},
		{
			{alpha=0, duration=2000},
			{call=
				function()
					local pauseDelay = 500
					if (useSkiddingAnimation == false) then
						restaurant3.car:animate(
							{x=restaurant3.car.handbrakeTurnBaseX + restaurant3.car.handbrakeTurnXDist},
							{delay=3000},
							{call=
								function()
									restaurant3:centreCarPivot()
									restaurant3:initCarAnimations()
								end},
							{
								{x=520, y=300, duration=8000, style="easeOut"},
								{scale=0.125, duration=8000, style="easeOut"},
							}
						)
					else
						pauseDelay = 3000
						restaurant3.carBase:setRotation(5 * (math.pi / 180.0))
						restaurant3.car:setX(restaurant3.car:x() + 105)
						restaurant3.car.handbrakeTurnXDist = restaurant3.car.handbrakeTurnXDist - 75
						restaurant3.car.handbrakeTurnBaseX = restaurant3.car.handbrakeTurnBaseX + 105
						restaurant3.car:animate(
							{x=-200},
							{alpha=0},
							{delay=6000},
							{alpha=1},
							{x=restaurant3.car.handbrakeTurnBaseX, duration=500},
							{call=function() restaurant3.car:doOften(turnAnimationUpdate) end},
							{delay=restaurant3.car.handbrakeTurnDuration},
							{rotation=0, duration=100, sprite=restaurant3.carBase},
							{call=
								function()
									restaurant3:centreCarPivot()
									restaurant3:initCarAnimations()
								end},
							{
								{x=520, y=300, duration=8000, style="easeOut"},
								{scale=0.12, duration=8000, style="easeOut"},
							},
							{
								--{alpha=0, duration=2000},
								{x=516, y=300, duration=2000, style="easeOut"},
								{scale=0.1, duration=2000, style="easeOut"},
							},
							{
								{alpha=0, duration=2000},
								{x=515, y=298, duration=2000, style="easeOut"},
								{scale=0.05, duration=2000, style="easeOut"},
							}
						)
					end

					intro3:animate(
						{call=function() intro3:relocatePivotPoint(510, 200) end},
						{x=-105, y=-yPos, duration=6000, style="easeOut"},
						{delay=pauseDelay},
						{
							{x=-105, y=-60, duration=6000, style="easeInOut"},
							{scale=0.5, duration=6000, style="easeInOut"},
						},
						{delay=5000},
						{command="play", target=restaurant3.sceneRoot}
					)
				end
			}
		},
		{call=function() black:setObsolete() end}
	)
	
	-- Sounds
	local cityAmbient = restaurant3.introBackground:newChildSprite({x=0, y=0})
	cityAmbient:animate(
		{delSound="SOUND_CITY_AMBIENT", section="interstitial3", fadeInTime=5000, maxVolTime=14000, fadeOutTime=2000, sprite=scene}
	)
	
	local carSoundBase = restaurant3.car:newChildSprite({x=0, y=0})
	if (useSkiddingAnimation) then
		carSoundBase:animate(
			{delay=7000},
			{sound="SOUND_CAR_TURNS:interstitial3"},
			{delay=restaurant3.car.handbrakeTurnDuration + 400},
			{sound="SOUND_DRIVE_TO_DISTANCE:interstitial3"}
		)
	end
end

function restaurant3:simpleAnimation()
	local background = scene:child("BACKGROUND")
	local black = background:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	
	black:animate(		
		{alpha=1, duration=1000},
		{command="updateObjects", target=background},
		{command="updateBackground", target=background},	
		{alpha=0, duration=1000},
		{call=function() 
			moveCalender(true)
			moveButtons(true)
			moveRestSelection(true)
			black:setObsolete() end}
	)
end

--=============================================================================
-- 
--=============================================================================
function restaurant3:setupScene(parent)
	if (parent ~= nil) then
		local xPos = 0
		local yPos = 0
		
		local base = parent:newChildSprite({x=0, y=0})
		local sky = base:newChildSprite({x=xPos, y=yPos, image="INTRO_SKY_1", section="interstitial3"})
		local skyLeft = base:newChildSprite({x=105, yPos=yPos, image="INTRO_SKY_LEFT", section="interstitial3", anchorpoint="topright"})
		xPos = xPos + sky:width() - 115
		local skyRight = base:newChildSprite({x=xPos, yPos=yPos, image="INTRO_SKY_RIGHT", section="interstitial3"})
		yPos = yPos + sky:height()
		sky = base:newChildSprite({x=0, y=yPos, image="INTRO_SKY_2", section="interstitial3", name="SPACE2"})
		sky = base:newChildSprite({x=105, y=yPos, image="INTRO_SKY_3", section="interstitial3", anchorpoint="topright", name="SPACE3"})
	
		-- light 1
		restaurant3.whiteLight1 = base:newChildSprite({x=250, y=710, image="INTRO_LIGHT_1", section="interstitial3", anchorpoint="bottom"})
		restaurant3.whiteLight2 = base:newChildSprite({x=687, y=670, image="INTRO_LIGHT_1", section="interstitial3", anchorpoint="bottom"})
		-- light 2
		xPos = 425
		yPos = 200
		local tower = base:newChildSprite({x=xPos, y=yPos, image="INTRO_TOWER_1", section="interstitial3"})
		yPos = yPos + tower:height()
		xPos = 420
		tower = base:newChildSprite({x=xPos, y=yPos, image="INTRO_TOWER_2", section="interstitial3"})
		-- Logo
		local logo = base:newChildSprite({x=508, y=150, image="INTRO_LOGO", section="interstitial3", anchorpoint="center"})
		logo:animate(
			{startframe=0, frametime=200, loops="forever"}
		)
		-- light 3
		restaurant3.yellowLight = base:newChildSprite({x=394, y=912, image="INTRO_LIGHT_2", section="interstitial3", anchorpoint="bottom"})
		xPos = 0
		yPos = 0
		local street = base:newChildSprite({x=xPos, y=yPos, image="INTRO_STREET_1", section="interstitial3"})
		yPos = yPos + street:height()
		street = base:newChildSprite({x=xPos, y=yPos, image="INTRO_STREET_2", section="interstitial3"})
		local streetRight = base:newChildSprite({x=1014, y=556, image="INTRO_STREET_RIGHT", section="interstitial3"})
		restaurant3.roadBackground = street
		xPos = xPos + 105
		street = base:newChildSprite({x=xPos, y=yPos, image="INTRO_STREET_3", section="interstitial3", anchorpoint="topright"})
		xPos = xPos - street:width()
		street = base:newChildSprite({x=xPos, y=yPos, image="INTRO_STREET_4", section="interstitial3", anchorpoint="topright"})
		xPos = xPos - street:width()
		street = base:newChildSprite({x=xPos, y=yPos, image="INTRO_STREET_5", section="interstitial3", anchorpoint="topright"})
		xPos = xPos - street:width()
		street = base:newChildSprite({x=xPos, y=yPos, image="INTRO_STREET_6", section="interstitial3", anchorpoint="topright"})
		
		return base, xPos, yPos
	end
	return nil, 0, 0
end

--
function restaurant3:setupCar(parent)
	if (parent ~= nil) then
		local base = parent:newChildSprite({x=-200, y=250})
		local shadow = base:newChildSprite({x=0, y=220, image="INTRO_CAR_SHADOW", section="interstitial3", anchorpoint="center"})

		restaurant3.carBase			= base:newChildSprite({x=0, y=0})
		restaurant3.wheelBase		= restaurant3.carBase:newChildSprite({x=138, y=275})
		restaurant3.passengerBase	= restaurant3.carBase:newChildSprite({x=81, y=90})
		restaurant3.bodyBase		= restaurant3.carBase:newChildSprite({x=150, y=235})
		
		restaurant3.wheels		= restaurant3.wheelBase:newChildSprite({x=0, y=0, image="INTRO_CAR_WHEELS", section="interstitial3", anchorpoint="bottomright"})
		restaurant3.passengers	= restaurant3.passengerBase:newChildSprite({x=0, y=0, image="INTRO_EMILY_FRANK", section="interstitial3", anchorpoint="bottomright"})
		restaurant3.bodywork	= restaurant3.bodyBase:newChildSprite({x=0, y=0, image="INTRO_CAR", section="interstitial3", anchorpoint="bottomright"})

		restaurant3.wheelBase.moveTimer = 100
		restaurant3.passengerBase.moveTimer = 150
		restaurant3.bodyBase.moveTimer = 125
		-- Setup the car animations
		
		-- The initial "handbrake turn" animation params
		base.handbrakeTurnDuration = 1000
		base.handbrakeTurnProgress = 0
		base.handbrakeTurnDone = false
		base.handbrakeTurnBounceHeight = 30
		base.handbrakeTurnNrBounces = 4
		base.handbrakeTurnBaseX = 355
		base.handbrakeTurnXDist = 350
		base.handbrakeTurnBaseY = 250
		return base	
	end
	return nil
end

--
function restaurant3:bounceWheels()
	if (restaurant3.wheelBase ~= nil) then
		local startY = restaurant3.wheelBase:y()
		local endY = math.random(startY - 8, startY)
		local bumpDuration = math.random(100, 150)
		restaurant3.wheelBase:animate(
			{y=endY, duration=bumpDuration},
			{y=startY, duration=bumpDuration}
		)
		local minTime = 2 * bumpDuration
		restaurant3.wheelBase.moveTimer = math.random(100, 300)
		if (restaurant3.wheelBase.moveTimer < minTime) then
			restaurant3.wheelBase.moveTimer = minTime
		end
		return restaurant3.wheelBase.moveTimer
	end
end

--
function restaurant3:bouncePassengers()
	if (restaurant3.passengerBase ~= nil) then
		local startY = restaurant3.passengerBase:y()
		local endY = math.random(startY - 5, startY)
		local bumpDuration = math.random(100, 150)
		restaurant3.passengerBase:animate(
			{y=endY, duration=bumpDuration},
			{y=startY, duration=bumpDuration}
		)
		local minTime = 2 * bumpDuration
		restaurant3.passengerBase.moveTimer = math.random(100, 300)
		if (restaurant3.passengerBase.moveTimer < minTime) then
			restaurant3.passengerBase.moveTimer = minTime
		end
		return restaurant3.passengerBase.moveTimer
	end
end

--
function restaurant3:bounceBody()
	if (restaurant3.bodyBase ~= nil) then
		local startY = restaurant3.bodyBase:y()
		local endY = math.random(startY - 10, startY)
		local bumpDuration = math.random(100, 150)
		restaurant3.bodyBase:animate(
			{y=endY, duration=bumpDuration},
			{y=startY, duration=bumpDuration}
		)
		local minTime = 2 * bumpDuration
		restaurant3.bodyBase.moveTimer = math.random(100, 300)
		if (restaurant3.bodyBase.moveTimer < minTime) then
			restaurant3.bodyBase.moveTimer = minTime
		end
		return restaurant3.bodyBase.moveTimer
	end
end

--
function turnAnimationUpdate(obj, time)

	if (obj.handbrakeTurnDone == false) then
		obj.handbrakeTurnProgress = obj.handbrakeTurnProgress + time
		local relativeProgress = (obj.handbrakeTurnProgress * 1.0) / (obj.handbrakeTurnDuration * 1.0)
		if (obj.handbrakeTurnProgress >= obj.handbrakeTurnDuration) then
			relativeProgress = 1.0
			obj.handbrakeTurnDone = true
		end
		
		-- function is an absolute sin function with damping
		local x = obj.handbrakeTurnXDist * relativeProgress
		local xPos = x + obj.handbrakeTurnBaseX
		local funcXVal = relativeProgress * obj.handbrakeTurnNrBounces
		local func2 = (-funcXVal / obj.handbrakeTurnNrBounces) + 1
		local y = math.abs(math.sin(math.pi * funcXVal)) * func2
		local yPos = y * obj.handbrakeTurnBounceHeight
		yPos = - yPos
		
		restaurant3.car:setX(xPos)
		restaurant3.carBase:setY(yPos)
	
	else
		obj:doOften(nil)	
	end
end

--
-- intro3:relocatePivotPoint((xPos + 400), -300)
function restaurant3:centreCarPivot()
	restaurant3.wheels:relocatePivotPoint("center")
	restaurant3.passengers:relocatePivotPoint("center")
	restaurant3.bodywork:relocatePivotPoint("center")
end

--
function restaurant3:initCarAnimations()
	if (restaurant3.wheelBase ~= nil) then
		restaurant3.wheelBase:doEvery(restaurant3.wheelBase.moveTimer, restaurant3.bounceWheels)
	end
	
	if (restaurant3.passengerBase ~= nil) then
		restaurant3.passengerBase:doEvery(restaurant3.passengerBase.moveTimer, restaurant3.bouncePassengers)
	end
	
	if (restaurant3.carBase ~= nil) then
		restaurant3.bodyBase:doEvery(restaurant3.bodyBase.moveTimer, restaurant3.bounceBody)
	end
end

--
function restaurant3:moveLight1()
	return restaurant3:moveLight(restaurant3.whiteLight1)
end

--
function restaurant3:moveLight2()
	return restaurant3:moveLight(restaurant3.whiteLight2)
end

--
function restaurant3:moveLight3()
	return restaurant3:moveLight(restaurant3.yellowLight)
end

--
function restaurant3:moveLight(light)
	if (light ~= nil) then
		local moveTime = math.random(1000, 4000)
		local rot = math.random(10, 20)
		if (light.clockwise) then
			rot = -rot
			light.clockwise = false
		else
			light.clockwise = true
		end
		light:animate(
			{rotation=rot, duration=moveTime, style="easeInOut"}
		)
		local delay = math.random(100, 750)
		return moveTime + delay
	end
end