restaurant4 = {}
restaurant4.car = nil
restaurant4.intro1 = nil
restaurant4.sceneBackground = nil

restaurant4.bird = nil
restaurant4.birdAnimTimer = 0
restaurant4.birdAnimStartX = 0
restaurant4.birdAnimStartY = 0

restaurant4.birdAnimIndex = 0
restaurant4.birdAnimInfo = {}

function restaurant4:extendedAnimation()
	restaurant4.sceneBackground = scene:child("BACKGROUND")	
	restaurant4.intro1, xPos = restaurant4:setupScene(restaurant4.sceneBackground)
	restaurant4.intro1:setAlpha(0)
	restaurant4.intro1.xPos = xPos
	restaurant4.intro1.speed = 200
	restaurant4.intro1.curSpeed = restaurant4.intro1.speed
	restaurant4.intro1.done = false
	restaurant4.intro1.continue = false

	restaurant4:setupBalloon(restaurant4.intro1)

	for i=1, 15, 1 do
		restaurant4:addButterFly(restaurant4.intro1, 1400, 3000)
	end

	restaurant4.car = restaurant4:setupCar(restaurant4.sceneBackground)

	restaurant4:addParallaxItem(restaurant4.sceneBackground, "INTRO_LANTERN_FRONT", 0, 553, 1.3)
	restaurant4:addParallaxItem(restaurant4.sceneBackground, "INTRO_LANTERN_FRONT", 1450, 553, 1.3)

	local black = restaurant4.sceneBackground:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	local bar1, bar2 = addBars(restaurant4.sceneBackground)

	-- movement is roughly at 3.855 ms/pixel
	black:animate(
		{alpha=1, duration=1000},
		{command="updateObjects", target=restaurant4.sceneBackground},
		--{command="playMusic track=INTRO_MUSIC section=interstitial4", target=restaurant4.sceneBackground},
		{
			{call=function() restaurant4.intro1:setAlpha(1) bar1:setAlpha(1) bar2:setAlpha(1) end},
			{alpha=0, duration=1000},
			{call=function() restaurant4.intro1:doOften(intro4DoOften) end}
		},
		{x=210, y=restaurant4.car:y(), duration=8000, sprite=restaurant4.car},
		{call=function()
			 restaurant4.car.speed = restaurant4.intro1.speed
			 black:setObsolete() 
		end}
	)
	
	-- sounds
	local ambientBase = restaurant4.sceneBackground:newChildSprite({x=0, yPos=0})
	ambientBase:animate(
		{delSound="SOUND_PARK_AMBIENT", section="interstitial4", fadeInTime=1000, maxVolTime=12000, fadeOutTime=1000, sprite=scene}
	)
	local carSoundBase = restaurant4.car:newChildSprite({x=0, yPos=0})
	carSoundBase:animate(
		{delSound="SOUND_DRIVING", section="interstitial4", fadeInTime=3000, maxVolTime=6500, fadeOutTime=500, sprite=scene},
		{delay=10000},
		{sound="SOUND_CAR_STOP:interstitial4"}
	)
end

function restaurant4:addParallaxItem(parent, imageName, xPos, yPos, speedF)
	if (parent ~= nil) then	
		local item = parent:newChildSprite({x=0, y=yPos, image=imageName, section="interstitial4"})
		item:setAnchorPoint("bottomright")
		item.xPos = xPos
		item.speedF = speedF
		item:doOften(parallax4DoOften)
		return item
	end
	return nil
end

function parallax4DoOften(s, time)

	if (restaurant4.intro1.done) then 
		s:doOften(nil)
	end
			
	if ((restaurant4.intro1:x()) > s.xPos + 800) then
		if ((s:x() + s:width()) > 0 and restaurant4.intro1.curSpeed > 11) then
			local speed = restaurant4.intro1.curSpeed * s.speedF
			local nx = (time / 1000) * speed
			s:animate({x= s:x() + nx, y = s:y()})
		else
			s:doOften(nil)
			if (s:x() > 800 + s:width()) then
				s:setObsolete()
			end
		end
	end
end

function intro4DoOften(s, time)
	local cx = s:x()
	if (restaurant4.intro1.continue == false) then			
		s.curSpeed = s.speed

		if (cx > -s.xPos - 100) then
			local f = (cx - (-s.xPos - 100)) / (100)
			s.curSpeed = lerp(s.speed, 10, f)
			restaurant4.car.speed = s.curSpeed
			
			f = math.min(0.99, f*1.2)
			local rot = (math.sin(-math.pi * (1-f)) * math.log(1-f)) * -0.08
			restaurant4.car:setRotation(rot)
			if (f >= 0.99) then
				restaurant4.car.done = true
			end
		end

		local nx = (time / 1000) * s.curSpeed
		s:animate({x = s:x() + nx, y = s:y()})			

		if (s.curSpeed <= 10.2) then
			restaurant4.intro1.continue = true
		end
	else
		s.curSpeed = 0
		restaurant4.car.speed = 0
		s:animate(
			{x = -s.xPos},
			{delay=3000},
			{call=function() restaurant4.intro1.done = true end},
			{command="play", target=restaurant4.sceneBackground})
		s:doOften(nil)
	end
end

function restaurant4:setupScene(parent)
	if (parent ~= nil) then
		local intro1 = parent:newChildSprite({x=800, y=0, image="INTRO_FAIR_2", section="interstitial4"})
		intro1:setAnchorPoint("topright")
		local xPos = -intro1:width()
		local intro2 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_FAIR_1", section="interstitial4"})
		intro2:setAnchorPoint("topright")
		xPos = xPos - intro2:width()
		local intro3 = intro1:newChildSprite({x=xPos, y=0, image="INTRO_FAIR_0", section="interstitial4"})
		intro3:setAnchorPoint("topright")
		xPos = xPos - (intro3:width())
		
		-- Birdy
		--local birdBase = parent:newChildSprite({x=0, y=0})
		restaurant4.bird = intro2:newChildSprite({x=-658, y=164, image="INTRO_FAIR_BIRD", section="interstitial4"})
		restaurant4.birdAnimIndex = 1
		-- Animation parameters are:
		-- endXDelta, jumpHeight, jumpTime, pauseTime, flipImageHorizontally
		local jumpXDist = -20
		local jumpHeight = -6
		local jumpTime = 50
		local jumpPauseTime = 400
		restaurant4.birdAnimInfo[1] = {0, 0, 0, 6500, false}
		restaurant4.birdAnimInfo[2] = {jumpXDist, jumpHeight, jumpTime, jumpTime, false}
		restaurant4.birdAnimInfo[3] = {jumpXDist, jumpHeight, jumpTime, jumpTime, false}
		restaurant4.birdAnimInfo[4] = {jumpXDist, jumpHeight, jumpTime, 4 * jumpPauseTime, false}
		restaurant4.birdAnimInfo[5] = {jumpXDist, jumpHeight, jumpTime, jumpPauseTime, false}
		restaurant4.birdAnimInfo[6] = {jumpXDist, jumpHeight, jumpTime, jumpTime, false}
		restaurant4.birdAnimInfo[7] = {jumpXDist, jumpHeight, jumpTime, jumpPauseTime, false}
		--restaurant4.birdAnimInfo[8] = {jumpXDist, jumpHeight, jumpTime, jumpPauseTime, false}
		restaurant4.birdAnimInfo[8] = {0, 0, 0, 0, true}
		restaurant4.birdAnimTimer = 0
		restaurant4.birdAnimStartX = restaurant4.bird:x()
		restaurant4.birdAnimStartY = restaurant4.bird:y()
		restaurant4.bird:doOften(updateBirdPosition)
		
		return intro1, xPos
	end
	return nil, 0
end

function updateBirdPosition(obj, time)
	local max = table.getn(restaurant4.birdAnimInfo)
	if (restaurant4.birdAnimIndex <= max) then
		
		local posInfo = restaurant4.birdAnimInfo[restaurant4.birdAnimIndex]
		restaurant4.birdAnimTimer = restaurant4.birdAnimTimer + time
		
		local xPos = restaurant4.birdAnimStartX
		local yPos = restaurant4.birdAnimStartY
		-- Is the bird still jumping?
		if (restaurant4.birdAnimTimer < posInfo[3]) then
			local relTime = restaurant4.birdAnimTimer / posInfo[3]
			
			xPos = xPos + (relTime * posInfo[1])
			yPos = yPos + (posInfo[2] * math.sin(relTime * math.pi))
			
		else
			xPos = xPos + posInfo[1]
			--yPos = yPos + posInfo[2]
			
			-- has this anim finished?
			if (restaurant4.birdAnimTimer >= (posInfo[3] + posInfo[4])) then
				restaurant4.birdAnimTimer = 0
				restaurant4.birdAnimStartX = xPos
				restaurant4.birdAnimStartY = yPos
				restaurant4.birdAnimIndex = restaurant4.birdAnimIndex + 1
				restaurant4.bird:setFlipImageHorizontal(posInfo[5])
			end
		end
		restaurant4.bird:setX(xPos)
		restaurant4.bird:setY(yPos)
	else
		restaurant4.bird:doOften(nil)
	end
end

function restaurant4:setupCar(parent)
	if (parent ~= nil) then
		local base = parent:newChildSprite({x=850, y=385})
		base.speed = 220
		base.done = false
		base.wheelLength = 200
		base:setScale({x=-1})		

		base:newChildSprite({x=-386, y=26, image="INTRO_CAR_SHADOW", section="interstitial4"}):setFlipImageHorizontal(true)
		base:newChildSprite({x=-289, y=63, image="INTRO_EXHAUST", section="interstitial4"})
		base:newChildSprite({x=-275, y=18, image="INTRO_CAR_BACK", section="interstitial4"})
		local interior = base:newChildSprite({x=-178, y=-90, image="INTRO_CAR_INTERIOR", section="interstitial4"})
		base:newChildSprite({x=-165, y=-95, image="INTRO_EMILY", section="interstitial4"})
		base:newChildSprite({x=-102, y=-59, image="INTRO_STEERING_WHEEL", section="interstitial4"})
		
		local wheelSuspension1 = base:newChildSprite({x=-66, y=35})
		base.wheel1 = wheelSuspension1:newChildSprite({x=0, y=0, image="INTRO_WHEEL", section="interstitial4"})
		wheelSuspension1:newChildSprite({x=23, y=23, image="INTRO_RIM", section="interstitial4"})

		local wheelSuspension2 = base:newChildSprite({x=-267, y=35})
		base.wheel2 = wheelSuspension2:newChildSprite({x=0, y=0, image="INTRO_WHEEL", section="interstitial4"})
		wheelSuspension2:newChildSprite({x=23, y=23, image="INTRO_RIM", section="interstitial4"})
		
		local carExterior = base:newChildSprite({x=-300, y=-280, image="INTRO_CAR", section="interstitial4"})
		carExterior:doEvery(0, function() 
			
			if (base.done) then
				return 10000
			end
		
			local dur = math.random(100, 150)			
			local offset = math.random(-2, 2)
			carExterior:animate({x=-300, y=-280 + offset, duration = dur})
			interior:animate({x=-178, y=-90 + offset, duration = dur})
			return dur
			end)
		
		base.wheel1:setPivotPoint({x=42, y=42})
		base.wheel1:doOften(function(s, time)
			s:setRotation(s:rotation() + ((((time / 1000) * base.speed) / base.wheelLength) * (2 * math.pi)))
			if (restaurant4.intro1.done) then 
				s:doOften(nil)
			end
		end)

		base.wheel2:setPivotPoint({x=42, y=42})
		base.wheel2:doOften(function(s, time)
			s:setRotation(s:rotation() + ((((time / 1000) * base.speed) / base.wheelLength) * (2 * math.pi)))
			if (restaurant4.intro1.done) then 
				s:doOften(nil)
			end	
		end)
		
		return base
	end
	return nil
end	

function restaurant4:setupBalloon(parent)
	if (parent ~= nil) then
		local base = parent:newChildSprite({x=-2259, y=307})
		local b5 = base:newChildSprite({x=-9, y=-63, image="INTRO_BALLOON4", section="interstitial4", anchorpoint="bottom"})
		local b6 = base:newChildSprite({x=1, y=-44, image="INTRO_BALLOON5", section="interstitial4", anchorpoint="bottom"})
		local b7 = base:newChildSprite({x=18, y=-45, image="INTRO_BALLOON6", section="interstitial4", anchorpoint="bottom"})
		local b8 = base:newChildSprite({x=-22, y=-31, image="INTRO_BALLOON7", section="interstitial4", anchorpoint="bottom"})

		local b1 = base:newChildSprite({x=-2, y=4, image="INTRO_BALLOON0", section="interstitial4", anchorpoint="bottom"})
		local b2 = base:newChildSprite({x=-6, y=6, image="INTRO_BALLOON1", section="interstitial4", anchorpoint="bottom"})
		local b3 = base:newChildSprite({x=-23, y=3, image="INTRO_BALLOON2", section="interstitial4", anchorpoint="bottom"})
		local b4 = base:newChildSprite({x=18, y=6, image="INTRO_BALLOON3", section="interstitial4", anchorpoint="bottom"})

		b1.ox = b1:x()
		b1.oy = b1:y()
		b2.ox = b2:x()
		b2.oy = b2:y()
		b3.ox = b3:x()
		b3.oy = b3:y()
		b4.ox = b4:x()
		b4.oy = b4:y()
		b5.ox = b5:x()
		b5.oy = b5:y()
		b6.ox = b6:x()
		b6.oy = b6:y()
		b7.ox = b7:x()
		b7.oy = b7:y()
		b8.ox = b8:x()
		b8.oy = b8:y()

		b1:doEvery(0, function() return restaurant4:balloonDoEvery(b1) end)
		b2:doEvery(0, function() return restaurant4:balloonDoEvery(b2) end)
		b3:doEvery(0, function() return restaurant4:balloonDoEvery(b3) end)
		b4:doEvery(0, function() return restaurant4:balloonDoEvery(b4) end)
		b5:doEvery(0, function() return restaurant4:balloonDoEvery(b5) end)
		b6:doEvery(0, function() return restaurant4:balloonDoEvery(b6) end)
		b7:doEvery(0, function() return restaurant4:balloonDoEvery(b7) end)
		b8:doEvery(0, function() return restaurant4:balloonDoEvery(b8) end)
	end
end

function restaurant4:balloonDoEvery(balloon)
	local dur = math.random(300, 400)
	local nx = math.random(0, 3) - 1
	local ny = math.random(0, 11) - 5
	balloon:animate({x=balloon.ox+nx, y=balloon.oy+ny, duration=dur, style="easeInOut"})
	return 	dur
end

function restaurant4:addButterFly(parent, xMin, xMax)
	if (parent ~= nil) then
		local xPos = -math.random(xMin, xMax)
		local yPos = math.random(80, 400)
		
		local butName = "INTRO_BUTTERFLY_4"
		local idx = math.random(0, 4)
		if (idx == 0) then
			butName = "INTRO_BUTTERFLY_1"
		elseif (idx == 1) then
			butName = "INTRO_BUTTERFLY_2"
		elseif (idx == 2) then
			butName = "INTRO_BUTTERFLY_3"
		elseif (idx == 3) then
			butName = "INTRO_BUTTERFLY_4"
		end
				
		local but = parent:newChildSprite({x=xPos, y=yPos, image=butName, section="interstitial4"})
		but:animate({startframe=0, frametime=60, loops="forever"})
		but.speed = math.random(40, 55)
		but:doEvery(0, function() return restaurant4:butterflyDoEvery(but) end)
	end
end

function restaurant4:butterflyDoEvery(but)	
	
	if (restaurant4.intro1.done) then 
		return 10000
	end

	but.s = but.speed
	local dur = math.random(2000, 4000)
	local dist = but.s * (dur / 1000)
	
	local dx = math.random(dist / 2, dist - 1)
	local dy = math.sqrt((dist * dist) - (dx * dx))
	
	but:setFlipImageHorizontal(false)
	
	if (math.random(0, 2) == 0) then
		dx = -dx
		but:setFlipImageHorizontal(true)
	end
	
	if ((but:y() - dy > 0) and (math.random(0, 2) == 0 or but:y() + dy > 400)) then	
		dy = -dy
	end
		
	but:animate({dx=dx, dy=dy, duration=dur, style="easeInOut" })
	
	return dur
end

function restaurant4:simpleAnimation()
	local background = scene:child("BACKGROUND")
	local black = background:newChildSprite({x=0, y=0, image="BACKGROUND1", section="interstitial"})
	black:setColor({alpha=0, red=0, green=0, blue=0})
	
	moveCalender(false)
	moveButtons(false)
	moveRestSelection(false)
	
	black:animate(		
		{alpha=1, duration=1000},
		{command="updateObjects", target=background},
		{command="updateBackground", target=background},
		{alpha=0, duration=1000},
		{call=function() 
			moveCalender(true)
			moveButtons(true)
			moveRestSelection(true)
			black:setObsolete() end}
	)
end
