class 'actionTable' (Appliance)

actionTable.timeUntilDisappear = 10 * 1000
actionTable.timeWork = 3 * 1000
actionTable.score = 50
actionTable.cameraManX = 44
actionTable.cameraManY = 28
actionTable.cameraManPose = "KNEEL_UP"
actionTable.cameraManWalkTimePerNodeIdle = 70
actionTable.cameraManWalkTimePerNodeBusy = 35
actionTable.products = {}
actionTable.index = 0

actionTable.timer = 0
actionTable.state = "idle"


function actionTable:__init() super()
end

function actionTable:doNext()

	if (self.state == "idle") then
		self.timer = self.timeUntilDisappear
		self.state = "waiting for click"
		self.index = self.index + 1
		if (self.index == 4) then self.index = 1 end
		self:setClickable(true)
		self.products[self.index]:setVisible(true)
		self.products[self.index]:blink()
		self:moveCameraToTable()
		hm:placeArrow(ARROW_HINT_PRODUCTTABLE, self, 25, -10)
		
	else
		warn("actionTable:doNext - actionTable is busy, request ignored")
	
	end	

end

function actionTable:onTick(time)

	if (self.state == "waiting for click") then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
			    self:removeOverhead()
				self:setClickable(false)
				self.state = "idle"
				self:moveCameraToHome()

                for i = 1,3 do				
				    self.products[self.index]:setVisible(false)
				    
				end			
			end	
		end
	end

end

function actionTable:onCreate()

	Appliance.onCreate(self)
	
	self:createHighlight()
	self:setClickable(false)	
	
	local x = 20
	local y = -50
	
	self.products[1] = createSprite()
	self.products[1]:setDefaultSection(player:getCurrentResourceSection())
	self.products[1]:animate("OBJECT_BOX", 0)
	self.products[1]:createHighlight()
	self.products[1]:setVisible(false)
	self.products[1]:setClickable(false)
	self.products[1]:setAnchorPointType(BOTTOMCENTER)
	self.products[1]:setX(x)
	self.products[1]:setY(y)
	self:addChild(self.products[1])
		
	self.products[2] = createSprite()
	self.products[2]:setDefaultSection(player:getCurrentResourceSection())
	self.products[2]:animate("OBJECT_PAN", 0)	
	self.products[2]:createHighlight()
	self.products[2]:setClickable(false)
	self.products[2]:setVisible(false)
	self.products[2]:setAnchorPointType(BOTTOMCENTER)
	self.products[2]:setX(x)
	self.products[2]:setY(y)
	self:addChild(self.products[2])
	
	self.products[3] = createSprite()
	self.products[3]:setDefaultSection(player:getCurrentResourceSection())
	self.products[3]:animate("OBJECT_KNIFES", 0)	
	self.products[3]:createHighlight()
	self.products[3]:setVisible(false)	
	self.products[3]:setClickable(false)
	self.products[3]:setAnchorPointType(BOTTOMCENTER)
	self.products[3]:setX(x)
	self.products[3]:setY(y)	
	self:addChild(self.products[3])
	

end

function actionTable:onClick()

    self:playSound("SOUND_OBJECT_CLICK")

	if (not self:isSelected()) then
		self:setSelected(true)
		self:setClickable(false)
		self.timer = 0
		self.state = "waiting for emily"
		emily:qWorkOn(self)

	
	end

end

function actionTable:moveCameraToTable()

	cameraMan:qSetWalkTimePerNode(self.cameraManWalkTimePerNodeBusy)
	cameraMan:qWalkToXY(self.cameraManX, self.cameraManY)
	cameraMan:qAnimate(self.cameraManPose, 0)

end

function actionTable:moveCameraToHome()

	cameraMan:qAnimate("IDLE", 0)
	cameraMan:qSetWalkTimePerNode(self.cameraManWalkTimePerNodeIdle)
	cameraMan:qWalkToXY(cameraManHomeX, cameraManHomeY)

end

function actionTable:onWorkStart(task)

	self.state = "waiting for camera"
	self:setSelected(false)
	return true

end

function actionTable:onWorkUpdate(task, time)
	
	if (self.state == "waiting for camera") then
		local gridX = cameraMan:getPosition():getGridX()
		local gridY = cameraMan:getPosition():getGridY()
		if (gridX == self.cameraManX) then
			if (gridY == self.cameraManY) then
				self.state = "waiting for timer"
				self.timer = self.timeWork
				task:getPerson():animate("PRESENT", 1, false, -1, true)

			end
		end	
	elseif (self.state == "waiting for timer") then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				return true
							
			end		
		end	
	end
	
	return false
	
end

function actionTable:onWorkComplete(task)

	incScore(self.score * um:getMiscMultiplier(), emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)		
	self:setClickable(false)
	self.state = "idle"
	self.products[self.index]:setVisible(false)
	self:moveCameraToHome()
	
	emily:qNotify("clap spectators")
	
end