class 'candyJars' (Appliance)

candyJars.products = 
{
	{ "CANDY_CANE", "CHOCOLATE", "LOLLIPOP" },	
	{ "CANDY_KEY", "MINT_CANDY", "TOFFEE" },
	{ "LITTLE_CAKE", "TUMTUM", "SUGAR_HEART" },		
}
candyJars.colIdx = 0
candyJars.rowIdx = 0

function candyJars:__init() super()
end

function candyJars:onWorkStart(task)

	if (Appliance.onWorkStart(self, task)) then
		self.colIdx = 0
		self.rowIdx = 0	
		self:queueNextProduct(task:getPerson())
		
	end
	
	return false
	
end

function candyJars:disableColumn(idx)

	if (idx == nil) then
		idx = self.colIdx
		
	end
	
	if (getProduct(self.products[idx][1])) then getProduct(self.products[idx][1]).disabled = true end
	if (getProduct(self.products[idx][2])) then getProduct(self.products[idx][2]).disabled = true end
	if (getProduct(self.products[idx][3])) then getProduct(self.products[idx][3]).disabled = true end

end

function candyJars:enableColumn(idx)

	if (idx == nil) then
		idx = self.colIdx
		
	end
	
	if (getProduct(self.products[idx][1])) then getProduct(self.products[idx][1]).disabled = false end
	if (getProduct(self.products[idx][2])) then getProduct(self.products[idx][2]).disabled = false end
	if (getProduct(self.products[idx][3])) then getProduct(self.products[idx][3]).disabled = false end

end

function candyJars:queueNextProduct(person)

	for ic = 1,3 do
		if (ic >= self.colIdx) then
			for ir = 1,3 do
				
				local product = getProduct(self.products[ic][ir])
				if (product) then
					if (product:getStock() < product:getMaxStock()) then
					
						insert()		
						person:qWorkOn(product)
						append()	
						
						self.colIdx = ic
						self.rowIdx = ir						
						return
									
					end		
				end
			end	
		end
	end
	
end