include("scripts/products/candyOvenProduct.lua")
--
-- Candy oven just has the products that can be baked in the candy store
--
class 'candyOven' (Appliance)

candyOven.prod1X = -39
candyOven.prod1Y = -46
candyOven.prod2X = -3
candyOven.prod2Y = -44

candyOven.animFrameCount = 23
candyOven.animFramesPerSec = 3

-- internal
candyOven.timerValue = 0
candyOven.timerSuspended = false
candyOven.state = "EMPTY"

candyOven.product1 = nil
candyOven.product2 = nil

function candyOven:__init() super()
end

function candyOven:onCreate()
	Appliance.onCreate(self)
	-- self:createHighlight()
	self:setState("EMPTY")
	
	-- setup the dummy products
	self:setupDummyProducts()
	
end

--
function candyOven:onClick()
	
	self:playSound("SOUND_OBJECT_CLICK")
	
	if (self:canEmpty() or self:canBake()) then
		if (self:getState() == "READY") then
			self.timerSuspended = true
		end
		
		Appliance.onClick(self)
	end
end

--
function candyOven:onWorkStart(task)
	
	--cout(" onWorkStart:  state is: " ..self:getState() .."\n")
	if (self:getState() == "EMPTY") then
		self:setState("PREPARING_CAKES")
		task:setDuration(800)
		task:getPerson():animate("WORK", -1, false, -1)
		return true
		
	elseif (self:getState() == "READY") then
		task:setDuration(400)
		task:getPerson():animate("WORK", -1, false, -1)
		self:setState("EMPTYING")
		return true
		
	elseif (self:getState() == "BURNING" or self:getState() == "BURNT") then
		task:setDuration(1000)
		task:getPerson():animate("WORK", -1, false, -1)
		return true
	end
	
	--self:setEmptyingProducts(false)
	return false

end

--
function candyOven:fillProductStocks(prodName)

	local prod = getProduct(prodName)
	if (prod ~= nil) then
		prodOrder = prod:getMaxStock() - prod:getStock()
		if (prodOrder > 0) then
			self:createBakedProduct(prodName)
		end
	end
	
end

--
function candyOven:onWorkComplete(task)

	if (self:getState() == "PREPARING_CAKES") then
		self:setState("WORKING")
		
	elseif (self:getState() == "EMPTYING") then
		self:fillProductStocks("CANDY_CAKE")
		self:fillProductStocks("CANDY_COOKIE")
		
		--self:setEmptyingProducts(false)
		self:setState("EMPTY")
	elseif (self:getState() == "BURNING" or self:getState() == "BURNT") then
		self:onClearBurnt()
	end
	
	Appliance.onWorkComplete(self, task)
	self.timerSuspended = false
end

--
function candyOven:onTick(time)
	
	if (scene:isPlayingMovie() or scene:isStartingMovie()) then
		-- ignore ticks during movies
		return
	end
	if (not self.timerSuspended) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			if (self:getState() == "WORKING") then
				self:setState("READY")
				hm:openHint(HINT_CAKEDONE, self:getScreenX() - 30, self:getScreenY() - 40)
			elseif (self:getState() == "READY") then
				self:setState("BURNING")
			elseif (self:getState() == "BURNING") then
				self:setState("BURNT")
			end	
		end
	end
	
end

function candyOven:onBurning()
	
	if (self.product1 ~= nil) then
		self.product1:animate("CANDY_CAKE_BURN", 1, false, 10, true)
		self.product1:setY(self.product1:getY() - 19)
	end
	
	if (self.product2 ~= nil) then
		self.product2:animate("CANDY_COOKIE_BURN", 1, false, 10, true)
		self.product2:setY(self.product2:getY() - 19)
	end
	
end

function candyOven:onBurnt()
	-- change the appearance?
	self:showDummyProducts(false)
	--self:setState("EMPTY")
	if (self.product1 ~= nil) then
		self.product1:animate("PROD_BUT_CANDY_CAKE", 0)
		self.product1:setY(self.product1:getY() + 19)
	end
	
	if (self.product2 ~= nil) then
		self.product2:animate("PROD_BUT_CANDY_COOKIE", 0)
		self.product2:setY(self.product2:getY() + 19)
	end
end

function candyOven:onClearBurnt()
	self:setState("EMPTY")
end

--
function candyOven:getState()
	return self.state
	
end

--
function candyOven:setState(newState)
	
	self.state = newState
	--cout("set state: " .. self.state .. "\n")
	
	if (self.state == "EMPTY") then
		self:animate("APP_OVEN_CLOSED", 0)
		self.timerSuspended = true
		self:setVisible(true)
		
		self:showDummyProducts(false)
		
	elseif (self.state == "WORKING") then
		local animDuration = self.animFrameCount				-- Nr frames in animation
		animDuration = animDuration * 1000						-- ms
		animDuration = animDuration / self.animFramesPerSec		-- frames per sec
		
		if getProduct("CANDY_COOKIE") then
			self:animate("APP_OVEN_WORKING", -1, self.animFramesPerSec)
			
		else
			self:animate("APP_OVEN_CAKE_WORKING", -1, self.animFramesPerSec)
		
		end
		
		self:playSound("SOUND_OVEN_ON")
		self.timer = animDuration
		self.timerSuspended = false
	
	elseif (self.state == "READY") then
		self:animate("APP_OVEN_READY", -1, self.animFramesPerSec)
		self:playSound("SOUND_OVEN_DONE")
		self.timer = 5000
		self.timerSuspended = false
		
		self:showDummyProducts(true)
	
	elseif (self.state == "BURNING") then
		-- self:animate("APP_OVEN_BURNING", -1, 2)
		self:onBurning()
		self:playSound("SOUND_OVEN_BURNS")
		self.timer = 2000
		self.timerSuspended = false

	elseif (self.state == "BURNT") then
		self:onBurnt()
		--self:setState("EMPTY")
		self.timerSuspended = true		
	end
	
end

-- ======================================================
-- Extra product admin
-- ======================================================

function candyOven:canOrder(prodName)
	
	local prod = getProduct(prodName)
	if (prod ~= nil) then
		local prodOrder = prod:getMaxStock() - prod:getStock()
		if (prodOrder > 0) then
			return true
		end	
	end
	
	return false
end

-- Determines whether or not the oven can be used
function candyOven:canBake()

	if (self:getState() ~= "EMPTY") then
		return false
	end
	
	if (self:canOrder("CANDY_CAKE")) then
		return true;
	end
	
	if (self:canOrder("CANDY_COOKIE")) then
		return true;
	end
	
	return false
	
end

--
function candyOven:canEmpty()
	
	if (self:getState() == "READY" or self:getState() == "BURNING" or self:getState() == "BURNT") then
		return true
	end
	return false
	
end

--
-- Creates a fake product at the correct position and moves it
-- to the application
function candyOven:createBakedProduct(base)
	
	local xOff = 0
	local yOff = 0
	if (base == "CANDY_CAKE" ) then
		xOff = self.prod1X
		yOff = self.prod1Y
		
	elseif (base == "CANDY_COOKIE") then
		xOff = self.prod2X
		yOff = self.prod2Y
	end
	p = candyOvenProduct(base)
	p:setX(xOff + self:getX())
	p:setY(yOff + self:getY())
	p:moveToAppliance(self)

end

-- Dummy products that show up when the oven opens
function candyOven:setupDummyProducts(showFlag)
	
	if (self.product1 ~= nil) then
		self.product1:setObsolete(true)
		self.product1 = nil
	end
	
	if (self.product2 ~= nil) then
		self.product2:setObsolete(true)
		self.product2 = nil
	end
	
	self.product1 = createSprite()
	self.product1:setDefaultSection(player:getCurrentResourceSection())
	self.product1:animate("PROD_BUT_CANDY_CAKE", 0)
	self.product1:setX(self.prod1X)
	self.product1:setY(self.prod1Y)
	self:addChild(self.product1)
	
	self.product2 = createSprite()
	self.product2:setDefaultSection(player:getCurrentResourceSection())
	self.product2:animate("PROD_BUT_CANDY_COOKIE", 0)
	self.product2:setX(self.prod2X)
	self.product2:setY(self.prod2Y)
	self:addChild(self.product2)
	
	self:showDummyProducts(false)
end

function candyOven:showDummyProducts(showFlag)
	
	if (self.product1 ~= nil) then
		if (showFlag == false or getProduct("CANDY_CAKE")) then
			self.product1:setVisible(showFlag)
		end
	end
	
	if (self.product2 ~= nil) then
		if (showFlag == false or getProduct("CANDY_COOKIE")) then
			self.product2:setVisible(showFlag)
		end
	end
	
end

