-- a hidden object
class 'churnerAppliance' (Appliance)

-- internal variables
churnerAppliance.timer = 0
churnerAppliance.currentProduct = nil
churnerAppliance.finishedProduct = nil
churnerAppliance.productClicked = false
churnerAppliance.hint = false

function churnerAppliance:__init() super()
end

function churnerAppliance:onClick()

    self:playSound("SOUND_OBJECT_CLICK")

	if (self:isSelected() == false) then
        if (self:getOverhead()) then
            if (self:getOverhead():getTag() == 12345) then
                self.hint = true
            end	    
        end
	
		Appliance.onClick(self)
		self:setSelected(true)	
		getProduct("MILK"):queue()
		
	end
	
end

function churnerAppliance:onWorkStart(task)

	self:setSelected(false)

	if (getProduct("MILK"):isQueuedOnTray()) then
		if (Appliance.onWorkStart(self, task)) then
		    local milkTin = getAppliance("rest1_milk_tin")	
		    local currentFrame = milkTin:getCurrentFrame()
		    if (milkTin:getCurrentFrame() > 0) then
		    	self:animate("ANIM_CHURNER_ACTIVE", -1, 10)
	        	self.timer = 0
		        self.currentProduct = "MILK"
		        self.finishedProduct = nil
		        self.productClicked = false
		        self:playSound("SOUND_CHURNER_LOOP", true)
		
		        emily:animate("CHURN_FRONT", -1, 10)
		        milkTin:setCurrentFrame(currentFrame - 1)
		        
		        return true
		        
		    else
		    	createFloater(getText("NO_MORE_MILK"), self:getX(), self:getY(), 500)
				self:playSound("SOUND_NO_STOCK")
				getProduct("MILK"):unQueue()
				
	        end
		end
	else
		tray:clearInvisible()
	
	end
	
	return false

end

function churnerAppliance:onWorkUpdate(task, time)

	if (not self.productClicked) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
		
			self.timer = 1000
			
			if (self.currentProduct == "FINISH") then
				-- Ready with churning: Remove butter and finish task:
				-- cout("finish ")
				self.finishedProduct = nil
				self.currentProduct = nil
				getProduct("BUTTER"):setVisible(false)
				getProduct("BUTTER"):setClickable(false)
				getProduct("BUTTER"):unQueue()
				
				return true
			
			elseif (self.currentProduct == "BUTTER") then
				-- Butter is ready: show milk and continue churning
				-- cout("making butter ")
				self.finishedProduct = "BUTTER"
				getProduct("BUTTERMILK"):setVisible(false)
				getProduct("BUTTERMILK"):setClickable(false)
--				getProduct("BUTTERMILK"):unQueue()
				getProduct("BUTTER"):setVisible(true)
				getProduct("BUTTER"):setClickable(true)
				getProduct("BUTTER"):queue()
				
				-- hint
				if (self.hint) then
				    hm:openHint(HINT_CHURNER, self:getScreenX() + 50, self:getScreenY())
				end
				
				-- next stop: Finish churning:
				self.currentProduct = "FINISH"
			
			elseif (self.currentProduct == "BUTTERMILK") then
				-- Yoghurt / Butter milk is ready: show yoghurt and continue churning
				-- cout("making buttermilk ")
				self.finishedProduct = "BUTTERMILK"
				getProduct("MILK"):setVisible(false)
				getProduct("MILK"):setClickable(false)
--				getProduct("MILK"):unQueue()
				getProduct("BUTTERMILK"):setVisible(true)
				getProduct("BUTTERMILK"):setClickable(true)
				getProduct("BUTTERMILK"):queue()
				
				-- next stop: Butter:
				self.currentProduct = "BUTTER"
					
			elseif (self.currentProduct == "MILK") then
				-- Milk is ready: show milk and continue churning
				-- cout("making milk ")
				self.finishedProduct = "MILK"
				getProduct("MILK"):setVisible(true)
				getProduct("MILK"):setClickable(true)
				
				-- next stop: Butter milk:
				self.currentProduct = "BUTTERMILK"
				
			end
		end
	end
	
	-- Continue churning if not clicked on a product:
	return self.productClicked

end

function churnerAppliance:onWorkComplete(task)

    -- Hint
    if (self.hint) then
        if (self.finishedProduct ~= "BUTTER") then
            self:createScreenOverhead("INGAME_ARROW")
            self:getOverhead():setTag(12345)
	        self.hint = false
	        
        else
        	self.hint = false
        
        end
    end

	self:stopSound("SOUND_CHURNER_LOOP")
	self:animate("APP_CHURNER", 0)
	
	-- In case we clicked a product, make sure all products are hidden:
	getProduct("MILK"):setVisible(false)
	getProduct("MILK"):setClickable(false)
	getProduct("BUTTERMILK"):setVisible(false)
	getProduct("BUTTERMILK"):setClickable(false)
	getProduct("BUTTER"):setVisible(false)
	getProduct("BUTTER"):setClickable(false)
	
	self.productClicked = false
	Appliance.onWorkComplete(self, task)
	
	-- Cow hint
    local milkTin = getAppliance("rest1_milk_tin")	
    local currentFrame = milkTin:getCurrentFrame()	
    if (currentFrame == 0) then
        local cow = getAppliance("rest1_cow")
        if (cow) then
        	hm:placeArrow(ARROW_HINT_COW, cow, 0, 50)
        
        end
    end
    
	-- Milk empty
	if (currentFrame == 0) then
		self:playSound("SOUND_MILKCAN_EMPTY")
	
	end    
	
end

function churnerAppliance:onWorkClick()

	if (self.productClicked == false) then
		if (self.finishedProduct) then
			getProduct(self.finishedProduct):moveToTray()
			self.productClicked = true
			return true
		end
	end
	return true
	
end
