include("scripts/products/regularproduct.lua")

class 'cottonCandyAppliance' (Appliance)

cottonCandyAppliance.stickTime	= 500		-- Time spent as a stick
cottonCandyAppliance.smallTime	= 1000		-- Time spent as a small product
cottonCandyAppliance.largeTime	= 500		-- Time spent as a large product

-- internal
cottonCandyAppliance.timer = 0
cottonCandyAppliance.productClicked = false
cottonCandyAppliance.expanding		= true
cottonCandyAppliance.productName	= nil

function cottonCandyAppliance:__init(prodName) super()
	self:setProductName(prodName)
end

function cottonCandyAppliance:onClick()

	if (self:getState() ~= "NOTHING") then
		-- don't accept clicks when emily is working on it
		return
	
	end
	
    self:playSound("SOUND_OBJECT_CLICK")

	if (self:isSelected() == false) then
		-- we need to reserve our spot on the tray here
		local product = getProduct(self.productName)
		if (product:isQueuableToTray()) then
			product:queue()
				
		end    
		
		Appliance.onClick(self)
		self:setSelected(true)		
	end
	
end

function cottonCandyAppliance:setProductName(name)
	self.productName = name
end

function cottonCandyAppliance:onWorkStart(task)
	
	self:setSelected(false)
	
	local product = getProduct(self.productName)	
	
	if (product:isQueuedOnTray() and Appliance.onWorkStart(self, task)) then
		emily:animate("WORK_FRONT", -1, 10)
		self:setState("STICK")
		self:playSound("SOUND_COTTONCANDY_LOOP", true)
		return true
		
	else
		tray:clearInvisible()
		return false	
		
	end
	
end

function cottonCandyAppliance:onWorkUpdate(task, time)

	if (not self.productClicked) then
	
		self.timer = self.timer - time
		if (self.timer <= 0) then
		
			local currState = self:getState()
			if (currState == "STICK") then
				
				self.expanding = true
				self:setState("SMALL")
				
			elseif (currState == "SMALL") then
				
				if (self.expanding) then
					self:setState("LARGE")
				else
					self:setState("STICK")
				end
				
			else
				self.expanding = false
				self:setState("SMALL")
			end
		end

	end
	
	-- Continue if not clicked on a product
	return self.productClicked

end

function cottonCandyAppliance:onWorkClick()

	if (self.productClicked == false) then
		if (self:getState() == "STICK" or self:getState() == "NOTHING") then
			-- 'Stick' state is invalid - just ignore the click
		elseif (self.productName) then
			local product = getProduct(self.productName)
			if (product) then
				product:moveToTray()
					
			else
				warn("cottonCandyAppliance:onWorkClick - something is wrong: ")
				
			end	
		
			self.productClicked = true
			return true
		end
	end
	
	return true
	
end

function cottonCandyAppliance:getState()
	if (self.productName) then
		return getProduct(self.productName):getState()
	else
		warn("cottonCandyAppliance - NO PRODUCT NAME!!")
	end
	
	return "NOTHING"
end

function cottonCandyAppliance:setState(state)

	if (state == "STICK") then
		self.timer = self.stickTime
	elseif (state == "SMALL") then
		self.timer = self.smallTime
	elseif (state == "LARGE") then
		self.timer = self.largeTime
	end
	
	if (self.productName) then
		local product = getProduct(self.productName)
		product:setState(state)
	end
	
end

function cottonCandyAppliance:onWorkComplete(task)
	self:setState("NOTHING")
	self:stopSound("SOUND_COTTONCANDY_LOOP")
	self.productClicked = false
	Appliance.onWorkComplete(self, task)
end

-- ============================================================================
-- Cotton candy product
-- ============================================================================
class 'cottonCandyProduct' (regularProduct)

function cottonCandyProduct:__init(baseName) super(baseName)
end

function cottonCandyProduct:onCreate()
	self:setState("NOTHING")
	self:setClickable(false)
end

function cottonCandyProduct:onClick()
end

function cottonCandyProduct:onStateEnter(state)

	if (state == "LARGE") then
		hm:openHint(HINT_COTTONCANDY_READY, 170, 100)
	
	end

	local imageName = "PROD_BUT_" .. self:getBase() .. "_"
	if (state == "NOTHING") then
		-- Take it back to the start
		self:animate(imageName .. "STICK", 0)
		self:setVisible(false)
	else
		self:animate(imageName .. state, 0)
		self:setVisible(true)
	end
	
end
