class 'cow' (Appliance)

cow.timer = 0
cow.timeToFillOneServing = 1500

cow.chewTimer = 0
cow.chewState = "WAITING"
cow.minChewTime = 1000 * 10			-- Minimum time the cow needs to chew her food
cow.maxChewTime = 1000 * 15			-- Maximum time the cow needs to chew her food
cow.minWaitTime = 1000 * 3			-- Minimum time the cow waits before eating again
cow.maxWaitTime = 1000 * 10			-- Maximum time the cow waits before eating again


function cow:__init() super()
end

function cow:onCreate()

	Appliance.onCreate(self)
	self:createHighlight()
	
	local milkTin = getAppliance("rest1_milk_tin")
	milkTin:setCurrentFrame(milkTin:getFrameCount() - 1)

end

function cow:onPlace()
	self.chewTimer = getRandomRange(self.minWaitTime, self.maxWaitTime)
	Appliance.onPlace(self)
end

function cow:onTick(time)
	if (self.chewTimer > 0) then
		self.chewTimer = self.chewTimer - time
		if (self.chewTimer <= 0) then
		
			if (self.chewState == "CHEWING") then
				-- Done chewing:
				self.chewState = "WAITING"
				self:animate("IDLE", 0)
				self:setY(self:getY())
				self.chewTimer = getRandomRange(self.minWaitTime, self.maxWaitTime)
				
			elseif (self.chewState == "WAITING") then
				-- Start eating
				self.chewState = "EATING"
				self:animate("APP_COW_EAT", 1, 5)
				self:setY(self:getY())
				self.chewTimer = 2000
				
			elseif (self.chewState == "EATING") then
				-- Start chewing
				self.chewState = "CHEWING"
				self:animate("APP_COW_CHEW", -1, 6)
				self.chewTimer = getRandomRange(self.minChewTime, self.maxChewTime)
				
			end
		end
	end	
	
end

function cow:onClick()

    self:playSound("SOUND_OBJECT_CLICK")

	if (not self:isSelected()) then
		self:setSelected(true)	
		Appliance.onClick(self)		
	
	end

end

function cow:onWorkStart(task)

	self:setSelected(false)

	if (Appliance.onWorkStart(self, task)) then
		local milkTin = getAppliance("rest1_milk_tin")		
		if (milkTin:getCurrentFrame() < milkTin:getFrameCount() - 1) then
			self.timer = self.timeToFillOneServing * um:getMilkTimeMultiplier()
			self:playSound("SOUND_COW_MILK_LOOP", true)
			self:clearOverhead()
			
			task:getPerson():animate("COW_MILK", -1)
			task:setDuration(-1)
			
    		player:setNeverShowHint(ARROW_HINT_COW)				
		
		    local tail = getObject("rest1_cow_tail")
		    tail:animate("DECO_COW_TAIL_ANIM", -1, false, 10)
		
		else
			return false
		
		end
	end

	return true
	
end

function cow:onWorkUpdate(task, time)

	Appliance.onWorkUpdate(self, task, time)

	local milkTin = getAppliance("rest1_milk_tin")
	local currentFrame = milkTin:getCurrentFrame()
	
	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			-- update current frame
			milkTin:setCurrentFrame(currentFrame + 1)

			-- reset timer
			self.timer = self.timeToFillOneServing * um:getMilkTimeMultiplier()
				
		end	
	end
	
	local milkTinFull = false
	if (milkTin:getCurrentFrame() == (milkTin:getFrameCount() - 1)) then
		milkTinFull = true
		self:playSound("SOUND_COW_MOO")
		
	end
	
	return (emily:hasTasksToDo() or milkTinFull)
	
end

function cow:onWorkComplete(task)

	Appliance.onWorkComplete(self, task)
	
    local tail = getObject("rest1_cow_tail")
    tail:animate("DECO_COW_TAIL", 0)
    
    self:stopSound("SOUND_COW_MILK_LOOP")
    
end