class 'fruitTreeAppliance' (Appliance)

-- internal variables
fruitTreeAppliance.timer = 0
fruitTreeAppliance.workTimer = 0
fruitTreeAppliance.maxFruitAmount = 0
fruitTreeAppliance.currentFruitAmount = 0
fruitTreeAppliance.currentFruitGrowStep = 0

fruitTreeAppliance.fruitGrowStepTime = 2000
fruitTreeAppliance.fruitGrowSteps = 3
fruitTreeAppliance.fruitProductBaseName = "APPLE_"
fruitTreeAppliance.fruitPresent = false

function fruitTreeAppliance:__init() super()
end

function fruitTreeAppliance:onCreate()
	Appliance.onCreate(self)
	
	self.timer = self.fruitGrowTime
	self.currentFruitAmount = 0
	self.currentFruitGrowStep = 0

end

function fruitTreeAppliance:onPlace()
	Appliance.onPlace(self)
	
	if (self:getProduct(self.fruitProductBaseName .. 0)) then
		self.fruitPresent = true
	else
		self:removeHighlight()
	end

end

function fruitTreeAppliance:onClick()

    self:playSound("SOUND_OBJECT_CLICK")

	if (self:isSelected() == false) then
		self:setSelected(true)
		Appliance.onClick(self)
		
	end	

end

function fruitTreeAppliance:onTick(time)
	Appliance.onTick(self, time)
	
	if (scene:isStartingMovie()) then
		return
	end
	
	if (scene:isPlayingMovie()) then
		return
	end
	
	if (self.fruitPresent) then
		
		if (self.currentFruitAmount < self.maxFruitAmount) then
			self.timer = self.timer - time
			
			-- Make the current fruit grow:		
			if (self.timer <= 0) then
				if (self.currentFruitGrowStep < self.fruitGrowSteps) then
					-- The currently growing fruit should get one step bigger
					local growingFruit = self:getProduct(self.fruitProductBaseName .. self.currentFruitAmount)
					if (growingFruit) then
						growingFruit:setScaleX((self.currentFruitGrowStep + 1) / self.fruitGrowSteps)
						growingFruit:setScaleY((self.currentFruitGrowStep + 1) / self.fruitGrowSteps)
						growingFruit:setVisible(true)
					end
					self.currentFruitGrowStep = self.currentFruitGrowStep + 1
			
				end
				
				if (self.currentFruitGrowStep == self.fruitGrowSteps) then
					-- Our fruit is grown up, time to start growing new fruit
					self.currentFruitAmount = self.currentFruitAmount + 1
					self.currentFruitGrowStep = 0
					
				end
				self.timer = self.fruitGrowStepTime * um:getFruitGrowMultiplier()
				
			end
			
		end
		
	end
	
end

function fruitTreeAppliance:onWorkStart(task)
	
	self:setSelected(false)

	if (self.currentFruitAmount > 0) then
		if (Appliance.onWorkStart(self, task)) then
	        emily:animate("SHAKETREE", -1)
	        player:setNeverShowHint(ARROW_HINT_APPLETREE)
	        self:clearOverhead()
			self:playSound("SOUND_SHAKE_TREE", true)
	        self.workTimer = 1000
	        return true
		        
		end
	end
	
	return false

end

function fruitTreeAppliance:onWorkUpdate(task, time)
	self.workTimer = self.workTimer - time
	
	if (self.workTimer <= 0) then
		return true
		
	end
	
	return false

end

function fruitTreeAppliance:onWorkComplete(task)
	
	local basket = getAppliance("rest1_basket_cherry")
	
	if (self.fruitProductBaseName == "APPLE_") then
		basket = getAppliance("rest1_basket_apple")
		
	end
	
	for i = 0,self.currentFruitAmount - 1 do
		local fruit = getProduct(self.fruitProductBaseName .. i)
		fruit:moveToAppliance(basket)
	
	end

	-- Make sure all fruit is small again
	for i = 0,self.maxFruitAmount - 1 do
		local fruit = getProduct(self.fruitProductBaseName .. i)
		fruit:setScaleX(0)
		fruit:setScaleY(0)
		
	end
	
	self:stopSound("SOUND_SHAKE_TREE")
	self.timer = self.fruitGrowStepTime * um:getFruitGrowMultiplier()
	self.workTimer = 0
	self.currentFruitAmount = 0
	self.currentFruitGrowStep = 0
	
	Appliance.onWorkComplete(self, task)
	
end

function fruitTreeAppliance:setMaxFruitAmount(amount)
	self.maxFruitAmount = amount

end

function fruitTreeAppliance:setFruitProductBaseName(name)
	self.fruitProductBaseName = name

end