--
-- Simple Gumball Machine appliance that adds gumballs
-- to the bag every time it is clicked
class 'gumballMachine' (Appliance)

gumballMachine.count = 0

function gumballMachine:__init() super()
end

function gumballMachine:onCreate()
	Appliance.onCreate(self)
	self:createHighlight()
	self:getHighlight():setAlphaHitmaskThreshold(1)
end

function gumballMachine:onClick()
    Appliance.onClick(self)
    self:playSound("SOUND_OBJECT_CLICK")
    self:setSelected(true)
    self.count = self.count + 1
end

function gumballMachine:onWorkStart(task)

	self.count = self.count - 1
	self:setSelected(self.count > 0)
	
	-- error checking
	if (self.count < 0) then
		warn("gumballMachine:onWorkStart - invalid pulse counter")
	end

    -- Only work if the bag isn't full yet
    if (getProduct("GUMBALL_BAG"):getState() ~= "3") then
	    self:increaseGumballCount()
	    self:playSound("SOUND_GUMBALL_INBAG")
	    task:setDuration(200)
	    task:getPerson():animate("WORK_RIGHT", -1, false, -1)
	    return Appliance.onWorkStart(self, task)
	    
    end
    
    return false

end

-- Just adds more balls to the bag, if possible
function gumballMachine:increaseGumballCount()

	-- Check the product to see how many balls are in the bag
	gumballCount = getProduct("GUMBALL_BAG"):getState()
	if (gumballCount == "EMPTY") then
		getProduct("GUMBALL_BAG"):setState("1")
	elseif (gumballCount == "1") then
		getProduct("GUMBALL_BAG"):setState("2")
	elseif (gumballCount == "2") then
		getProduct("GUMBALL_BAG"):setState("3")
	end
end

