class 'hammerPole' (Appliance)

hammerPole.hitChance = 33
hammerPole.state = "idle"
hammerPole.ministate = 0
hammerPole.queuedCount = 0
hammerPole.busy = false
hammerPole.score = 10
hammerPole.timer = 0

function hammerPole:__init() super()
end

function hammerPole:onCreate()

	Appliance.onCreate(self)

end

function hammerPole:doNext()

	if (self:isVisible()) then
		self.queuedCount = self.queuedCount + 1
	
	end

end

function hammerPole:needsNext()

	if (not self.busy) then
		if (self.queuedCount > 0) then
			return true

		end	
	end
	
	return false

end

function hammerPole:queueNext(person)

	if (person == nil) then
		person = self:getWanderer()
	
	end

	if (person ~= nil) then
		person:walkToHammerPole()
		self:setClickable(false)
		self.queuedCount = self.queuedCount - 1
		self.busy = true
		
	end

end

function hammerPole:onTick(time)

	if (self:needsNext()) then
		self:queueNext()
	
	end
	
end

function hammerPole:onClick()

	if (self:isVisible()) then
		if (not self:isSelected()) then
			self:setClickable(false)
			self:setSelected(true)
			self.busy = true
			emily:qWorkOn(self)
		
		end
	end

end

function hammerPole:getWanderer()

	local allowedWanderers = {}
	for i=wandererId,wandererId-wandererPersonsCount,-1 do
		if (wandererPersons[i] ~= nil) then
			if (wandererPersons[i]:getBaseName() ~= "INGAME_CUSTOMER_FEMALE_ELDERLY") then
				if (wandererPersons[i]:getBaseName() ~= "INGAME_CUSTOMER_MALE_ELDERLY") then
					table.insert(allowedWanderers, wandererPersons[i])
					cout(wandererPersons[i]:getBaseName() .. "\n")
				end
			end
		end
	end

	-- try to get a waiting one
	for i=table.getn(allowedWanderers),1,-1 do
		if (allowedWanderers[i] ~= nil) then
			if (allowedWanderers[i].state == "waiting at location") then
				return allowedWanderers[i]
			
			end			
		end	
	end
	
	-- try to get a walking one
	for i=table.getn(allowedWanderers),1,-1 do
		if (allowedWanderers[i] ~= nil) then
			if (allowedWanderers[i].state == "walking to location") then
				return allowedWanderers[i]
			
			end			
		end	
	end	
	
	return nil

end

function hammerPole:onWorkStart(task)

	self:setSelected(false)

	if (self.state ~= "idle") then
		warn("hammerPole:onWorkStart - hammerpole isn't idle. invalid state")
		return false
		
	end

	if (Appliance.onWorkStart(self, task)) then
		if (getRandom(100) < self.hitChance) then
			self.state = "hit"
			self.ministate = 0
			self.timer = 200			
			self:animate("DECO_HAMMER_POLE_CLEAN", 0)
			self:playSound("SOUND_POLE_HIT")

			if (task:getPerson():getType() == "emily") then
				tm:checkSecretTrophy()
			end
			
		else
			self.state = "miss"
			self.ministate = 0
			self.timer = 200			
			self:animate("DECO_HAMMER_POLE_CLEAN", 0)
			self:playSound("SOUND_POLE_MISS")

		end	

		task:setDuration(-1)
		task:getPerson():animate("HAMMER", 1, false, -1, true)
		
		return true
	end
	
	return false

end

function hammerPole:onWorkUpdate(task, time)

	if (self.state == "hit") then
		if (self.ministate == 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self.timer = 550
				self.ministate = 1
				self:animate("DECO_HAMMER_POLE_UP", 1, false, -1, true)
			
			end
		elseif (self.ministate == 1) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self.timer = 1000
				self.ministate = 2
				self:animate("DECO_HAMMER_POLE_HIT", 5, false, -1, true)
			
			end		
		elseif (self.ministate == 2) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self.timer = 550
				self.ministate = 3
				self:animate("DECO_HAMMER_POLE_DOWN", 1, false, -1, true)
			
			end			
		elseif (self.ministate == 3) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self:animate("DECO_HAMMER_POLE", 0)
				return true
			
			end	
		end
	end		
	
	if (self.state == "miss") then	
		if (self.ministate == 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self.timer = 550
				self.ministate = 1
				self:animate("DECO_HAMMER_POLE_MISS", 1, false, -1, true)
			
			end
		elseif (self.ministate == 1) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self:animate("DECO_HAMMER_POLE", 0)
				return true
			
			end		
		end
	end
	
	return false

end

function hammerPole:onWorkComplete(task)
	
	self:setClickable(true)
	self.busy = false
	self.state = "idle"
	self.ministate = 0
	
	if (task:getPerson():getType() == "wanderer") then
		task:getPerson():walkAgain()	
		incScore(self.score, self:getScreenX() + 8, self:getScreenY() - 40, 0)
	
	end

end