class 'karaoke' (Appliance)

karaoke.event = false
karaoke.eventEarned = 0
karaoke.eventEarnAmount = 25
karaoke.eventEarnTarget = 1500
karaoke.eventEarnInterval = 1000 * 1
karaoke.timer = 0
karaoke.busy = false
karaoke.queued = false

function karaoke:__init() super()
end

function karaoke:needsNext()

    if (self.event) then
        return false
        
    end

    if (self.busy) then
        return false
        
    end

    return self.queued

end

function karaoke:queueNext(person)

	if (person == nil) then
		person = self:getWanderer()
	
	end

	if (person ~= nil) then
		person:walkToKaraoke()
		self.queued = false
		self.busy = true
		
	end

end

function karaoke:onTick(time)

	if (dayEnded) then
		self:setSelected(false)
		
	end

    if (not self.event) then
	    if (self:needsNext()) then
		    self:queueNext()
	
	    end
    end
	
end

function karaoke:onClick()

	self:playSound("SOUND_OBJECT_CLICK")

	if (self.busy) then
		return
		
	end
	
	if (dayEnded) then
		return
		
	end
	
	if (scene:isClosed()) then
		local wan = self:getWanderer()
		if (wan == nil) then
			return
			
		end	
	end
	
	if (not self:isSelected()) then
		self:clearOverhead()
		self:setSelected(true)
			
		if (self.event) then
			emily:qWorkOn(self)
		    self.busy = true
			
		else
            self.queued = true
            self.busy = false
            
		end
		
	end

end

function karaoke:getWanderer()

	-- try to get a waiting one near the stand
	for i=wandererId,wandererId-wandererPersonsCount,-1 do
		if (wandererPersons[i] ~= nil) then
			if (wandererPersons[i].state == "waiting at location") then
				local gridX = wandererPersons[i]:getPosition():getGridX()
				local gridY = wandererPersons[i]:getPosition():getGridY()
				if ((gridX == 26) and (gridY == 20)) then
					return wandererPersons[i]	
				
				end			
			end			
		end	
	end

	-- try to get a waiting one
	for i=wandererId,wandererId-wandererPersonsCount,-1 do
		if (wandererPersons[i] ~= nil) then
			if (wandererPersons[i].state == "waiting at location") then
				return wandererPersons[i]
			
			end			
		end	
	end
	
	-- try to get a walking one
	for i=wandererId,wandererId-wandererPersonsCount,-1 do
		if (wandererPersons[i] ~= nil) then
			if (wandererPersons[i].state == "walking to location") then
				return wandererPersons[i]
			
			end			
		end	
	end	
	
	return nil

end

function karaoke:onWorkStart(task)
	
	scene:setDropMood(false)
	self:setSelected(false)
	
	if (self.event) then
		self.timer = self.eventEarnInterval
		self:playSound("SOUND_SINGING_FEMALE_LOOP", true)
		emily:animate("SING", -1)
		return true
	
	else
		pm:spawnHearts()	
		self:playSound(task:getPerson().singSound, true)
		task:getPerson():animate("SING", -1)
		task:setDuration(6000)
		return true
	
	end

end

function karaoke:onWorkUpdate(task, time)

	if (self.event) then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self.eventEarned = self.eventEarned + self.eventEarnAmount
				if (self.eventEarned > self.eventEarnTarget) then
					self.eventEarned = self.eventEarnTarget
				end
				
				if (self.eventEarned == self.eventEarnTarget) then
					-- done
					self.timer = 0
				
				else
					-- not done
					self.timer = self.eventEarnInterval
				
				end
			end	
		end
		
		return (self.timer == 0) or (task:getPerson():hasTasksToDo()) or (level:isDayEnded()) or (level:isLastCustomerGone())
	
	else
		return false
	
	end
	
end

function karaoke:onWorkComplete(task)

	scene:setDropMood(true)	
	self.busy = false

	if (self.event) then
		self:stopSound("SOUND_SINGING_FEMALE_LOOP")
	
	elseif (task:getPerson():getType() == "wanderer") then
		self:stopSound(task:getPerson().singSound)
		task:getPerson():walkAgain()
	
	end

end