class 'stockAppliance' (Appliance)

stockAppliance.productName = ""
stockAppliance.productFillTime = 400
stockAppliance.productFillSound = ""
stockAppliance.timer = 0

function stockAppliance:__init() super()
end

function stockAppliance:onCreate()
	Appliance.onCreate(self)
	self:createHighlight()
end

function stockAppliance:onClick()

    Appliance.onClick(self)
    self:playSound("SOUND_OBJECT_CLICK")

end

function stockAppliance:onWorkStart(task)

    -- Only work if the bag isn't full yet
    if (getProduct(self.productName):getStock() < getProduct(self.productName):getMaxStock()) then
    	if (self.productName == "OREGANO") then player:setNeverShowHint(ARROW_HINT_OREGANO_OUT) end
    	if (self.productName == "CHIVES") then player:setNeverShowHint(ARROW_HINT_GREEN_ONION_OUT) end
    
	    task:setDuration(-1)
	    task:getPerson():animate("WORK_RIGHT", -1, false, -1)
	    self.timer = self.productFillTime
	    self:playSound(self.productFillSound, true)
	    self:clearOverhead()
	    return Appliance.onWorkStart(self, task)	    
    end
    
    return false

end

function stockAppliance:onWorkUpdate(task, time)

    local done = false

    if (self.timer > 0) then
        self.timer = self.timer - time
        if (self.timer <= 0) then
            getProduct(self.productName):incStock()
            
            if (getProduct(self.productName):getStock() < getProduct(self.productName):getMaxStock()) then
                self.timer = self.productFillTime
            
            else
                done = true
                
            end     
        end    
    end

    return (done) or (task:getPerson():hasTasksToDo())

end

function stockAppliance:onWorkComplete(task)

	self:stopSound(self.productFillSound)

end
