class 'cameraEvent' (interface)

-- configuration variables
cameraEvent.baseName = nil								-- sequence played when level starts
cameraEvent.coordinates = ""							-- appearance of the person
cameraEvent.score = 0									-- position person enters from
cameraEvent.sequenceStart = 0
cameraEvent.sequenceTooLate = 0
cameraEvent.sequenceCompleted = 0
cameraEvent.timerStart = 0
cameraEvent.timerReturn = 0
cameraEvent.scoreGotOne	= 0
cameraEvent.scoreGotAll	= 0
cameraEvent.actionDuration = 800				-- milliseconds an action takes when succesfully chased the object

-- internal variables
-- don't change unless you know what you're doing
cameraEvent.started = false
cameraEvent.completed = false
cameraEvent.camPerson = nil
cameraEvent.timer = 0
cameraEvent.index = 0
cameraEvent.heighest = 0
cameraEvent.state = ""
cameraEvent.first = true
cameraEvent.tooLate = false

function cameraEvent:__init() super()
end

function cameraEvent:onLevelInited()

  	-- create the person
	self.camPerson = pm:createPerson("cameraPerson")
	self.camPerson:setBaseName(self.baseName)
	self.camPerson:setPosition(entryNode)
	self.camPerson:createHighlight()
	self.camPerson:setClickable(false)
		
	-- set timer
	self.timer = self.timerStart

end

function cameraEvent:createPerson(class)

	if (class == "cameraPerson") then
		cp = cameraPerson(self.baseName)
		cp.event = self
		cp:setType(class)
		return cp
		
	end
		
	return nil
		
end

function cameraEvent:onTick(time)

	if (self.completed == false) then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				if (self.started == false) then
					-- enter francois
					self.started = true
					-- start sequence
					if (self.sequenceStart ~= nil) then
						qSequence(self.sequenceStart)			
					end	
					
					self.camPerson:qNotify("start")
					
				else
					-- go to previous node
					self:goToPrev()
				
				end
			
			end
		end
	end

end

function cameraEvent:onNotify(notification)

	if (notification == "start") then
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(table.getn(self.coordinates))
		eventBar:setProgress(0)	
		eventBar:setDescriptionText(getText("EVENTBAR"))
		eventBar:setSubjectImage("EVENT_CAMERA_BAR", player:getCurrentResourceSection())
		eventBar:animateToActive()	
		eventBar:raiseCurtain()

		self:goToNext()	
		
	elseif (notification == "arrived") then
		self.camPerson:setClickable(true)
		self.timer = self.timerReturn
		
		if (self.first) then
			self.camPerson:createOverhead("INGAME_ARROW")
			self.first = false
			
		end
	end

end

function cameraEvent:goToNext()
	
	-- walk to next node
	-- or complete the event
	self.timer = 0
	self.index = self.index + 1
	if (self.coordinates[self.index] == nil) then
		self.completed = true	
		-- completed sequence
		if (self.sequenceCompleted ~= nil) then
			qInsertSequence(self.sequenceCompleted)			
		end	
		
		-- increase score and pop a floater
		incScore(self.scoreGotAll, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")		
		self.camPerson:playSound(self.soundEventCompleteAll)
		self.camPerson:setClickable(false)
		self.camPerson:removeHighlight()
		
		-- update the eventbar
		eventBar:animateToDeactive()
			
	else
		local gridx = self.coordinates[self.index][1]
		local gridy = self.coordinates[self.index][2]
		
		if (self.coordinates[self.index][5] ~= nil) then
			qInsertSequence(self.coordinates[self.index][5])
		end
		
		self.camPerson:setClickable(false)
		self.camPerson:qWalkToXY(gridx, gridy)
		self.camPerson:qNotify("arrived")
	
	end
	
	-- update the eventbar
	eventBar:setProgress(self.index-1)

end

function cameraEvent:goToPrev()
	
	-- walk to previous node
	-- if available
	self.timer = 0
	if (self.index > 1) then
		self.index = self.index - 1
		
		-- too late sequence
		if (self.tooLate == false) then
			self.tooLate = true
			if (self.sequenceTooLate ~= nil) then
				qSequence(self.sequenceTooLate)
			end				
		end
		
		-- walk to previous node
		local gridx = self.coordinates[self.index][1]
		local gridy = self.coordinates[self.index][2]		
	
		self.camPerson:playSound(self.soundEventBad)
		self.camPerson:setClickable(false)
		self.camPerson:qWalkToXY(gridx, gridy)
		self.camPerson:qNotify("arrived")	
	end	
	
	-- update the eventbar
	eventBar:setProgress(self.index-1)

end

-- a camera person
class 'cameraPerson' (npc)

-- internal variables
-- don't change unless you know what you're doing
cameraPerson.event = nil	
cameraPerson.app = ""
cameraPerson.busy = false

function cameraPerson:__init(baseName) super(baseName)
end

function cameraPerson:onClick()

	if (not self.busy) then
		self.busy = true
		self.event.timer = 0
		self:setSelected(true)
		self:clearOverhead()
		emily:qWorkOn(self)
		
	end
	
end

function cameraPerson:onWorkStart(task)
	
	scene:qNotify("camera start")
	
	self:setSelected(false)
	task:setDuration(self.event.actionDuration)	

	return true	

end

function cameraPerson:onWorkComplete(task)

	scene:qNotify("camera complete")

	if (self.event.heighest < self.event.index) then
		self.event.heighest = self.event.index
		self:playSound(self.event.soundEventCompleteOne)
		incScore(self.event.scoreGotOne, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)	
		
	end

	self.event:goToNext()
	self.busy = false

end

function cameraPerson:getWorkNode()

	if (self.event.coordinates[self.event.index] ~= nil) then
		local gridx = self.event.coordinates[self.event.index][3]
		local gridy = self.event.coordinates[self.event.index][4]
		return grid:getNode(gridx, gridy)
	
	end
	
	return D2Person.getWorkNode(self)

end