class 'chaseBullyEvent' (interface)

-- configuration variables
chaseBullyEvent.baseName = nil								-- sequence played when level starts
chaseBullyEvent.coordinates = ""							-- appearance of the person
chaseBullyEvent.score = 0									-- position person enters from
chaseBullyEvent.sequenceStart = 0
chaseBullyEvent.sequenceTooLate = 0
chaseBullyEvent.sequenceCompleted = 0
chaseBullyEvent.timerStart = 0
chaseBullyEvent.timerReturn = 0
chaseBullyEvent.scoreGotOne	= 0
chaseBullyEvent.scoreGotAll	= 0
chaseBullyEvent.actionDuration = 800						-- milliseconds an action takes when succesfully chased the object

-- internal variables
-- don't change unless you know what you're doing
chaseBullyEvent.started = false
chaseBullyEvent.completed = false
chaseBullyEvent.camPerson = nil
chaseBullyEvent.timer = 0
chaseBullyEvent.index = 0
chaseBullyEvent.heighest = 0
chaseBullyEvent.state = ""
chaseBullyEvent.first = true
chaseBullyEvent.tooLate = false
chaseBullyEvent.startEventTimer = false

function chaseBullyEvent:__init() super()
end

function chaseBullyEvent:onLevelInited()

  	-- create the person
	self.camPerson = pm:createPerson("cameraPerson")
	self.camPerson:setBaseName(self.baseName)
	self.camPerson:setPosition(entryNode)
	self.camPerson:createHighlight()
	self.camPerson:setClickable(false)
		
	-- set timer
	self.timer = self.timerStart

end

function chaseBullyEvent:createPerson(class)

	if (class == "cameraPerson") then
		cp = cameraPerson(self.baseName)
		cp.event = self
		cp:setType(class)
		return cp
		
	end
		
	return nil
		
end

function chaseBullyEvent:startEvent()

	self.camPerson:qNotify("start")
	
end

function chaseBullyEvent:onTick(time)

	if (self.startEventTimer == true) and (self.completed == false) then
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				if (self.started == false) then
					-- enter francois
					self.started = true
					-- start sequence
					if (self.sequenceStart ~= nil) then
						qSequence(self.sequenceStart)			
					end	
					
				else
					-- go to previous node
					self:goToPrev()
				
				end
			
			end
		end
	end

end

function chaseBullyEvent:onNotify(notification)

	if (notification == "start") then
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(table.getn(self.coordinates))
		eventBar:setProgress(0)	
		eventBar:setDescriptionText(getText("EVENTBAR"))
		eventBar:setSubjectImage("EVENT_CHASE_BULLY_BAR", player:getCurrentResourceSection())
		eventBar:animateToActive()	
		eventBar:raiseCurtain()

		self:goToNext()	
		
	elseif (notification == "arrived") then
		self.timer = self.timerReturn
		self.camPerson:setClickable(true)
		self.camPerson:qAnimate("SITCRY", -1, 6)
		
		if (self.first) then
			self.camPerson:createOverhead("INGAME_ARROW")
			self.first = false
			
		end
	
	elseif (notification == "start event timer") then
		self.startEventTimer = true
		
	end

end

function chaseBullyEvent:goToNext()
	
	-- walk to next node
	-- or complete the event
	self.timer = 0
	self.index = self.index + 1
	if (self.coordinates[self.index] == nil) then
		self.completed = true
		
		self.camPerson:setClickable(false)
		self.camPerson:removeHighlight()

		-- completed sequence
		if (self.sequenceCompleted ~= nil) then
			qInsertSequence(self.sequenceCompleted)			
		end	
		
		-- increase score and pop a floater
		incScore(self.scoreGotAll, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY, scoreBonusFloaterDelay, "BONUS")		
		self.camPerson:playSound(self.soundEventCompleteAll)
		
		-- update the eventbar
		eventBar:animateToDeactive()
			
	else
		local gridx = self.coordinates[self.index][1]
		local gridy = self.coordinates[self.index][2]
		
		self.camPerson:setClickable(false)
		self.camPerson:qPlaySound("SOUND_BOY_CRYING")
		self.camPerson:qWalkToXY(gridx, gridy)
		self.camPerson:qNotify("arrived")
	
	end
	
	-- update the eventbar
	eventBar:setProgress(self.index-1)

end

function chaseBullyEvent:goToPrev()
	
	-- walk to previous node
	-- if available
	self.timer = 0
	if (self.index > 1) then
		self.index = self.index - 1
		
		-- too late sequence
		if (self.tooLate == false) then
			self.tooLate = true
			if (self.sequenceTooLate ~= nil) then
				qSequence(self.sequenceTooLate)
			end				
		end
		
		-- walk to previous node
		local gridx = self.coordinates[self.index][1]
		local gridy = self.coordinates[self.index][2]		
	
		self.camPerson:playSound(self.soundEventBad)
		self.camPerson:getHighlight():setActive(false)
		self.camPerson:qWalkToXY(gridx, gridy)
		self.camPerson:qNotify("arrived")	
	end	
	
	-- update the eventbar
	eventBar:setProgress(self.index-1)

end


-- a camera person
class 'cameraPerson' (npc)

-- internal variables
-- don't change unless you know what you're doing
cameraPerson.event = nil	
cameraPerson.app = ""
cameraPerson.busy = false

function cameraPerson:__init(baseName) super(baseName)
end

function cameraPerson:onClick()

	if (not self.busy) then
		self.event.timer = 0
		self.busy = true
		self:setSelected(true)
		self:clearOverhead()
		emily:qWorkOn(self)
		
	end
	
end

function cameraPerson:onWorkStart(task)
	
	scene:qNotify("camera start")
	
	task:setDuration(self.event.actionDuration)	
		
	return true	

end

function cameraPerson:onWorkComplete(task)

	scene:qNotify("camera complete")

	if (self.event.heighest < self.event.index) then
		self.event.heighest = self.event.index
		self:playSound(self.event.soundEventCompleteOne)
		incScore(self.event.scoreGotOne, emily:getScreenX(), emily:getScreenY() + scorePersonFloaterOffsetY)	
		
	end
	
	self.busy = false
	self.event:goToNext()

end

function cameraPerson:getWorkNode()

	if (self.event.coordinates[self.event.index] ~= nil) then
		local gridx = self.event.coordinates[self.event.index][3]
		local gridy = self.event.coordinates[self.event.index][4]
		return grid:getNode(gridx, gridy)
	
	end
	
	return D2Person.getWorkNode(self)

end
