class 'droppedObjectEvent' (interface)

-- configuration variables
droppedObjectEvent.sequenceStart = nil			-- sequence played when level starts
droppedObjectEvent.sequenceDroppedFirst = nil	-- sequence played when person can't perform task
droppedObjectEvent.sequenceDropped = nil		-- sequence played when person can't perform task
droppedObjectEvent.hookType = nil				-- task person can't perform
droppedObjectEvent.person = nil					-- person
droppedObjectEvent.timeUntilDropMin = 0			-- minimum walking time before starting drop checks
droppedObjectEvent.timeUntilDropMax = 1			-- maximum walking time before starting drop checks
droppedObjectEvent.timeUntilDropInt = 0			-- interval to do drop checks
droppedObjectEvent.dropChance = 0				-- drop chance, this is not percentual
droppedObjectEvent.dropIgnore = 0				-- number of walk talks to ignore after picking up object
droppedObjectEvent.preset = nil					-- preset file to use for the drop object
droppedObjectEvent.areas = nil					-- areas in which the item can drop or nil if everywhere
droppedObjectEvent.hintId = nil					-- hint id

-- internal variables
-- don't change unless you know what you're doing
droppedObjectEvent.started = false
droppedObjectEvent.completed = false
droppedObjectEvent.walking = false
droppedObjectEvent.dropped = false
droppedObjectEvent.timer = 0
droppedObjectEvent.desc = nil
droppedObjectEvent.droppedObject = nil
droppedObjectEvent.type = "DroppedObject"
droppedObjectEvent.ignore = 0
droppedObjectEvent.first = true

function droppedObjectEvent:__init() super()
end

function droppedObjectEvent:onLevelInited()

	-- init object description
	-- gridx and gridy will be set when the object drops
	self.desc = D2ObjectDesc()
	self.desc:setType(self.type)
	self.desc:setFilename(self.preset)

	-- start sequence
	if (self.sequenceStart ~= nil) then
		qSequence(self.sequenceStart)			
	end
	
end

function droppedObjectEvent:createObject(desc)

  	result = nil
  	
  	if (desc:getType() == self.type) then
  		result = droppedObject()
  		result.event = self
  		result:setType(desc:getType())
  	
  	end
  
	if (result ~= nil) then
		self.droppedObject = result
  
	end
  
  	return result	
	
end

function droppedObjectEvent:onDayBegin()

	self.started = true

end

function droppedObjectEvent:onTick(time)

	if (self.walking == true) then
		if (self.timer > 0) then
			self.timer = self.timer - time
			
			if (self.timer <= 0) then
			
				-- get gridx and gridy
				gridx = self.person:getPosition():getGridX()
				gridy = self.person:getPosition():getGridY()		
			
				local insideArea = true
				if (self.areas ~= nil) then
					insideArea = false
				    -- check if currently inside area
					for index, value in ipairs(self.areas) do
						if (self:contains(value, gridx, gridy)) then
							insideArea = true
							break
						end
					end
				end
				
				if (insideArea) then
					self.dropped = true
					self.desc:setGridX(gridx)
					self.desc:setGridY(gridy)
					
					-- add the object
					om:addObject(self.desc)
					
					-- get attention
					self.person:playSound("SOUND_EVENT_ATTENTION")
					
					-- set eventbar
					eventBar:setTotalShowed(false)
					eventBar:setProgressShowed(false)
					eventBar:setStartAmount(0)
					eventBar:setTargetAmount(1)
					eventBar:setProgress(0)	
					eventBar:setDescriptionText(getText("EVENTBAR"))
					eventBar:setSubjectImage(self.droppedObject:getBaseName() .. "_BAR", self.droppedObject:getDefaultSection())
					eventBar:animateToActive()
					eventBar:raiseCurtain()
					
				else
					-- check again
					self.timer = self.timeUntilDropInt
				
				end
			end
		end
	end

end

function droppedObjectEvent:onTaskHook(actorType, taskType, p0, p1)

	if (self.started == true) then
		if (self.person:getType() == actorType) then
			if (self.hookType == taskType) then
				if (self.dropped == true) then
					-- cancel the event
					-- dropped sequence

					local sequence = self.sequenceDropped
					if (self.first) then
						if (self.sequenceDroppedFirst ~= nil) then
							sequence = self.sequenceDroppedFirst
						end
						self.first = false
					end

					if (sequence ~= nil) then
						qInsertSequence(sequence)			
					end
					
					-- deselect object
					if (p0) then
						p0:setSelected(false)
					end
				
					return true
				
				end
			end
		end
	end
	
	return false

end

function droppedObjectEvent:onTaskStart(actorType, taskType, p0, p1)

    if (not dayEnded) then
    	if (self.started == true and self.dropped == false) then
    		if (self.person:getType() == actorType) then
    			if (taskType == "WalkToTask") then
    				if (self.ignore == 0) then
    			
    					self.walking = true
    					
    					if (getRandom(100) < self.dropChance) then
    						self.timer = getRandomRange(self.timeUntilDropMin, self.timeUntilDropMax)
    					
    					end
    					
    				elseif (self.ignore > 0) then
    					self.ignore = self.ignore - 1
    					
    				else
    					warn("droppedObjectEvent - 'ignore < 0', invalid!")
    					
    				end
    			end		
    		end
    	end
    end

end

function droppedObjectEvent:onTaskComplete(actorType, taskType, p0, p1)

    if (not dayEnded) then
    	if (self.started == true) then
    		if (self.person:getType() == actorType) then
    			if (taskType == "WalkToTask") then
    				self.walking = false
    				self.timer = 0
    			
    			end		
    		end
    	end
    end

end

function droppedObjectEvent:contains(rectangle, x, y)

	local left = rectangle[1]
	local top = rectangle[2]
	local right = rectangle[3]
	local bottom = rectangle[4]
	local width = right - left
	local height = bottom - top
	
	local x_ = x - left
	local y_ = y - top
	
	if (x_ < 0) then
		return false
	end
	
	if (y_ < 0) then
		return false
	end
	
	if (x_ >= width) then
		return false
	end
	
	if (y_ >= height) then
		return false
	end
	
	return true

end

-- a dropped object
class 'droppedObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
droppedObject.event = nil

function droppedObject:__init() super()
end

function droppedObject:onCreate()

	self:setDefaultSection(player:getCurrentResourceSection())
	self:animate(self:getBaseName(), 0)
	self:createHighlight()
	
end

function droppedObject:onPlace()

	if (self.event.first) then
		self:createOverhead("INGAME_ARROW")	
		if (self.event.hintId ~= nil) then
			hm:openHint(self.event.hintId, self:getScreenX(), self:getScreenY())
			
		end		
	end

end

function droppedObject:onClick()

	self:playSound("SOUND_OBJECT_CLICK")
	if (self:isSelected() == false) then
		self:setSelected(true)
		self:clearOverhead()
		self.event.person:qWorkOn(self)
	
	end

end

function droppedObject:onWorkStart(task)
	task:setDuration(0)
	return true

end

function droppedObject:onWorkComplete(task)
	self.event.ignore = self.event.dropIgnore
	self.event.dropped = false
	self.event.droppedObject = nil
	self:playSound(self.event.soundEventCompleteOne)
	self:qDestroy()
	
	eventBar:animateToDeactive()

end

function droppedObject:getWorkNode()
	return self:getPosition()

end