class 'fillEvent' (interface)

-- configuration variables
fillEvent.targetType = ""					-- Type of the object which we fill
fillEvent.targetGridX = -1					-- (optional) x location of the object
fillEvent.targetGridY = -1					-- (optional) y location of the object
fillEvent.emptyObject = nil					-- (optional) object we empty each fill
fillEvent.overheadY = 0						-- Overhead Y offset
fillEvent.speed = 0							-- Speed at which the bucket increases
fillEvent.readyProgress = 0					-- Progress at which fillObject is ready
fillEvent.spillProgress = 0					-- Progress at which fillObject is spilled
fillEvent.barBaseX = 0
fillEvent.barFullX = 0
fillEvent.barBaseY = 0
fillEvent.barFullY = 0
fillEvent.barClip  = nil
fillEvent.fillSound = ""

-- internal variables
-- don't change unless you know what you're doing
fillEvent.fillObject = nil
fillEvent.fillBar = nil
fillEvent.fillFront = nil

function fillEvent:__init() super()
end

function fillEvent:onStart()

	self.fillBar:setX(self.barBaseX)
	self.fillBar:setY(self.barBaseY)
	self.fillBar:setVisible(false)
	self.fillObject:setClickable(true)
	
end

function fillEvent:onComplete()

	self.fillObject:setClickable(false)
	scene:qNotify("fillEvent completed")

end

function fillEvent:onLevelInited()

	if (self.fillObject ~= nil) then

		-- create the bar
		self.fillBar = createSprite()
		self.fillBar:setDefaultSection(player:getCurrentResourceSection())
		self.fillBar:animate(self.fillObject:getBaseName() .. "_FILL", 0)
		self.fillBar:setX(self.barBaseX)
		self.fillBar:setY(self.barBaseY)
		self.fillBar:setAnchorPointType(TOPCENTER)
		self.fillBar:setVisible(false)
		
		if (self.barClip) then
			local x = self.barClip[1]
			local y = self.barClip[2]
			local w = self.barClip[3]
			local h = self.barClip[4]
			self.fillBar:setClipRect(x, y, w, h)
		
		end	
			
		-- create the front
		self.fillFront = createSprite()
		self.fillFront:setDefaultSection(player:getCurrentResourceSection())
		self.fillFront:animate(self.fillObject:getBaseName() .. "_FRONT", 0)
		self.fillFront:setX(0)
		self.fillFront:setY(0)
		self.fillFront:setAnchorPoint(self.fillObject:getAnchorX(), self.fillObject:getAnchorY())
	
		-- init object
		self.fillObject:setOverheadY(self.overheadY)
		self.fillObject:removeHighlight()
		self.fillObject:createHighlight()
		self.fillObject:addChild(self.fillBar)
		self.fillObject:addChild(self.fillFront)
		
	else
	
		warn("fillEvent - no target object found")		
	
	end

end

function fillEvent:createObject(desc)

	result = nil
	
	if (self.fillObject == nil) then
		if (desc:getType() == self.targetType) then
			if (self.targetGridX == desc:getGridX() or self.targetGridX == -1) then
				if (self.targetGridY == desc:getGridY() or self.targetGridY == -1) then
					result = fillObject()
					result.event = self		
					result:setType("fillObject")
					
					self.fillObject = result
				
				end
			end			
		end
	end
	
	return result

end

-- a fillable object
class 'fillObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
fillObject.event = nil
fillObject.progress = 0
fillObject.state = "empty"
fillObject.clicked = false

function fillObject:__init() super()
end

function fillObject:onCreate()

	self:animate(self:getBaseName(), 0)
	
end

function fillObject:onClick()

	self:playSound("SOUND_OBJECT_CLICK")
	if (self:isSelected() == false) then
		self:setSelected(true)
		emily:qWorkOn(self)
	
	end

end

function fillObject:onWorkStart(task)

	self:setSelected(false)
	self:removeOverhead()
	self.state = "empty"	
	
	if (D2Object.onWorkStart(self, task)) then
		if (self.event.emptyObject ~= nil) then
			if (self.event.emptyObject:getCurrentFrame() == 0) then
				self:playSound("SOUND_NO_STOCK")
				createFloater(getText("NOTENOUGHMILK"), event.fillObject:getScreenX(), event.fillObject:getScreenY() - 50, 0)				
				return false
			
			end		
		end
		
		task:getPerson():animate("WORK", -1)
		
		self:playSound("SOUND_STIRSOUND_LOOP", true)
		self.event.fillBar:setVisible(true)
		self.state = "filling"
		self.clicked = false
		return true
	
	end
	
	return false

end

function fillObject:onWorkUpdate(task, time)

	if (not self.clicked) then
		self.progress = self.progress + self.event.speed * (time / 1000)
		local x = self.event.barBaseX + self.progress * (self.event.barFullX - self.event.barBaseX)
		local y = self.event.barBaseY + self.progress * (self.event.barFullY - self.event.barBaseY)
		self.event.fillBar:setX(x)
		self.event.fillBar:setY(y)
	
		if (self.state == "filling") then
			if (self.progress > self.event.readyProgress) then
				self.state = "ready"
				self:setCurrentFrame(1)
				self.event.fillFront:setCurrentFrame(1)
			
			end
		elseif (self.state == "ready") then
			if (self.progress > self.event.spillProgress) then
				self:playSound(self.event.soundEventBad)
				self.state = "spill"
				return true
			
			end
		end
	end

	return self.clicked

end

function fillObject:onWorkClick(task)

	self.clicked = true
	
	if (self.state == "filling") then
		self:playSound(self.event.soundEventBad)
	
	elseif (self.state == "ready") then
		self:playSound(self.event.soundEventCompleteOne)
		
	end
	
	return true

end

function fillObject:onWorkComplete(task)

	if (self.event.emptyObject ~= nil) then
		local currentFrame = self.event.emptyObject:getCurrentFrame()
		if (self.state == "filling") then
			self.event.emptyObject:setCurrentFrame(math.max(0, currentFrame - 1))
		
		elseif (self.state == "ready") then
			self.event.emptyObject:setCurrentFrame(math.max(0, currentFrame - 1))
			
		elseif (self.state == "spill") then
			self.event.emptyObject:setCurrentFrame(math.max(0, currentFrame - 2))
		
		end
	end
	
	self:stopSound("SOUND_STIRSOUND_LOOP")
	self.clicked = false
	self.progress = 0
	
	self.event.fillObject:setCurrentFrame(0)
	self.event.fillFront:setCurrentFrame(0)	
	
	event:onComplete()
	
end