class 'findEvent' (interface)

--
-- all the objects you need to find
findEvent.objectTypes =
{
}

-- configuration variables
findEvent.baseName = ""										-- appearance of the person
findEvent.sequenceStart = nil								-- sequence played when level starts
findEvent.sequenceFirst = nil								-- sequence played when first entered
findEvent.sequenceGotOne = nil
findEvent.sequenceGotAll = nil
findEvent.scoreGotOne = 0
findEvent.scoreGotAll = 0
findEvent.timeUntilEnterMin = 0
findEvent.timeUntilEnterMax = 0
findEvent.entryX = 0
findEvent.entryY = 0
findEvent.waitX = 0
findEvent.waitY = 0

-- internal variables
-- don't change unless you know what you're doing
findEvent.started = false
findEvent.completed = false
findEvent.index = 0
findEvent.count = 0
findEvent.items = {}
findEvent.findPerson = nil
findEvent.state = "done"
findEvent.type = ""
findEvent.timer = 0

function findEvent:__init() super()
end

function findEvent:onLevelInited()

	-- start sequence
	if (self.sequenceStart ~= nil) then
		qSequence(self.sequenceStart)			
	end	
	
	-- create person
	self.findPerson = pm:createPerson("findPerson")
	self.findPerson:setPosition(grid:getNode(entryX, entryY))
	
	if (self.count > 0) then
		self.state = "waiting to enter"
		self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)
		
	end
	
	-- initialize event bar	
	eventBar:setStartAmount(0)
	eventBar:setTargetAmount(math.max(self.count, 1))
	eventBar:setProgress(0)	
	eventBar:setDescriptionText(getText("EVENTBAR"))

end

function findEvent:onDayBegin()

	self.started = true

end

function findEvent:onTick(time)

	if (self.started == false) then
		return
	end
	
	if (self.completed == true) then
		return
	end

	if (self.state == "waiting to enter") then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			self.findPerson:qWalkToNode(grid:getNode(self.waitX, self.waitY))
			self.state = "walking in"
		
		end	
	
	elseif (self.state == "walking in") then
		if (self.findPerson:getPosition():getGridX() == self.waitX) then
			if (self.findPerson:getPosition():getGridY() == self.waitY) then	
				self.state = "waiting on curtain"
				self.type = self.items[self.index+1]:getBaseName()
		
				if (self.index == 0) then		
					-- first sequence
					if (self.sequenceFirst ~= nil) then
						qSequence(self.sequenceFirst)			
						self.findPerson:qNotify("show bar")
					end					
				end
				
				self.findPerson:qAnimate("WAVE_DOWN", -1)
				self.findPerson:qWait(1000)				
				self.findPerson:qCreateOverhead(self.items[self.index+1]:getBaseName() .. "_ICON", player:getCurrentResourceSection())
				self.findPerson:qNotify("show tool")
				
			end		
		end
		
	elseif (self.state == "walking out") then
		if (self.findPerson:getPosition():getGridX() == self.entryX) then
			if (self.findPerson:getPosition():getGridY() == self.entryY) then	
				if (self.index < self.count) then
					self.state = "waiting to enter"
					self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)
					
				else
					self.state = "done"				
				
				end
			end
		end
	
	elseif (self.state == "waiting on object") then
		-- do nothing
	
	elseif (self.state == "waiting on curtain") then
		-- do nothing
	
	elseif (self.state == "done") then
		-- do nothing
	
	end

end

function findEvent:onNotify(notification)

	if (notification == "show bar") then
		eventBar:animateToActive()	
		
	end
	
	if (notification == "show tool") then
		eventBar:setSubjectImage(self.items[self.index+1]:getBaseName() .. "_BAR", self.items[self.index+1]:getDefaultSection())
		eventBar:raiseCurtain()
		self.state = "waiting on object"
			
	end

end

function findEvent:createPerson(class)

	result = nil
	
	if (class == "findPerson") then
		result = npc(self.baseName)
		result.event = self		
		result:setType(class)
	
	end
	
	return result

end

function findEvent:createObject(desc)

  	result = nil
  
	for index, value in ipairs(self.objectTypes) do
		if (value == desc:getType()) then
			result = findObject()
			result.event = self
			result:setType(desc:getType())
			break;
		
		end
	end 
  
	if (result ~= nil) then
		self.items[ self.count+1 ] = result;
		self.count = self.count + 1  
  
	end
	
  	return result
	
end

-- a find object
class 'findObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
findObject.event = nil

function findObject:__init() super()
end

function findObject:onCreate()

	self:animate(self:getBaseName(), 0)
	self:createHighlight()

end

function findObject:onClick()

	if (self.event.state ~= "waiting on object") then
		return
	end

	if (self:isVisible()) then
		if (self:getBaseName() == self.event.type) then
			-- clicked the item you were looking for
	
			-- hide the item
			self:setVisible(false)
			
			-- increase the score
			incScore(self.event.scoreGotOne, self:getScreenX(), self:getScreenY())
			self:playSound(self.event.soundEventCompleteOne)
			
			-- eventbar
			eventBar:setProgress(self.event.index+1)
		
			-- check
			if (self.event.index == self.event.count - 1) then
			
				-- found all items
		    	-- set event to completed
		    	self.event.completed = true	
		    	
				-- increase the score
				incScore(self.event.scoreGotAll, self:getScreenX(), self:getScreenY(), scoreBonusFloaterDelay, "BONUS")
				self:playSound(self.event.soundEventCompleteAll)
			
				-- start sequence got all
				if (self.event.sequenceGotAll ~= nil) then
					qSequence(self.event.sequenceGotAll)			
				end		
				
				-- deactive bar
				eventBar:animateToDeactive()		
			
			else
			
				-- start sequence got one
				if (self.event.sequenceGotOne ~= nil) then
					qSequence(self.event.sequenceGotOne)			
				end		
				
				-- lower curtain
				eventBar:lowerCurtain()										
			
			end
			
			-- move person out		
			self.event.findPerson:qClearOverhead()
			self.event.findPerson:qWalkToNode(grid:getNode(self.event.entryX, self.event.entryY))
			self.event.state = "walking out"
			self.event.type = ""
			self.event.index = self.event.index + 1
		
		end
	end

end