class 'heimlichEvent' (interface)

-- configuration variables
heimlichEvent.sequenceStart = nil								-- sequence played when level starts
heimlichEvent.sequenceFailed = nil								-- sequence played at end of day when failed
heimlichEvent.sequenceSaved = nil
heimlichEvent.baseName = ""										-- appearance of the person
heimlichEvent.entryX = 0										-- position person enters from
heimlichEvent.entryY = 0
heimlichEvent.speedMin = 0
heimlichEvent.speedMax = 0
heimlichEvent.neededToSave = 0
heimlichEvent.saveClickMin = 0
heimlichEvent.saveClickMax = 1
heimlichEvent.score = 0

-- internal variables
-- don't change unless you know what you're doing
heimlichEvent.started = false
heimlichEvent.completed = false
heimlichEvent.choker = nil
heimlichEvent.bar = nil
heimlichEvent.choking = false
heimlichEvent.progress = 0
heimlichEvent.right = true
heimlichEvent.leftToSave = 0
heimlichEvent.speed = 0

function heimlichEvent:__init() super()
end

function heimlichEvent:onLevelInited()

	-- create the bar
	self.bar = createHeimlichBar()
	self.bar:setX(10)
	self.bar:setProgress(0)
	self.bar:setVisible(false)

  	-- create the person
	self.choker = pm:createPerson("heimlichPerson")
	self.choker:setBaseName(self.baseName)
	self.choker:setPosition(grid:getNode(self.entryX, self.entryY))
	self.choker:createHighlight()
	self.choker:addChild(self.bar)
	
	-- start sequence
	if (self.sequenceStart ~= nil) then
		qSequence(self.sequenceStart)			
	end	

end

function heimlichEvent:onDayBegin()

	self.started = true
	self.choking = true
	self.leftToSave = self.neededToSave	
	self.speed = self.speedMin
	
end

function heimlichEvent:onDayEnd()

	if (self.completed == false) then
		if (self.sequenceFailed ~= nil) then
			qSequence(self.sequenceFailed)			

			autoAllPeopleWalkOut = false	
			
		end	
	end
	
	if (self.bar ~= nil) then
		self.bar:setVisible(false)
		self.bar = nil
		
	end

end

function heimlichEvent:createPerson(class)

	if (class == "heimlichPerson") then
		hp = heimlichPerson(self.baseName)
		hp.event = self
		hp:setType(class)
		return hp
		
	end
		
	return nil
		
end

function heimlichEvent:onTick(time)

	if (self.bar ~= nil) then
		if (self.bar:isVisible() and self.bar:getCursor():isVisible()) then
	
			if (self.right == true) then
				self.progress = self.progress + self.speed * (time / 1000)
			else
				self.progress = self.progress - self.speed * (time / 1000)
			end
		
			if (self.progress >= 1) then
				self.progress = 1
				self.right = false
				
			end
			
			if (self.progress <= 0) then
				self.progress = 0
				self.right = true
				
			end	
		
			self.bar:setProgress(self.progress)	
		
		end
	end

end

function heimlichEvent:onSuccess()

	self.completed = true
	self.choking = false
	self.bar:getCounter():setCurrentFrame(self.leftToSave)
	self.bar:setVisible(false)
	self.bar = nil
	self.choker:animate("IDLE", 0)
	self.choker:playSound(self.soundEventCompleteAll)
	self.choker:removeHighlight()
	emily:animate("IDLE", 0)
	emily:setVisible(true)
		
	incScore(self.score, self.choker:getScreenX(), self.choker:getScreenY() + scorePersonFloaterOffsetY, 0)
	
	if (self.sequenceSaved ~= nil) then
		qSequence(self.sequenceSaved)			
	end		

end

function heimlichEvent:onTaskStart(actorType, taskType, p0, p1)

	if (actorType == "emily") then
		if (taskType == "WalkToTask") then
			emily:setVisible(true)
			
			if (self.bar ~= nil) then
				if (self.bar:isVisible()) then
					self.bar:setVisible(false)
					self.choker:animate("CHOKE_LOOP", -1, 5)
				end		
			end
		end
	end

end

-- a heimlich person
class 'heimlichPerson' (npc)

-- internal variables
-- don't change unless you know what you're doing
heimlichPerson.event = nil	
heimlichPerson.timer = 0

function heimlichPerson:__init(baseName) super(baseName)
end

function heimlichPerson:onClick()

	if (self.event.choking == true) then
		if (self:isSelected() == false) then
			self:setSelected(true)
			self:clearOverhead()
			emily:qWorkOn(self)
		
		end
	end
	
end

function heimlichPerson:onTick(time)

	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			if (self.event.leftToSave == 0) then
				self.event:onSuccess()
				
			else
				self.event.bar:getCursor():setVisible(true)
				self.event.bar:setBackImage(self.event.bar.back, self.event.bar.section)			
			
			end		
		end	
	end

end

function heimlichPerson:onWorkStart(task)

	self:setSelected(false)
	
	if (self.event.choking == true) then
		-- yes/no image is currently showing
		-- ignore clicks until it goes away
		if (self.timer > 0) then
			return false
			
		end
	
		if (self.event.bar:isVisible()) then
			
			local hit = false
			if (self.event.progress >= self.event.saveClickMin) then
				if (self.event.progress <= self.event.saveClickMax) then
					hit = true
				end
			end
			
			if (hit == true) then
				self.event.leftToSave = self.event.leftToSave - 1
				self.event.bar:setBackImage(self.event.bar.yes, self.event.bar.section)
				self.event.speed = self.event.speedMin + ((self.event.neededToSave - self.event.leftToSave) / self.event.neededToSave) * (self.event.speedMax - self.event.speedMin)
				
				self:playSound("SOUND_HEIMLICH")
				self:animate("HEIMLICH", 1, 15)				
				
			else
				self.event.leftToSave = self.event.leftToSave + 1
				if (self.event.leftToSave > self.event.neededToSave) then
					self.event.leftToSave = self.event.neededToSave
				end
				self.event.bar:setBackImage(self.event.bar.no, self.event.bar.section)
				
			end
			
			self.event.bar:getCounter():setCurrentFrame(self.event.leftToSave)			
			self.event.bar:getCursor():setVisible(false)
			self.event.progress = 0
			self.timer = 400				
			
		else
			self.event.timer = 0
			self.event.right = true
			self.event.bar:setVisible(true)
			self.event.bar:getCounter():setCurrentFrame(self.event.leftToSave)		
			self.event.progress = 0
			
			self:animate("HEIMLICH", 0)
			emily:setVisible(false)
			
			hm:openHint(HINT_EVENT_HEIMLICH, self.event.choker:getX(), self.event.choker:getY())
		
		end

		return true		
	end

	return false
	
end

function heimlichPerson:onWorkUpdate(task, time)

	return true
	
end

function heimlichPerson:getWorkNode()

	gridX = self:getPosition():getGridX()
	gridY = self:getPosition():getGridY()
	gridY = gridY - 1

	return grid:getNode(gridX, gridY)	

end