class 'hiddenObjectEvent' (interface)

--
-- hidden object types
-- all these types are defined as hidden objects!
-- when you come up with a new hidden object event, the preset type needs
-- to be added here!
hiddenObjectEvent.registeredTypes = nil
hiddenObjectEvent.eventBarImage = nil

-- configuration variables
hiddenObjectEvent.baseName = ""					-- appearance of the person
hiddenObjectEvent.baseSection = "characters"	-- section
hiddenObjectEvent.entryX = 0					-- position person enters from
hiddenObjectEvent.entryY = 0
hiddenObjectEvent.highlightX = 0
hiddenObjectEvent.highlightY = 0
hiddenObjectEvent.sequenceStart	= nil			-- text when event starts
hiddenObjectEvent.sequenceThanks = nil			-- text when you find 1 item
hiddenObjectEvent.sequenceDone = nil			-- text when you find all items
hiddenObjectEvent.sequenceFail = nil			-- sequence for when the task time ends and you don't have all of the items
hiddenObjectEvent.timeUntilEnterMin = 0			-- minimum time the person waits outside
hiddenObjectEvent.timeUntilEnterMax = 0			-- maximum time the person waits outside
hiddenObjectEvent.scoreFoundOne	= 0				-- score for finding one item
hiddenObjectEvent.scoreFoundAll	= 0				-- bonus for finding all items

-- internal variables
-- don't change unless you know what you're doing
hiddenObjectEvent.items = {}
hiddenObjectEvent.countItems = 0
hiddenObjectEvent.countFound = 0
hiddenObjectEvent.person = nil
hiddenObjectEvent.timer = 0
hiddenObjectEvent.started = false
hiddenObjectEvent.completed = false

function hiddenObjectEvent:__init() super()
end

function hiddenObjectEvent:onLevelInited()

	if (self.countItems > 0) then

		-- set enter timer
		self.timer = getRandomRange(self.timeUntilEnterMin, self.timeUntilEnterMax)
	
	    -- hide all hidden items
		for index, value in ipairs(self.items) do
			value:setVisible(false)
		end
	  
	  	-- create the person that lost all his/her belongings
	  	if (self.baseName ~= "") then
			self.person = pm:createPerson("npc")
			self.person:setBaseName(self.baseName)
			self.person:setDefaultSection(self.baseSection)
			self.person:setPosition(grid:getNode(self.entryX, self.entryY))
		end
		
		-- initialize event bar
		eventBar:setStartAmount(0)
		eventBar:setTargetAmount(math.max(1, self.countItems))
		eventBar:setProgress(0)
		eventBar:setDescriptionText(getText("EVENTBAR"))
		if (self.eventBarImage == nil) then
			eventBar:setSubjectImage(self.items[1]:getBaseName() .. "_BAR", self.items[1]:getDefaultSection())
		else
			eventBar:setSubjectImage(self.eventBarImage, self.items[1]:getDefaultSection())
		end
		
	else
	
		warn("hiddenObjectEvent - no hidden object(s) found")
	
	end

end

function hiddenObjectEvent:createObject(desc)
  
  	result = nil
  
	for index, value in ipairs(self.registeredTypes) do
		if (value == desc:getType()) then
			result = hiddenObject()
			result.event = self
			result:setType(desc:getType())
			break;
		
		end
	end  	
  
	if (result ~= nil) then
  
		self.items[ self.countItems+1 ] = result;
		self.countItems = self.countItems + 1  
  
	end
  
  	return result

end

function hiddenObjectEvent:onDayBegin()

	self.started = true

end

function hiddenObjectEvent:onDayEnd()

	if (not self.completed) then
	
		if (self.sequenceFail ~= nil) then
			qSequence(self.sequenceFail)		
		end
		
	end
	
end

function hiddenObjectEvent:onTick(time)

	if (self.started == false) then
		return
	end

	-- wait until we can enter
	if (self.timer > 0) then

	    self.timer = self.timer - time
	    if (self.timer <= 0) then

			-- start sequence
			if (self.sequenceStart ~= nil) then
				qSequence(self.sequenceStart)
			end			
	    	
	    end	
	end

end

function hiddenObjectEvent:onNotify(notification)
	
	if (notification == "ho_arrived") then
	
	    -- show all hidden items
		for index, value in ipairs(self.items) do
			value:setVisible(true)
			
			if (value:getPosition():getGridX() == self.highlightX) then
				if (value:getPosition():getGridY() == self.highlightY) then
					value:createOverhead("INGAME_ARROW")
					
				end
			end
		end
	
	elseif (notification == "show bar") then

		-- show pearl on bar
		eventBar:animateToActive()
		eventBar:raiseCurtain()
	
	end

end

-- a hidden object
class 'hiddenObject' (D2Object)

-- internal variables
-- don't change unless you know what you're doing
hiddenObject.event = nil

function hiddenObject:__init() super()
end

function hiddenObject:onCreate()

	self:setDefaultSection(player:getCurrentResourceSection())
	self:animate(self:getBaseName(), 0)
	self:createHighlight()

end

function hiddenObject:onClick()
  
	-- First check if we should even be able to click on this object:
	if (self:isVisible() == true) then
		-- hide the item
		self:setVisible(false)
		self:setClickable(false)
		self:clearOverhead()
		self:playSound(self.event.soundEventCompleteOne)
	
		-- increase the found count
		self.event.countFound = self.event.countFound + 1
		
		-- increase score and pop a floater
		incScore(self.event.scoreFoundOne, self:getScreenX(), self:getScreenY(), 0)
		
		-- update the event bar
		eventBar:setProgress(self.event.countFound)
		
		-- say thanks
		if (self.event.countFound == self.event.countItems) then
		
			self:playSound(self.event.soundEventCompleteAll)
		
			-- found all items
	    	-- set event to completed
	    	self.event.completed = true
	
			-- lower curtain
			eventBar:animateToDeactive()
	
			-- increase score and pop a floater
			incScore(self.event.scoreFoundAll, self:getScreenX(), self:getScreenY(), scoreBonusFloaterDelay, "BONUS")
	
			-- done sequence
			if (self.event.sequenceDone ~= nil) then
				qSequence(self.event.sequenceDone)			
			end					
	
		else
			-- thanks sequence
			if (self.event.person ~= nil) then
				if (self.event.person:isIdle()) then
					if (self.event.sequenceThanks ~= nil) then
						qSequence(self.event.sequenceThanks)
						
					end
				end
			elseif (self.event.sequenceThanks ~= nil) then
				qSequence(self.event.sequenceThanks)
					
			end	
		end
	end
	
end