class 'charles' (d2cleaner)

charles.looking = false

function charles:__init(baseName) super(baseName)
end

function charles:onCreate()

	d2cleaner.onCreate(self)
	self:createHighlight()

end

function charles:onClick()

	d2cleaner.onClick(self)

	self:qWorkOn(getAppliance("rest2_candy_jars"))
	self:clearOverhead()	

end

function charles:onSit()

	self:getHighlight():setActive(true)

end

function charles:onStand()

	self.looking = false
	self:getHighlight():setHighlighted(false)
	self:getHighlight():setActive(false)

end

function charles:setLooking(lookFlag)
	
	if (self:isSitting()) then
		self.looking = lookFlag
		if (lookFlag) then
			self:animate("SIT_LOOK", 0)
		else
			self:animate("WORK", -1)
		end
		
		self:getTable():updateLegs(self, 0)
	end
end

function charles:onTick()

	if (self:isIdle()) then
		if (self:isSitting() == false) then
			gridX = self:getPosition():getGridX()
			gridY = self:getPosition():getGridY()
			homeX = self:getHomeNode():getGridX()
			homeY = self:getHomeNode():getGridY()
			
			if ((gridX == homeX) and (gridY == homeY)) then
				workerTable:sitDown(self, 0)
				self:animate("WORK", -1)
			
			end
		end
	end

end

function charles:calcImageName(input)

  	in_ = input;

  	if (self:isSitting()) then
   		if (input == "IDLE") then
      		in_ =  "SIT"
   		end
  	end

  	res = D2Person.calcImageName(self, in_)
  
  	return res
  
end

function charles:calcLegsName()
	local res = nil
	if (self:isSitting() and self.looking) then
		res = self:getBaseName() .. "_LEGS_LOOK_RIGHT"
	else
		res = D2Person.calcLegsName(self)
	end
	return res
end