class 'chickenPerson' (D2Person)

chickenPerson.points = 
{
	{19, 9},
	{36, 22},
	{13, 28},
	{13, 19},
	{20, 16},
	{27, 10},
	{33, 11},
	{36, 16},
	{38, 13},
	{31, 23},
}
chickenPerson.areas =
{
	{ 22, 10, 44, 14 },
	{ 21, 12, 24, 20 },
	{ 15, 8,  22, 12 },
	{ 28, 21, 40, 25 },
	{ 40, 21, 47, 23 },
	{ 10, 24, 14, 30 },
	{ 10, 18, 24, 20 },
	{ 34, 14, 38, 24 },
	{ 30, 3,  36, 13 },
}
chickenPerson.pointsIntervalMin = 5000
chickenPerson.pointsIntervalMax = 10000
chickenPerson.areaWidthOffset = 3
chickenPerson.areaHeightOffset = 3
chickenPerson.areaIntervalMin = 1000
chickenPerson.areaIntervalMax = 4000
chickenPerson.createIntervalMin = 8000
chickenPerson.createIntervalMax = 12000
chickenPerson.cluckingIntervalMin = 4000
chickenPerson.cluckingIntervalMax = 12000
chickenPerson.createProduct = "EGG"

chickenPerson.goldTimes = nil
chickenPerson.goldDropped = false
chickenPerson.goldCount = 0
chickenPerson.goldIndex = 1
chickenPerson.goldTimer = 0
chickenPerson.goldPicked = 0

chickenPerson.easterTimes = nil
chickenPerson.easterTimer = 0
chickenPerson.easterDropped = false

chickenPerson.pointsTimer = 0
chickenPerson.pointsTargetX = nil
chickenPerson.pointsTargetY = nil
chickenPerson.areaTimer = 0
chickenPerson.areaTargetX = nil
chickenPerson.areaTargetY = nil
chickenPerson.notification = ""
chickenPerson.notificationTimer = 0
chickenPerson.createTimer = 0
chickenPerson.cluckingTimer = 0
chickenPerson.layTimer = 0
chickenPerson.layAllowed = false
chickenPerson.direction = nil
chickenPerson.eggsCount = 0
chickenPerson.eggsCountMax = 3
chickenPerson.eggsIndex = 0
chickenPerson.eggs =
{
}

function chickenPerson:__init(baseName) super(baseName)

	self:setDefaultAnimation("IDLE")
	self:setWalkTimePerNode(200)
	self:setShadowY(-5)

end

function chickenPerson:onCreate()

	D2Person.onCreate(self)
	self.pointsTimer = getRandomRange(self.pointsIntervalMin, self.pointsIntervalMax)
	self.areaTimer = 500
	self.createTimer = getRandomRange(self.createIntervalMin, self.createIntervalMax)
	self.cluckingTimer = getRandomRange(self.cluckingIntervalMin, self.cluckingIntervalMax)

end

function chickenPerson:onTick(time)

	gridX = self:getPosition():getGridX()
	gridY = self:getPosition():getGridY()
	gridPos = grid:getNode(gridX, gridY)

	-- skips when walking to a new point (areaTimer == 0)
	-- skips when walking inside area (areaTimer == 0)
	if (self.areaTimer > 0) then
		self.areaTimer = self.areaTimer - time
		if (self.areaTimer <= 0) then
			gridMinX = math.max(0, gridX - self.areaWidthOffset)
			gridMaxX = math.min(GRID_SIZE_X-1, gridX + self.areaWidthOffset)
			gridMinY = math.max(0, gridY - self.areaHeightOffset)
			gridMaxY = math.min(GRID_SIZE_Y-1, gridY + self.areaHeightOffset)

			local n = 0
			while (n < 16) do
				targetX = getRandomRange(gridMinX, gridMaxX)
				targetY = getRandomRange(gridMinY, gridMaxY)
				
				if (targetX ~= gridX and targetY ~= gridY) then
					local targetPos = grid:getNode(targetX, targetY)
					if (not targetPos:isBlocked()) then
						if (grid:existsPath(gridPos, targetPos)) then
							break
						
						end
					end
				end
				n = n + 1
			end
			
			if (n < 16) then
				self:qWalkToXY(targetX, targetY)
				self.areaTargetX = targetX
				self.areaTargetY = targetY
				self.areaTimer = 0			
				
			end		
		end	
	end
	
	-- skips when walking to a new point (pointsTimer == 0)	
	if (self.pointsTimer > 0) then
		self.pointsTimer = self.pointsTimer - time
		if (self.pointsTimer <= 0) then
			-- walk to another point in the list
			index = 1 + getRandom(table.getn(self.points))
			targetX = self.points[index][1]
			targetY = self.points[index][2]
			
			if (targetX ~= nil and targetY ~= nil) then
				self:qWalkToXY(targetX, targetY)
				self.pointsTargetX = targetX
				self.pointsTargetY = targetY
				self.pointsTimer = 0						
				self.areaTargetX = nil
				self.areaTargetY = nil
				self.areaTimer = 0
			
			end					
		end		
	end
	
	if (not scene:isStartingMovie() and not scene:isPlayingMovie()) then
		if (self.createTimer > 0) then
			self.createTimer = self.createTimer - time
			if (self.createTimer <= 0) then
				self.layAllowed = true
					
				if (self.eggsCount >= self.eggsCountMax) then
					self:unlayEgg()
				
				end
			end		
		end
		
		if (self.cluckingTimer > 0) then
			self.cluckingTimer = self.cluckingTimer - time
			if (self.cluckingTimer <= 0) then
				-- see arrived below
						
			end		
		end		
	end
	
	if (self.layTimer > 0) then
		self.layTimer = self.layTimer - time
		if (self.layTimer <= 0) then
			self.layTimer = 0
			self:layEgg()
		
		end	
	end
	
	if (self.notificationTimer > 0) then
		self.notificationTimer = self.notificationTimer - time
		if (self.notificationTimer <= 0) then
			day:onNotify(self.notification)
			self.notification = ""
			self.notificationTimer = 0
			
		end
	end
	
	self.goldTimer = self.goldTimer + time
	self.easterTimer = self.easterTimer + time

	local arrived = false

	-- check if you reached area destination
	-- skips when walking to a new point (areaTargetX == nil) (areaTargetY == nil)
	if (gridX == self.areaTargetX and gridY == self.areaTargetY) then
		self.areaTargetX = nil
		self.areaTargetY = nil
		self.areaTimer = getRandomRange(self.areaIntervalMin, self.areaIntervalMax)

		arrived = true
	end
	
	-- check if you reached points destination
	if (gridX == self.pointsTargetX and gridY == self.pointsTargetY) then
		self.pointsTargetX = nil
		self.pointsTargetY = nil
		self.pointsTimer = getRandomRange(self.pointsIntervalMin, self.pointsIntervalMax)
		self.areaTargetX = nil
		self.areaTargetY = nil
		self.areaTimer = getRandomRange(self.areaIntervalMin, self.areaIntervalMax)

		arrived = true
	end
	
	-- on arrival we do stuff
	if (arrived == true) then
		local animationBase = nil
		local animationCount = nil
		local animation = nil
		
		local insideArea = true
		if (self.layAllowed) then
			if (self.areas ~= nil) then
				insideArea = false
			    -- check if currently inside area
				for index, value in ipairs(self.areas) do
					if (self:contains(value, gridX, gridY)) then
						insideArea = true
						break
					end
				end
			end		
		end
		
		-- play clucking sound
		-- timer is above
		if (self.cluckingTimer <= 0) then
			self:playSound("SOUND_CHICKEN_CLUCKING" .. getRandom(3))
			self.cluckingTimer = getRandomRange(self.cluckingIntervalMin, self.cluckingIntervalMax)
			
		end
		
		if (self.layAllowed and insideArea) then
			animationBase = "SIT"
			animationCount = -1
			
			self.layTimer = 800		-- time until chicken lays egg
			self.layAllowed = false			
			self.areaTimer = 0
			self.areaTargetX = nil
			self.areaTargetY = nil
			self.pointsTimer = 0
			self.pointsTargetX = nil
			self.pointsTargetY = nil
			self.createTimer = 0
			
		else
			animationBase = "PICK"
			animationCount = 2
			
		end
		
		if (self.direction == DIRECTION_LEFT) then
			animation = animationBase .. "_LEFT"
		
		elseif (self.direction == DIRECTION_RIGHT) then
			animation = animationBase .. "_RIGHT"
		
		elseif (getRandom(2) == 1) then	
			animation = animationBase .. "_LEFT"
			
		else
			animation = animationBase .. "_RIGHT"
		
		end

		self:animate(animation, animationCount, false, 10)	
	
	end
	
	-- store current direction
	self.direction = self:getDirection()
	
end

function chickenPerson:layEgg()

	-- create a product on current location			
	local egg = prm:createProduct(self.createProduct)
	local eggx = self:getPosition():getScreenCenterX()
	local eggy = self:getPosition():getScreenCenterYZ()
	
	level:getLayer(LAYER_GRID_ELEMENTS):addChild(egg)
	egg:setWorkOffsetY(1)
	egg:setAnchorBotY(10)
	egg:reposition(eggx, eggy - 1)
	egg.gridX = self:getPosition():getGridX()
	egg.gridY = self:getPosition():getGridY()
	
	if (self:getPosition():isBlocked()) then
	    warn("chickenPerson:layEgg - on blocked position")
	    
	end
	
	self:playSound("SOUND_CHICKEN_LAYEGG")
	self:addEgg(egg)
	self.areaTimer = 800
	self.pointsTimer = 1600 	
	self.createTimer = getRandomRange(self.createIntervalMin, self.createIntervalMax)	
	
	-- turn it into gold a certain percentage of the time
	local gold = false
	if (self.goldTimes) then
		if (self.goldTimes[self.goldIndex]) then
			if (self.goldTimer >= self.goldTimes[self.goldIndex]) then
				gold = true
	
			end
		end
	end
	
	if (gold) then
		egg:setState("GOLD")
		if (self.goldDropped == false) then
			eventBar:setSubjectImage("EVENT_GOLDENEGG_BAR", player:getCurrentResourceSection())
			eventBar:setDescriptionText(getText("EVENTBAR"))
			eventBar:setStartAmount(0)
			eventBar:setTargetAmount(table.getn(self.goldTimes))
			eventBar:setProgress(0)	
			eventBar:animateToActive()
		
		end
		self:playSound("SOUND_EVENT_ATTENTION")
		self.goldDropped = true
		self.goldCount = self.goldCount + 1
		self.goldIndex = self.goldIndex + 1
		if (self.goldCount == 1) then
			eventBar:raiseCurtain()
		
		end
		
	end	
	
	-- Start Trophy code
	-- turn it into easter egg a certain percentage of the time
	local easter = false
	if (self.easterTimes) then
		if (self.easterTimes[1]) then
			if (self.easterTimer >= self.easterTimes[1]) then
				easter = true
			end
		end
	end
	
	-- Does the chicken want to lay an easter egg AND if we don't have the egg-trophy yet:
	-- AND the chicken didn't lay an easter egg yet this day
	if (easter) and (tm:isEasterEggCollected() == false) and (self.easterDropped == false) then
		egg:setState("EASTER")
		self.easterDropped = true
	end
	-- End Trophy code
	
	self.notificationTimer = 2000
	self.notification = "chicken lays " .. egg:getName()

	hm:placeArrow(ARROW_HINT_EGG, egg)
	
end

function chickenPerson:unlayEgg()
	
	local eggidx = 65536	-- what's the maxint value in lua ?
	local eggdel = nil
	local egggold = false

	for index, egg in pairs(self.eggs) do
		if (egg.queued == false) then
		    if (egg:getState() == "GOLD") then
		    	if ((egggold == false) or (egg.index < eggidx)) then
		        	eggidx = egg.index
		        	eggdel = egg
		        	egggold = true
		        	
		        end
		    
		    elseif (egggold == false) then
		    	if (egg.index < eggidx) then
					eggidx = egg.index
					eggdel = egg
				
				end				
			end
		end		
	end
	
	if (eggdel) then
		self:delEgg(eggdel, true)
		tm:setMissedAnEgg(true)			-- Trophy code (Break-an-Egg)
		
	end

end

function chickenPerson:addEgg(egg)

	self.eggsCount = self.eggsCount + 1
	self.eggsIndex = self.eggsIndex + 1
	self:setTag(self.eggsCount)

	egg.chicken = self
	egg.index = self.eggsIndex
	
	self.eggs["" .. egg.index] = egg
	
end

function chickenPerson:delEgg(egg, blinkFirst)

	local state = self.eggs["" .. egg.index]:getState()
	if (state == "GOLD") then
		self.goldCount = self.goldCount - 1
		if (self.goldCount == 0) then
			eventBar:lowerCurtain()
		
		end	
	end

	if (blinkFirst) then
		self.eggs["" .. egg.index]:clearOverhead()
		self.eggs["" .. egg.index]:setClickable(false)
		self.eggs["" .. egg.index]:qBlink()
		self.eggs["" .. egg.index]:qWait(750)
		self.eggs["" .. egg.index]:qDestroy()
		self.eggs["" .. egg.index] = nil	
		
	else
		self.eggs["" .. egg.index]:clearOverhead()
		self.eggs["" .. egg.index]:setClickable(false)
		self.eggs["" .. egg.index]:setDestroyed(true)
		self.eggs["" .. egg.index] = nil
	
	end
	
	
	self.eggsCount = self.eggsCount - 1
	self:setTag(self.eggsCount)

end

function chickenPerson:pickEgg(egg)

	self:delEgg(egg, false)

	if (egg:getState() == "GOLD") then
		self.goldPicked = self.goldPicked + 1
		eventBar:setProgress(self.goldPicked)

		if (self.goldPicked == table.getn(self.goldTimes)) then
			eventBar:animateToDeactive()
		end	
	end

end

function chickenPerson:contains(rectangle, x, y)

	local left = rectangle[1]
	local top = rectangle[2]
	local right = rectangle[3]
	local bottom = rectangle[4]
	local width = right - left
	local height = bottom - top
	
	local x_ = x - left
	local y_ = y - top
	
	if (x_ < 0) then
		return false
	end
	
	if (y_ < 0) then
		return false
	end
	
	if (x_ >= width) then
		return false
	end
	
	if (y_ >= height) then
		return false
	end
	
	return true

end