class 'balloonButton' (Product)

balloonButton.timer1 = 0
balloonButton.timer2 = 0
balloonButton.balloonColor = nil

function balloonButton:__init(root) super(root)
end

function balloonButton:onCreate()

	self:setState("IDLE")

end

function balloonButton:setBalloonColor(color)
	self.balloonColor = color
end

function balloonButton:getBalloonColor()
	return self.balloonColor
end

function balloonButton:getBalloonProduct()

	return getProduct("BALLOON_" .. self:getBalloonColor())

end

function balloonButton:getBalloonTime()

	time = self:getWorkTime()


	return time

end

function balloonButton:onStateEnter(state)

	local balloon = self:getBalloonProduct()
	if (balloon ~= nil) then
	
		if (state == "IDLE") then
			self:getBalloonProduct():setVisible(false)
		
		elseif (state == "FILLING") then
			self:getBalloonProduct():setVisible(true)
			self:getBalloonProduct():animate("PROD_BUT_" .. self:getBalloonProduct():getBase() .. "_FILLING", 0)
			self:getTimer():setVisible(true)
			self:getTimer():setProgress(0)
			self:playSound("SOUND_BALLOON_BLOW", true)		
			self.timer1 = self:getBalloonTime()
			self.timer2 = self:getBalloonTime() / 3	
			
		elseif (state == "READY") then
			self:getBalloonProduct():animate("PROD_BUT_" .. self:getBalloonProduct():getBase(), 0)
			self:playSound("SOUND_BRUILLE_STATE_1")
			self.timer2 = self:getBalloonTime() / 3		
		
		elseif (state == "POPPED") then
			self:getBalloonProduct():animate("PROD_BUT_" .. self:getBalloonProduct():getBase() .. "_POPPED", 0)
			self:playSound("SOUND_BALLOON_POPS")
			self.timer2 = self:getBalloonTime() / 3		
		
		elseif (state == "TIMEDOUT") then
			self:getBalloonProduct():unQueue()
			self:setState("FINISH")
		
		elseif (state == "FINISH") then
			self:getTimer():setVisible(false)
			self:getTimer():setProgress(0)
			self:stopSound("SOUND_BALLOON_BLOW")	
			self.timer1 = 0
			self.timer2 = 0
			
		end
	end

end

function balloonButton:onClick()

	local balloonProd = self:getBalloonProduct()
	if (balloonProd ~= nil and self:getState() == "IDLE") then
		if (balloonProd:isQueuableToTray()) then
			balloonProd:queue()
			Product.onClick(self)
	
		end	
	end
	
end

function balloonButton:onWorkStart(task)

	local balloonProd = self:getBalloonProduct()
	if (balloonProd ~= nil and self:getState() == "IDLE") then
		if (balloonProd:isQueuedOnTray()) then
			Product.onWorkStart(self, task)
			task:setDuration(-1)
			self:setState("FILLING")			
			return true
	
		else
			tray:clearInvisible()
	
		end
	end
	
	return false

end

function balloonButton:onWorkUpdate(task, time)

	if (not scene:isPlayingMovie()) then
		if (self:getState() == "FILLING") then
			self.timer1 = self.timer1 - time
			self.timer2 = self.timer2 - time
			if (self.timer2 <= 0) then
				self:setState("READY")
			
			end
		
		elseif (self:getState() == "READY") then
			self.timer1 = self.timer1 - time
			self.timer2 = self.timer2 - time
			if (self.timer2 <= 0) then
				self:setState("POPPED")
			
			end
			
			if (self.timer2 <= self:getBalloonTime() / 6) then
				if (self.timer2 + time > self:getBalloonTime() / 6) then
					--
					-- open the balloon hint here
					hm:openHint(HINT_BALLOON_READY, 142, 361)
				
				end			
			end
			
		elseif (self:getState() == "POPPED") then
			self.timer1 = self.timer1 - time
			self.timer2 = self.timer2 - time
			if (self.timer2 <= 0) then
				self:setState("TIMEDOUT")
			
			end	
		
		elseif (self:getState() == "FINISH") then
			self:setState("IDLE")
			return true
				
		end
		
		progress = 1 - (self.timer1 / self:getBalloonTime())	
		self:getTimer():setProgress(progress)
	end
	
	return false

end

function balloonButton:onWorkClick()

	local balloonProd = self:getBalloonProduct()
	
	if (balloonProd ~= nil) then
		if (self:getState() == "FILLING") then
			self:getBalloonProduct():unQueue()
			self:setState("FINISH")
			return true
		
		elseif (self:getState() == "READY") then
			self:getBalloonProduct():moveToTray()
			self:setState("FINISH")
			return true
		
		elseif (self:getState() == "POPPED") then
			self:getBalloonProduct():unQueue()
			self:setState("FINISH")
			return true
		
		end
	end	
	return true

end
