class 'cakemoldPieProduct' (Product)

cakemoldPieProduct.timer1 = 0
cakemoldPieProduct.timerSuspended = false

function cakemoldPieProduct:__init(root) super(root)

	if (type(root) == "userdata") then
		self.timer1 = root.timer1
		self.timerSuspended = root.timerSuspended
	
	end	

end

function cakemoldPieProduct:onReceiveComplete()

	-- pie in mold arrived at the oven: start baking:
	self:setState("BAKING")
	
	Product.onReceiveComplete(self)

end

function cakemoldPieProduct:onTick(time)

	if (self.timerSuspended == false) then
	
		if (self:getState() == "BURNING") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("BURNED")
			end	
		
		elseif (self:getState() == "READY") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("BURNING")
			end	
				
		elseif (self:getState() == "BAKING") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("READY")
				self:blink(1, 0, 3)
			end

		end
		
	end
	
	Product.onTick(self, time)

end

function cakemoldPieProduct:onStateEnter(state)

	if (state == "BAKING") then
		self:animate("PROD_BUT_" .. self:getBase() .. "_RAW", 0)
		self:setClickable(false)
		self.timer1 = 5000
		self:playSound("SOUND_FIREPLACE_LOOP", true)
		
	elseif (state == "READY") then
		self:animate("PROD_BUT_" .. self:getBase() .. "_READY", 0)
		self:setClickable(true)
		self.timer1 = 5000
--		self:playSound("SOUND_BRUILLE_STATE_1")
	
	elseif (state == "BURNING") then
		self:setClickable(false)
		self:clearOverhead()
		self.timer1 = 2000
--		self:playSound("SOUND_BRUILLE_STATE_1")
		-- Play burn animation
		self:animate("ANIM_" .. self:getBase() .. "_BURN", 1, 9)
		self:setY(self:getY() - 19)

	elseif (state == "BURNED") then
		self:resetCakemold()
		self:emptyCakemold()
		self:setY(self:getY() + 19)
	
	elseif (state == "FINISH") then
		self:resetCakemold()

	end

	Product.onStateEnter(self, state)

end

function cakemoldPieProduct:onClick()

	self.timerSuspended = true
	Product.onClick(self)

end

function cakemoldPieProduct:onWorkStart(task)

	if (self:getState() == "READY") then
		Product.onWorkStart(self, task)
		self:setState("FINISH")
	
		return true
	end
	
	return false
	
end

function cakemoldPieProduct:onWorkComplete(task)

	Product.onWorkComplete(self, task)
	
	if (string.find(self:getBase(), "APPLE")) then
		getProduct("APPLEPIE"):setStock(4)
		getProduct("APPLEPIE"):animate("PROD_BUT_APPLEPIE_" .. getProduct("APPLEPIE"):getStock(), 0)
		
	elseif (string.find(self:getBase(), "CHERRY")) then
		getProduct("CHERRYPIE"):setStock(4)
		getProduct("CHERRYPIE"):animate("PROD_BUT_CHERRYPIE_" .. getProduct("CHERRYPIE"):getStock(), 0)	
	
	else
		warn("cakemoldPieProduct:onWorkComplete - could not determine pie stock to increase")
	
	end

	self:emptyCakemold()

end

function cakemoldPieProduct:resetCakemold()

	self:stopSound("SOUND_FIREPLACE_LOOP")
	self.timer1 = 0

end

function cakemoldPieProduct:emptyCakemold()

	getProduct("CAKEMOLD"):setVisible(true)
	getProduct("CAKEMOLD"):setClickable(true)
	self:setDestroyed(true)

end