class 'candyjarProduct' (regularProduct)

candyjarProduct.timer = 0
candyjarProduct.timeToFill = 1000
candyjarProduct.fillSound = ""
candyjarProduct.disabled = false

function candyjarProduct:__init(baseName) super(baseName)
end

function candyjarProduct:onClick()

	if (not self.disabled) then
		regularProduct.onClick(self)
	
	else
		hm:openHint(HINT_CHARLESREFILLING, cleaner:getScreenX(), cleaner:getScreenY() - 40)
	
	end

end

function candyjarProduct:onWorkStart(task)

	if (task:getPerson():getType() == "emily") then
		if (self.disabled) then
			-- the product is being refilled
			-- it's still queued on the tray though, so remove it there
			-- and abort the task
			self:unQueue()
			return false	
		else
			return regularProduct.onWorkStart(self, task)
			
		end
	
	elseif (self:getStock() < self:getMaxStock()) then
		-- the product needs to be refilled:
		--   In the candy shop, um:getMiscMultiplier()modifies the 
		--   time it takes for charles to fill the candy jars
		self:playSound(self.fillSound, true)
		self.timer = self.timeToFill * um:getMiscMultiplier()
		self:getAppliance():disableColumn()
		task:getPerson():animate("RESTOCK", -1)
		return true
	
	end
	
	return false
	
end

function candyjarProduct:onWorkUpdate(task, time)

	if (task:getPerson():getType() == "emily") then
		return regularProduct.onWorkUpdate(self, task, time)
	
	else
		if (self.timer > 0) then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self.timer = 0
				return true
			
			end		
		end	
	end
	
	return false

end

function candyjarProduct:onWorkComplete(task)

	if (task:getPerson():getType() == "emily") then
		regularProduct.onWorkComplete(self, task)
		
		if (self:getStock() == 0) then
			if (cleaner:isSitting()) then
				hm:placeArrow(ARROW_HINT_CHARLES, cleaner, 0, 30)
			
			end		
		end
	
	else
		self:stopSound(self.fillSound)
		self:incStock()
		self:getAppliance():enableColumn()
		self:getAppliance():queueNextProduct(task:getPerson())
	
	end

end