class 'eggProduct' (regularProduct)

eggProduct.queued = false
eggProduct.chicken = nil
eggProduct.index = nil
eggProduct.busy = false

function eggProduct:__init(baseName) super(baseName)
end

function eggProduct:onCreate()

	regularProduct.onCreate(self)
	self:setAcceptingTasks(true)

end

function eggProduct:onClick()

	if (self:getState() == "EASTER") then
		if (not self.busy) then
			tm:collectEasterEgg()
			self:setDestroyed(true)
			self.chicken:pickEgg(self)
			self.busy = true
			
		end		
	else
		if (not self.busy) then
			if (self:isQueuableToTray()) then
				self.queued = true
				self.busy = true
		
			end
		
			regularProduct.onClick(self)
		end
	end
end

function eggProduct:onWorkStart(task)

	if (regularProduct.onWorkStart(self, task) == false) then
		self.queued = false
		self.busy = false
		return false
		
	end
	
	return true
	
end

function eggProduct:onWorkComplete(task)

	regularProduct.onWorkComplete(self, task)
		
	self:setDestroyed(true)
	self.chicken:pickEgg(self)

end