--
-- Gumball product
-- The number of gumballs produced depends on the number of times clicked.

class 'gumballProduct' (regularProduct)

gumballProduct.busy = false

function gumballProduct:__init(root) super(root)
end

--
-- called when the product is first created
function gumballProduct:onCreate()
	
	self:setState("EMPTY")

end

--
-- called when the product is clicked
function gumballProduct:onClick()

    if (not self.busy) then
	    if (self:getState() == "EMPTY") then
		    return
	    end
	
	    regularProduct.onClick(self)
	    self.busy = true
	    
    end

end

--
-- called when the product enters a new state
function gumballProduct:onStateEnter(state)

	if (self:getState() == "EMPTY") then
		self:setClickable(false)
		self:animate("PROD_BUT_GUMBALL_BAG_EMPTY", 0)
		self:setVisible(false)
		
	elseif (self:getState() == "1") then
		self:setClickable(true)
		self:animate("PROD_BUT_GUMBALL_BAG_1", 0)
		self:setVisible(true)
		
	elseif (self:getState() == "2") then
		self:setClickable(true)
		self:animate("PROD_BUT_GUMBALL_BAG_2", 0)
		self:setVisible(true)
		
	elseif (self:getState() == "3") then
		self:setClickable(true)
		self:animate("PROD_BUT_GUMBALL_BAG_3", 0)
		self:setVisible(true)
		
	end

end

--
-- called when a person starts working on the product
-- if work is allowed to start it needs to return 'true'
-- otherwise it should return 'false' and the task will be aborted
function gumballProduct:onWorkStart(task)

	if (self:getState() == "EMPTY") then
		warn("gumballProduct - invalid state")
	end
	
	if (not regularProduct.onWorkStart(self, task)) then
		self.busy = false
		return false
	
	end
	
	return true

end

--
-- called when a person completed work on a product
function gumballProduct:onWorkComplete(task)

	regularProduct.onWorkComplete(self, task)
	self:setState("EMPTY")
	self.busy = false
	
end
