--
-- this is a regular Product
-- it is useable for:
-- * simple products like CHIPS, COFFEE
-- * simple stock products 
-- * simple compound products like BUNBOTTOM, LETTUCE, 
-- * simple compound stock products like WAFFLE
--
-- it can be configured by
-- * setWorkTime
-- * setWorkAnimation
-- * setWorkSound
-- * setWorkSoundLooping
-- * setWorkOffsetX
-- * setWorkOffsetY
-- * setStock
-- * setMaxStock

class 'herbProduct' (regularProduct)

function herbProduct:__init(baseName) super(baseName)
end

function herbProduct:onClick()
	Product.onClick(self)
end

function herbProduct:onWorkStart(task)

	if (self:isStockProduct() and (self:getStock() == 0)) then
		self:playSound("SOUND_NO_STOCK")
		return false			
		
	elseif (self:isIngredient()) then
		if (self:isMovableToBubble()) then
			self:moveToBubble()
			
		else
			return false
			
		end
	end	
		
	Product.onWorkStart(self, task)			
	return true
end
