msSuccess = 0
msFailed = 0
msHelp = false

class 'milkshakeButton' (Product)

milkshakeButton.timer1 = 0
milkshakeButton.timer2 = 0

function milkshakeButton:__init(root) super(root)
end

function milkshakeButton:onCreate()

	self:setState("IDLE")

end

function milkshakeButton:getMilkshakeProduct()

	return getProduct("MILKSHAKE" .. self:getBase())

end

function milkshakeButton:getMilkshakeTime()

	time = self:getWorkTime()

	if (msHelp) then
		time = time * 1.2
	
	end
	
	return time

end

function milkshakeButton:onStateEnter(state)

	if (state == "IDLE") then
		self:getMilkshakeProduct():setVisible(false)
	
	elseif (state == "EMPTY") then
		self:getMilkshakeProduct():setVisible(true)
		self:getMilkshakeProduct():animate("PROD_BUT_" .. self:getMilkshakeProduct():getBase() .. "_LOW", 0)
		self:getTimer():setVisible(true)
		self:getTimer():setProgress(0)
		self:playSound("SOUND_BLENDER_START")
		self:playSound("SOUND_BLENDER_LOOP", true)
		self.timer1 = self:getMilkshakeTime()
		self.timer2 = self:getMilkshakeTime() / 3	
		
	elseif (state == "READY") then
		self:getMilkshakeProduct():animate("PROD_BUT_" .. self:getMilkshakeProduct():getBase(), 0)
		self:playSound("SOUND_BRUILLE_STATE_1")
		self.timer2 = self:getMilkshakeTime() / 3		
	
	elseif (state == "FLOWED") then
		self:getMilkshakeProduct():animate("PROD_BUT_" .. self:getMilkshakeProduct():getBase() .. "_FLOW", 0)
		self:playSound("SOUND_BRUILLE_STATE_2")
		self.timer2 = self:getMilkshakeTime() / 3		
	
	elseif (state == "TIMEDOUT") then
		msFailed = msFailed + 1
		msSuccess = 0

		self:getMilkshakeProduct():unQueue()
		self:setState("FINISH")
	
	elseif (state == "FINISH") then
		self:getTimer():setVisible(false)
		self:getTimer():setProgress(0)
		self:stopSound("SOUND_BLENDER_LOOP")
		self:playSound("SOUND_BLENDER_ENDS")
		self.timer1 = 0
		self.timer2 = 0
		
		-- dynamic difficulty:
		-- if you fail a milkshake twice in a row, we enable help
		-- if you make three milkshakes correctly it will disable help
		if (not msHelp) then
			if (msFailed >= 2) then
				msHelp = true
				
			end
			
		else
			if (msSuccess >= 3) then
				msHelp = false
		
			end
		end
		
	end

end

function milkshakeButton:onClick()

	if (self:getState() == "IDLE") then
		if (self:getMilkshakeProduct():isQueuableToTray()) then
			self:getMilkshakeProduct():queue()
			Product.onClick(self)
	
		end	
	end
	
end

function milkshakeButton:onWorkStart(task)

	if (self:getState() == "IDLE") then
		if (self:getMilkshakeProduct():isQueuedOnTray()) then
			Product.onWorkStart(self, task)
			task:setDuration(-1)
			self:setState("EMPTY")			
			return true
	
		else
			tray:clearInvisible()
	
		end
	end
	
	return false

end

function milkshakeButton:onWorkUpdate(task, time)

	if (not scene:isPlayingMovie()) then
		if (self:getState() == "EMPTY") then
			self.timer1 = self.timer1 - time
			self.timer2 = self.timer2 - time
			if (self.timer2 <= 0) then
				self:setState("READY")
			
			end
		
		elseif (self:getState() == "READY") then
			self.timer1 = self.timer1 - time
			self.timer2 = self.timer2 - time
			if (self.timer2 <= 0) then
				self:setState("FLOWED")
			
			elseif (self.timer2 <= self:getMilkshakeTime() / 6) then
				if (self.timer2 + time > self:getMilkshakeTime() / 6) then
					--
					-- open the milkshake hint here
					hm:openHint(HINT_SHAKE_READY, 414, 367)
				
				end			
			end
			
		elseif (self:getState() == "FLOWED") then
			self.timer1 = self.timer1 - time
			self.timer2 = self.timer2 - time
			if (self.timer2 <= 0) then
				self:setState("TIMEDOUT")
			
			end	
		
		elseif (self:getState() == "FINISH") then
			self:setState("IDLE")
			return true
				
		end
		
		progress = 1 - (self.timer1 / self:getMilkshakeTime())	
		self:getTimer():setProgress(progress)
	end
	
	return false

end

function milkshakeButton:onWorkClick()

	if (self:getState() == "EMPTY") then
		msFailed = msFailed + 1
		msSuccess = 0
		
		self:getMilkshakeProduct():unQueue()
		self:setState("FINISH")
		return true
	
	elseif (self:getState() == "READY") then
		msFailed = 0
		msSuccess = msSuccess + 1	
		
		self:getMilkshakeProduct():moveToTray()
		self:setState("FINISH")
		return true
	
	elseif (self:getState() == "FLOWED") then
		msFailed = msFailed + 1
		msSuccess = 0
		
		self:getMilkshakeProduct():unQueue()
		self:setState("FINISH")
		return true
	
	end
	
	return true

end
