class 'ovenSecondProduct' (Product)

ovenSecondProduct.timer1 = 0
ovenSecondProduct.timerSuspended = false
ovenSecondProduct.frontSprite = nil
ovenSecondProduct.queued = false

function ovenSecondProduct:__init(root) super(root)

	if (type(root) == "userdata") then
		self.timer1 = root.timer1
		self.timerSuspended = root.timerSuspended
		
	end		
	
end

function ovenSecondProduct:onSlotEnter(slot)

	if (slot:getName() == "slot1") then
		self.frontSprite = getAppliance("rest3_oven").leftSprite
	else
		self.frontSprite = getAppliance("rest3_oven").rightSprite
	end
	self:setState("BAKING")
	
end

function ovenSecondProduct:onTick(time)

	if (self.timerSuspended == false) then
		if (self:getState() == "BAKING") then
			self.timer1 = self.timer1 - time
			if (self.timer1 <= 0) then
				self:setState("READY")
			end
		end		
	end
	
	Product.onTick(self, time)

end

function ovenSecondProduct:onStateEnter(state)

	if (state == "BAKING") then
		self:setClickable(false)
		self.timer1 = 1000 * 3
		self:playSound("SOUND_BRUILLE_BURNER_LOOP", true)
		self.frontSprite:setCurrentFrame(1)
		self:playSound("SOUND_OVEN_ON")
		
	elseif (state == "READY") then
		self:animate("PROD_BUT_" .. self:getBase(), 0)
		self:setClickable(true)
		self:blink(1, 0, 3)
		self:stopSound("SOUND_BRUILLE_BURNER_LOOP")
		self:playSound("SOUND_OVEN_DONE")
		self.timer1 = 0
		self.frontSprite:setCurrentFrame(2)
		
	end

	Product.onStateEnter(self, state)

end

function ovenSecondProduct:onClick()

	if (not self.queued) then
		self.timerSuspended = true
		self.queued = true
		self:queue()
		Product.onClick(self)
		
	end

end

function ovenSecondProduct:onWorkStart(task)

	if (self:isQueuedOnTray()) then
		Product.onWorkStart(self, task)
		return true
		
	else
		tray:clearInvisible()
		self.timerSuspended = false
		self.queued = false
	
	end

	return false
	
end

function ovenSecondProduct:onWorkComplete(task)

	Product.onWorkComplete(self, task)
	self:moveToTray()
	self.frontSprite:setCurrentFrame(0)
	self:setDestroyed(true)
	
end
