include("scripts/products/regularproduct.lua")

class 'pancakeProduct' (regularProduct)

pancakeProduct.timer = 0
pancakeProduct.timerSuspended = true
pancakeProduct.applianceName = ""
pancakeProduct.busy = false

function pancakeProduct:__init(root) super(root)

	if (type(root) == "userdata") then
		self.timer = root.timer
		self.timerSuspended = root.timerSuspended
		self.applianceName = root.applianceName
		self.busy = root.busy
	end	
	
end

function pancakeProduct:onCreate()
	self:setState("RAW")
end

function pancakeProduct:onClick()

    if (self:getState() == "RAW") then
		if (self:isQueuableToTray()) then    
			Product.onClick(self)	
	        
        end
    elseif (self:getState() == "READY") then
        if (not self.busy) then
            self.timerSuspended = true
            self:queue()
            self.busy = true
	        Product.onClick(self)	    
	                
        end    
    end

end

function pancakeProduct:onStateEnter(state)
	
	if (self:getState() == "RAW") then
		self:setWorkAnimation("WORK")
	
	elseif (self:getState() == "FRYING") then
		self:setClickable(false)
		self:setWorkTime(0)
		self:animate("PROD_BUT_" .. self:getBase() .. "_FRYING", 0)
		self:playSound("SOUND_PANKAKE_BAKING", true)
		self.timer = 2000
		self.timerSuspended = false
	
	elseif (self:getState() == "READY") then
		hm:openHint(HINT_PANCAKE_READY, self:getScreenX() + 30, self:getScreenY() + 30);
        hm:placeArrow(ARROW_HINT_PANCAKE_READY, self, 20, -5);	
	
		self:blink()
		self:setClickable(true)
		self:animate("PROD_BUT_" .. self:getBase() .. "_READY", 0)
		self:playSound("SOUND_FRYER_READY")		
		self:setWorkTime(0)
		self:setWorkAnimation("WORK")
		self.timer = 4000
		self.timerSuspended = false
		
	elseif (self:getState() == "BURNING") then
		self:setClickable(false)
		self:clearOverhead()
		self:stopSound("SOUND_PANKAKE_BAKING")
		self:playSound("SOUND_BURGER_EGG_BURNS")
		self:animate("ANIM_" .. self:getBase() .. "_BURN", 1, false, 10, true)
		self:setY(self:getY() - 19)
		self.timer = 3000
		self.timerSuspended = false
	end
end

function pancakeProduct:onReceiveComplete()
	if (self:getState() == "RAW") then
		self:setState("FRYING")
		self.timerSuspended = false
	end
end

function pancakeProduct:onSlotEnter(slot)

	if (slot:getName() == "slot1") then
		self:setWorkOffsetX(-1)
	else
		self:setWorkOffsetX(2)
	end
	
end

function pancakeProduct:onWorkStart(task)

	if (self:isDestroyed()) then
		warn("pancakeProduct:onWorkStart - is destroyed")
		return false

	elseif (self:getState() == "RAW") then
		if (getAppliance(self.applianceName):hasSlotsOpen()) then
			return Product.onWorkStart(self, task)
			
		else
			return false
		
		end
		
	elseif (self:getState() == "READY") then
		if (self:isQueuedOnTray()) then
			self:stopSound("SOUND_PANKAKE_BAKING")
			return Product.onWorkStart(self, task)
		
		else
			self.busy = false
			self.timerSuspended = false
			self:unQueue()
			return false		
		
		end
	end

	warn("pancakeProduct:onWorkStart - invalid state: " .. self:getState())
	return false

end

function pancakeProduct:onWorkComplete(task)
	if (self:getState() == "RAW") then
		self:moveToAppliance(getAppliance(self.applianceName))
		
	elseif (self:getState() == "READY") then
		if (self:isMovableToBubble()) then
			self:moveToBubble()				
			self:setVisible(false)
			self:setClickable(false)
		else
			self:unQueue()
		end	
	end
	
	self.busy = false	
end

function pancakeProduct:onBubbleCancel()	

	self:playSound("SOUND_PANKAKE_BAKING", true)
	self:unQueue()
	self:setVisible(true)
	self:setClickable(true)
	self.timerSuspended = false
	
end

function pancakeProduct:onBubbleMerged()

	if (self:isIngredient()) then
		if (not self:isVisible()) then
			self:setDestroyed(true)
		end
	end

end

function pancakeProduct:onTick(time)

	if (not scene:isStartingMovie() and not scene:isPlayingMovie()) then
		if (not self.timerSuspended) then
			if (self:getState() == "FRYING") then
				self.timer = self.timer - time
				if (self.timer <= 0) then
					self:setState("READY")				
				end
					
			elseif (self:getState() == "READY") then
				self.timer = self.timer - time
				if (self.timer <= 0) then
					self:setState("BURNING")					
				end	
			end	
		end
	end
	
	if (not self.timerSuspended) then
		if (self:getState() == "BURNING") then
			self.timer = self.timer - time
			if (self.timer <= 0) then
				self:setY(self:getY() + 19)
				self:setDestroyed(true)
				self:setVisible(false)
				
			end	
		end
	end

end

