include("scripts/products/regularproduct.lua")

class 'popcornProduct' (regularProduct)

popcornProduct.popcornMachine = nil
popcornProduct.popcornMachineName = nil

--
--
function popcornProduct:__init(baseName) super(baseName)
end

function popcornProduct:onClick()

	local ignore = false
	if (self:isQueuedLast()) then
		ignore = true
		
		if (getProduct("SALT")) then
			if (getProduct("SALT"):isQueuedLast()) then
				ignore = false
			end		
		end
		if (getProduct("SWEET")) then
			if (getProduct("SWEET"):isQueuedLast()) then
				ignore = false
			end		
		end	
	end
	
	if (ignore) then
		return
	end
	
	regularProduct.onClick(self)

end

-- this event is only raised if it's an ingredient
-- of a compound product
function popcornProduct:onBubbleMerged()

	regularProduct.onBubbleMerged(self)
	
	self:resolvePopcornMachine()
    self.popcornMachine:adjustStock(-1)

end

--
--
function popcornProduct:setMachineName(name)
	self.popcornMachineName = name
end

--
--
function popcornProduct:resolvePopcornMachine()
	if (self.popcornMachine == nil and self.popcornMachineName ~= nil) then
		self.popcornMachine = getAppliance(self.popcornMachineName)
	end
end

--
--
function popcornProduct:onWorkStart(task)

    self:resolvePopcornMachine()
    if (self.popcornMachine:hasStock()) then
        return regularProduct.onWorkStart(self, task)
    
    end

	self:playSound("SOUND_NO_STOCK")
    self:unQueue()	
	return false
	
end