include("scripts/products/regularproduct.lua")
include("scripts/products/batterbowlproduct.lua")
include("scripts/products/milkshakeproduct.lua")

-- global variables and behavior we might need in a specific restaurant

-- entry node
-- npc's and such will be spawned at this location
entryX = 0
entryY = 4
entryNode = nil

-- exit node
exitX = 0
exitY = 4
exitNode =  nil

-- movie node
-- when a movie is playing and an npc's enters or exits (and gets destroyed),
-- it will do so from this node
movieX = 36
movieY = 0
movieNode = nil

-- restaurant class
class 'restaurant0' (interface)

function restaurant0:__init() super()
end

function restaurant0:createPerson(class)

	if (class == "cleaner") then
		c = d2cleaner("INGAME_PERSON_BETTY")
		c:setType("cleaner")
		c:animate("IDLE", 0)
		c.clean = true
		return c	

	end
	
	return nil

end

function restaurant0:createProduct(base)

	bubbleBurgerX = 390
	bubbleBurgerY = 555
	bubbleBurgerS = true
	bubbleWaffleX = 526
	bubbleWaffleY = 395
	bubbleWaffleS = true
	
	if (base == "COFFEE") then
		p = regularProduct(base)
		p:setWorkOffsetY(1)
		p:setWorkTime(800)
		p:setWorkAnimation("WORK_RIGHT")
		p:setWorkSound("SOUND_MAKECOFFEE")
		return p
	
	elseif (base == "COKE") then
		p = regularProduct(base)
		p:setWorkOffsetY(-1)
		p:setWorkTime(800)
		p:setWorkAnimation("WORK_RIGHT")
		p:setWorkSound("SOUND_PICKDRINKANDPOPCAP")
		return p
		
	elseif (base == "CHIPS") then
		p = regularProduct(base)
		p:setWorkTime(800)
		p:setWorkAnimation("WORK_FRONT")
		p:setWorkSound("SOUND_REFILL_NACHOS_LOOP")
		return p	
		
	elseif (base == "DONUT") then
		p = regularProduct(base)
		p:setWorkOffsetX(1)
		p:setWorkTime(800)
		p:setWorkAnimation("WORK_FRONT")
		p:setWorkSound("SOUND_MAKEBAGEL")
		return p
		
	elseif (base == "BUNBOTTOM") then
		p = regularProduct(base)
		p:setBubbleX(bubbleBurgerX)
		p:setBubbleY(bubbleBurgerY)
		p:setBubbleSmall(bubbleBurgerS)
		p:setWorkOffsetX(-5)
		p:setWorkTime(0)
		p:setWorkAnimation("WORK_FRONT")
		p:setWorkSound("SOUND_GRAB_TEA")
		return p
	
	elseif (base == "LETTUCE") then
		p = regularProduct(base)
		p:setBubbleX(bubbleBurgerX)
		p:setBubbleY(bubbleBurgerY)
		p:setBubbleSmall(bubbleBurgerS)
		p:setWorkOffsetX(-2)
		p:setWorkTime(400)
		p:setWorkAnimation("WORK_FRONT")
		p:setWorkSound("SOUND_MAKESUSHI")
		return p
	
	elseif (base == "BURGER") then
		p = regularProduct(base)
		p:setBubbleX(bubbleBurgerX)
		p:setBubbleY(bubbleBurgerY)
		p:setBubbleSmall(bubbleBurgerS)
		p:setWorkOffsetX(0)
		p:setWorkTime(400)
		p:setWorkAnimation("WORK_FRONT")
		p:setWorkSound("SOUND_DROPMULTIPLESLICES")
		return p
	
	elseif (base == "CHEESE") then
		p = regularProduct(base)
		p:setBubbleX(bubbleBurgerX)
		p:setBubbleY(bubbleBurgerY)
		p:setBubbleSmall(bubbleBurgerS)
		p:setWorkOffsetX(3)
		p:setWorkTime(400)
		p:setWorkAnimation("WORK_FRONT")
		p:setWorkSound("SOUND_DROPMULTIPLESLICES")
		return p
	
	elseif (base == "BUNTOP") then
		p = regularProduct(base)
		p:setBubbleX(bubbleBurgerX)
		p:setBubbleY(bubbleBurgerY)
		p:setBubbleSmall(bubbleBurgerS)
		p:setWorkOffsetX(6)
		p:setWorkTime(400)
		p:setWorkAnimation("WORK_FRONT")
		p:setWorkSound("SOUND_GRAB_TEA")
		return p
	
	elseif (base == "WAFFLE") then
		p = regularProduct(base)
		p:setBubbleX(bubbleWaffleX)
		p:setBubbleY(bubbleWaffleY)
		p:setBubbleSmall(bubbleWaffleS)
		p:setWorkTime(0)
		p:setWorkAnimation("WORK")
		p:setWorkSound("SOUND_GRAB_TEA")
		p:setStock(2)
		p:setMaxStock(8)
		return p
	
	elseif (base == "CHOCOLATESAUCE") then
		p = regularProduct(base)
		p:setBubbleX(bubbleWaffleX)
		p:setBubbleY(bubbleWaffleY)
		p:setBubbleSmall(bubbleWaffleS)
		p:setWorkOffsetX(2)
		p:setWorkTime(800)
		p:setWorkAnimation("WORK")
		p:setWorkSound("SOUND_KETCHUPSQUIRT")
		return p
	
	elseif (base == "WHIPCREAM") then
		p = regularProduct(base)
		p:setBubbleX(bubbleWaffleX)
		p:setBubbleY(bubbleWaffleY)
		p:setBubbleSmall(bubbleWaffleS)
		p:setWorkOffsetX(4)
		p:setWorkTime(800)
		p:setWorkAnimation("WORK")
		p:setWorkSound("SOUND_POURSAUCE")
		return p
	
	elseif (base == "BATTERBOWL") then
		p = batterbowlProduct(base)
		return p	
		
	elseif (base == "BANANA") then
		p = milkshakeButton(base)
		p:setWorkTime(1800)
		p:setWorkAnimation("WORK")
		p:getTimer():setX(28)
		p:getTimer():setY(-19)
		return p
	
	elseif (base == "STRAWBERRY") then
		p = milkshakeButton(base)
		p:setWorkTime(1800)
		p:setWorkAnimation("WORK")
		p:getTimer():setX(-28)
		p:getTimer():setY(-19)			
		return p
	
	elseif (type(base) == "userdata") then
		--
		-- attempting to create a copy!
		if (base:getBase() == "BATTERBOWL") then
			p = batterbowlProduct(base)
			return p
		
		end
	
	end
	
	return nil

end

-- set restaurant
restaurant = restaurant0()