-- set event

-- day class
class 'day0' (interface)

day0.tutorial = false

function day0:__init() super()
end

function day0:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	coke = getProduct("COKE")
	coke:setClickable(false)
	coke:setAcceptingTasks(true)
	coffee = getProduct("COFFEE")
	coffee:setClickable(false)
	coffee:setAcceptingTasks(true)
	donut = getProduct("DONUT")
	donut:setClickable(false)
	donut:setAcceptingTasks(true)
	chips = getProduct("CHIPS")
	chips:setClickable(false)
	chips:setAcceptingTasks(true)
	bunbottom = getProduct("BUNBOTTOM")
	bunbottom:setClickable(false)
	bunbottom:setAcceptingTasks(true)
	burger = getProduct("BURGER")
	burger:setClickable(false)
	burger:setAcceptingTasks(true)
	buntop = getProduct("BUNTOP")
	buntop:setClickable(false)	
	buntop:setAcceptingTasks(true)
		
	for i = 0,4 do
		om:getTable(i):setClickable(false)
	
	end
	
	register:setClickable(false)
	telephone:setClickable(false)

	-- create francois
    francois = pm:createPerson("francois")
    cleaner  = pm:createPerson("npc")
    cleaner:setBaseName("INGAME_PERSON_BETTY")
    cleaner:setDefaultFrameRate(10)
    
    -- create fake customers group
    sitCustomers = {}
    sitCustomers[1] = pm:createPerson("fakecustomer")
    sitCustomers[1]:setBaseName("INGAME_CUSTOMER_MALE_CHILD")
    sitCustomers[1].timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)
    sitCustomers[2] = pm:createPerson("fakecustomer")
    sitCustomers[2]:setBaseName("INGAME_CUSTOMER_FEMALE_CHILD")
    sitCustomers[2].timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)
    
    counterCustomer = pm:createPerson("fakecustomer")
    counterCustomer:setBaseName("INGAME_CUSTOMER_MALE_REGULAR")
    counterCustomer:setAcceptingTasks(true)
    counterCustomer:setPosition(entryNode)
    counterCustomer:createHighlight()
    
    groupCustomers = {}
    groupCustomers[1] = pm:createPerson("fakecustomer")
    groupCustomers[1]:setBaseName("INGAME_CUSTOMER_FEMALE_REGULAR")
    groupCustomers[1]:setAcceptingTasks(true)
    groupCustomers[1]:setPosition(entryNode)
    groupCustomers[1]:createHighlight()
    groupCustomers[2] = pm:createPerson("fakecustomer")
    groupCustomers[2]:setBaseName("INGAME_CUSTOMER_MALE_CHILD")
    groupCustomers[2]:setAcceptingTasks(true)
    groupCustomers[2]:setPosition(entryNode)
    groupCustomers[2]:createHighlight()
    
    order = nil
    groupTable = om:getTable(2)
    
    appDrinkRug = getAppliance("rest0_drinkrug")
    appDrinkRug:setAcceptingTasks(true)
    
    appChipsDonut = getAppliance("rest0_chips_donut_boxes")
    appChipsDonut:setAcceptingTasks(true)
    
    -- This var will tell us where in the script we are:
    tutorialProgress = "START"
    
    -- sit the customers down at a table
    table = om:getTable(3)
    table:sitDown(sitCustomers[1], 0)
    table:sitDown(sitCustomers[2], 1)
    
    overheadFrameTime = 200
    counterCustomer:setOverheadFrameTime(overheadFrameTime)
    groupCustomers[1]:setOverheadFrameTime(overheadFrameTime)
    groupCustomers[2]:setOverheadFrameTime(overheadFrameTime)
    appDrinkRug:setOverheadFrameTime(overheadFrameTime)
    appChipsDonut:setOverheadFrameTime(overheadFrameTime)
    groupTable:setOverheadFrameTime(overheadFrameTime)
    
    -- set the initial settings of 
    -- betty
    -- is positioned at the counter
    -- has return home disabled. since betty is a cleaner, she will
    -- automatically return to the cleaning node. we don't want that
    -- in this animation
    cleaner:setPosition(grid:getNode(40, 28))    
    cleaner:setReturnHome(false)
    cleaner:animate("CLEAN_RIGHT", 0)
    -- emily    
    -- is positioned at an entry point
    -- and appears crashed
    emily:setPosition(movieNode)
    emily:setAppearance("CRASHED")
    -- francois    
    -- is positioned at an entry point
    -- and appears crashed    
    francois:setPosition(movieNode)
    francois:setAppearance("CRASHED")
    
    -- show the movie bar non-animated
	scene:showBars(false)

    -- start movie sequence
    -- ... this disables input
    -- ... this suspends the people manager so no customers enter
    scene:qStartMovie()

    -- first part: emily and francois walk in
    -- we want them to walk in together, so this part needs
    -- to be parallel
    parallel()
    emily:qWait(2000)
    emily:qWalkToXY(32,17)
    
    francois:qWait(2500)
    francois:qWalkToXY(36,17)
    francois:qAnimate("DUSTOFF", -1, 10)
    francois:qWait(1500)
    francois:qAnimate("IDLE", 0)
    
    cleaner:qAnimate("CLEAN_RIGHT", 3)
    cleaner:qWait(2000)
    cleaner:qWalkToNode(grid:getCounterNode())
    cleaner:qAnimate("CLEAN_BACK", -1)

	-- second part: first conversation
	-- we don't want them to talk through eachother, so this part
	-- needs to be sequential
    sequential()  
    emily:qWait(1000)  
    emily:qSay("WHATNOW")
    cleaner:qAnimate("CLEAN_BACK", 0)     
    francois:qSay("WORKSOMETHINGOUT")
    cleaner:qSay("CONSTERNATION")
    emily:qSay("CARBROKEDOWN")
    cleaner:qSay("CUPOFTEA")

    -- third part: betty gets a cup of tea while francois and emily take a seat
    -- use betty's cleaning animation to simulate getting a cup of tea
	parallel()
	emily:qWait(500)
    emily:qSit(om:getTable(0))
    francois:qWait(750)
    francois:qSit(om:getTable(1))
    cleaner:qWalkToXY(39,32)
    cleaner:qAnimate("CLEAN_RIGHT", -1)
    cleaner:qWait(1500)
    cleaner:qWalkToXY(21,32)
    cleaner:qWalkToXY(21,29)
    
    -- TODO: Uncomment block below (commented to speed testing up)
    -- fourth part: second conversation
    sequential()
    cleaner:qSay("NEARESTGARAGE")
    emily:qWait(500)
    emily:qSetAppearance("CRASHED_SAD")
    emily:qAnimate("SIT_RIGHT_CRASHED_CRY", -1)
    emily:qWait(1000)
    emily:qSay("NOMONEY")
    cleaner:qSetAppearance("SAD")
    cleaner:qWait(300)
    cleaner:qCreateOverhead("INGAME_THINK_ICON")
    cleaner:qWait(2000)
    cleaner:qSetAppearance("HAPPY")
    cleaner:qCreateOverhead("INGAME_LIGHT_ICON")
    cleaner:qWait(1500)
    cleaner:qRemoveOverhead()
    cleaner:qSay("WORKHERE")
    emily:qWait(500)
    emily:qSetAppearance("CRASHED_HAPPY")    
    emily:qAnimate("IDLE", 0)     
    emily:qWait(1000)
    emily:qSay("REALLYTHANKS")
    emily:qSay("KNOWYOURNAME")
    cleaner:qSetAppearance("")
    cleaner:qSay("NAMESBETTY") 
    cleaner:qSay("RESTUP")

    -- fifth part
    -- we fade to black
    -- ... then we change the scene
    -- ... then we fade out
    scene:qWait(1000)
    scene:qFadeToBlack()
    
    francois:qStand()
    francois:qDestroy("francois")
    sitCustomers[1]:qStand()
    sitCustomers[1]:qDestroy("sitCustomers[1]")
    sitCustomers[2]:qStand()
    sitCustomers[2]:qDestroy("sitCustomers[2]")
	
    emily:qStand()
    emily:qSetPosition(movieNode)
    emily:qSetAppearance("")
    cleaner:qSetPosition(grid:getCounterNode())

    scene:qFadeOutBlack()
    
    emily:qWalkToXY(32,17)
	cleaner:qSay("TEXT_WHEREFRIEND")
    emily:qWait(500)
    emily:qSetAppearance("NEUTRAL")
    emily:qSay("TEXT_HURTKNEE")
    emily:qSetAppearance("")
    emily:qWait(500)
    cleaner:qSayYesNo("TEXT_WANTHELP")
end

function interface:onDayBegin()
end

function day0:EndTutorial()

	-- Destroy a bunch of customers
	counterCustomer:qDestroy("counterCustomer")	
	groupCustomers[1]:qDestroy("groupCustomers[1]")		
	groupCustomers[2]:qDestroy("groupCustomers[2]")	

	-- Rounding up the conversation and
	-- let actors walk to correct starting 
	-- positions simultaniously
	cleaner:qWalkToXY(21,25)
	cleaner:qWait(500)
	parallel()
	cleaner:qSay("TEXT_ORGANIZELOBBY")
	emily:qWalkToCounter()
	emily:qWait(500)
	sequential()
	emily:qSay("TEXT_HANDLERESTAURANT")
	emily:qWait(500)

	if (self.tutorial) then

		cleaner:qWalkToXY(21,25)
		cleaner:qWalkToNode(exitNode)
		cleaner:qDestroy("cleaner")

		scene:qStartGame()
		scene:qNotify("end tutorial")
		
	else
	
		cleaner:qWalkToXY(21,25)
		cleaner:qWalkToNode(movieNode)
		cleaner:qDestroy("cleaner")

		scene:qFinishMovie()
		scene:qStartGame()	
		scene:qNotify("end tutorial")
	
	end

end

function day0:onClickMessage(text, result)
	
	if (text == "TEXT_WANTHELP") then
		if (result == "yes") then
			self.tutorial = true
		
			scene:qFinishMovie()
			scene:qNotify("start tutorial")
			
			emily:qSetWalkTimePerNode(35)
			cleaner:qSetWalkTimePerNode(35)
	
			cleaner:qWait(500)
			cleaner:qSayTimed("TEXT_OKLISTEN", 2000)
			
			-- First customer walks in while the rest walks to 
			-- their position in the kitchen:
			parallel()
			counterCustomer:qWalkToXY(34,21)
			emily:qWalkToCounter()
			cleaner:qWalkToXY(21,25)

			-- Customers thinks and orders after which betty 
			-- explains how to serve the customer:
			counterCustomer:qCreateOverhead("INGAME_THINK_ICON")
    		counterCustomer:qWait(4000)
    		counterCustomer:qClearOverhead()
			counterCustomer:qWait(500)
    		counterCustomer:qNotify("create order")
    		
		else
			self:EndTutorial()

		end
		
		return true
	end

end

function day0:onClickPerson(person)
	
	if (not self.tutorial) then
		return
		
	end	
	
	-- Handle coke click for the first tutorial customer:
	if (person:getBaseName() == "INGAME_CUSTOMER_MALE_REGULAR" and tutorialProgress == "CLICKED_COKE" and (not tray:isEmpty())) then
		tutorialProgress = "NULL"
		counterCustomer:qClearOverhead()
		emily:qWalkToCounter()
		emily:qWait(200)
		scene:qNotify("distribute product")
	end
	return false
	
end

function day0:onClickProduct(product)

	if (not self.tutorial) then
		return
		
	end

	if (product:getName() == "COKE") then
		coke:setClickable(false)
		appDrinkRug:clearOverhead()
	
	elseif (product:getName() == "CHIPS") then
		chips:setClickable(false)
		appChipsDonut:clearOverhead()
		
	elseif (product:getName() == "COFFEE") then
		coffee:setClickable(false)
		appDrinkRug:clearOverhead()

	end
	
	return false

end

function day0:onClickRegister(register)

	if (not self.tutorial) then
		return
		
	end

	register:setClickable(false)
	register:clearOverhead()	
	return false

end

function day0:onClickTable(table)

	if (not self.tutorial) then
		return
		
	end

	groupTable:setClickable(false)
	groupTable:clearOverhead()
	return false

end

function day0:onTaskStart(actorType, taskType, p0, p1)

	if (not self.tutorial) then
		return
		
	end

	if (taskType == "RegisterTask" and tutorialProgress == "CLICK_REGISTER") then
		-- Remove arrow over register and order balloon over customer1:
		self.order:setObsolete(true)
		self.order = nil
		
		-- Customer1 walks out of the restaurant
		counterCustomer:qWait(500)
		counterCustomer:qWalkToNode(exitNode)
		cleaner:qSetAppearance("HAPPY")
		cleaner:qSayTimed("TEXT_QUICKLEARNER", 3000)
		cleaner:qSetAppearance("")
		
		-- Customer 2 and 3 walk in and sit down at a table
		parallel()
		cleaner:qSay("TEXT_PREFERTABLE")		
		
		groupCustomers[1]:qSitAt(groupTable, 0)
		groupCustomers[2]:qWait(200)
		groupCustomers[2]:qSitAt(groupTable, 1)
		groupCustomers[2]:qNotify("table read")
    	
    elseif (taskType == "RegisterTask" and tutorialProgress == "CLICK_REGISTER_TABLE") then
    	-- Remove arrow over register and order balloon over customer2:
		self.order:setObsolete(true)
		self.order = nil

		-- Customer2 and 3 walk out of the restaurant
		groupCustomers[1]:qWait(500)
		groupCustomers[1]:qWalkToXY(36,12)
		groupCustomers[2]:qStand()
		groupCustomers[2]:qWalkToXY(35,15)
		parallel()
		groupCustomers[1]:qWait(400)
		groupCustomers[2]:qWait(400)
		groupCustomers[1]:qWalkToNode(exitNode)
		groupCustomers[2]:qWait(200)
		groupCustomers[2]:qWalkToNode(exitNode)
		sequential()
		cleaner:qSay("TEXT_MESSYCUSTOMERS")
		groupTable:qCreateOverhead("INGAME_ARROW")
		groupTable:qSetClickable(true)
		tutorialProgress = "CLICK_CLEAN_TABLE"

	elseif (taskType == "TableTask" and tutorialProgress == "CLICK_CLEAN_TABLE" and p0:getOverheadY() == -100) then
		tutorialProgress = "CLEANING_TABLE"
		
	end
	return false
	
end


function day0:onTaskComplete(actorType, taskType, p0, p1)

	if (not self.tutorial) then
		return
		
	end

	if (taskType == "ProductTask" and p0:getName() == "COKE" and tutorialProgress == "CLICK_COKE") then
		tutorialProgress = "CLICKED_COKE"
		counterCustomer:setOverheadY(10)
		counterCustomer:qCreateOverhead("INGAME_ARROW")
		cleaner:qSayClickable("TEXT_GIVECUSTOMER")
	
	elseif (taskType == "ProductTask" and p0:getName() == "CHIPS" and tutorialProgress == "CLICK_CHIPS") then
		tutorialProgress = "CLICKED_CHIPS"
		groupTable:setAcceptingTasks(true)
		groupTable:setOverheadY(-100)
		groupTable:qCreateOverhead("INGAME_ARROW")
		groupTable:qSetClickable(true)
			
	elseif (taskType == "ProductTask" and p0:getName() == "COFFEE" and tutorialProgress == "CLICK_COFFEE") then
		tutorialProgress = "CLICK_CHIPS"
		appChipsDonut:setOverheadY(0)
		appChipsDonut:setOverheadX(-30)
		appChipsDonut:qCreateOverhead("INGAME_ARROW")
		chips:qSetClickable(true)

	elseif (taskType == "TableTask" and tutorialProgress == "CLICKED_CHIPS") then
		tutorialProgress = "SERVE_TABLE"
		scene:qNotify("table serve")

	elseif (taskType == "TableTask" and tutorialProgress == "CLEANING_TABLE" and p0:getOverheadY() == -100) then 
		tutorialProgress = "CLEANED_TABLE"
		cleaner:qSetAppearance("HAPPY")
		cleaner:qSay("TEXT_SPOTCLEAN")
		cleaner:qSay("TEXT_SEVERALBONUSSES")
		cleaner:qSetAppearance("")
		
		self:EndTutorial()

	elseif (taskType == "RegisterTask") then
		register:playSound("SOUND_REGISTER_END", "sound")
	
	end
	return false

end


function day0:onNotify(notification)

	if (notification == "create order") then
		self.order = createOrder()
		self.order:setPivotPointType(BOTTOMCENTER)
		
		-- calculate order position
		x = -counterCustomer:getAnchorX() + counterCustomer:getWidth() / 2
		y = -counterCustomer:getAnchorY()
		
		-- place order
		self.order:setX(x)
		self.order:setY(y)
		self.order:setAnchorPointType(BOTTOMCENTER)		
		counterCustomer:addChild(self.order)
		self.order:addProduct("COKE")
		self.order:popIn()
		
		cleaner:qWait(500)
		appDrinkRug:setOverheadY(-20)
		appDrinkRug:qCreateOverhead("INGAME_ARROW")
		coke:qSetClickable(true)
		cleaner:qSayClickable("TEXT_MAKEPRODUCTS")
		tutorialProgress = "CLICK_COKE"

	elseif (notification == "distribute product") then
		tray:distributeProducts(self.order)
		self.order:draw()
		register:setAcceptingTasks(true)
		register:setOverheadY(0)
		register:qCreateOverhead("INGAME_ARROW")
		register:qSetClickable(true)
		cleaner:qSayClickable("TEXT_HANDLEPAYMENT")
		scene:qNotify("handle payment")
		
	elseif (notification == "handle payment") then
		tutorialProgress = "CLICK_REGISTER"
		
	elseif (notification == "table read") then
		-- animate customers
		groupCustomers[1].timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)		
		groupCustomers[1].state = "READ"
		groupCustomers[1]:animate("READ", 1)	
		groupCustomers[2].timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)		
		groupCustomers[2].state = "READ"
		groupCustomers[2]:animate("READ", 1)	
		
    	scene:qWait(6000)
    	scene:qNotify("table order")			

	elseif (notification == "table order") then
		-- animate customers
		groupCustomers[1].timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)		
		groupCustomers[1].state = "ORDER"
		groupCustomers[1]:animate("ORDER", 1)	
		groupCustomers[2].timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)		
		groupCustomers[2].state = "ORDER"
		groupCustomers[2]:animate("ORDER", 1)		
		groupTable:updateLegs(groupCustomers[1], 0)
		groupTable:updateLegs(groupCustomers[2], 1)
	
    	-- Create an order for the table group
    	self.order = createOrder()
    	self.order:setPivotPointType(BOTTOMCENTER)

		-- place order
		self.order:setX(2)
		self.order:setY(-47)
		self.order:setAnchorPointType(BOTTOMCENTER)
		groupTable:addChild(self.order)
		self.order:addProduct("COFFEE")
		self.order:addProduct("CHIPS")
		self.order:popIn()
		
		appDrinkRug:setOverheadY(10)
		appDrinkRug:qCreateOverhead("INGAME_ARROW")
		coffee:qSetClickable(true)
		tutorialProgress = "CLICK_COFFEE"
		
	elseif (notification == "table serve") then
		tray:distributeProducts(self.order)
		self.order:draw()
		self.order:setAlpha(0)
		groupTable:setPlateState(PLATES_FULL)

		x = -groupCustomers[1]:getAnchorX() + 47
		y = -groupCustomers[1]:getAnchorY() - 60
		
		self.order:setX(x)
		self.order:setY(y)
		
		-- animate customers
		groupCustomers[1].timer = CUSTOMER_EATING_MIN_INTERVAL + getRandom(CUSTOMER_EATING_RND_INTERVAL)		
		groupCustomers[1].state = "DRINK"
		groupCustomers[1]:animate("DRINK", 1)	
		groupCustomers[2].timer = CUSTOMER_EATING_MIN_INTERVAL + getRandom(CUSTOMER_EATING_RND_INTERVAL)		
		groupCustomers[2].state = "EAT"
		groupCustomers[2]:animate("EAT", 1)		
		groupTable:updateLegs(groupCustomers[1], 0)
		groupTable:updateLegs(groupCustomers[2], 1)			
		groupTable:playSound("SOUND_CUSTOMER_EATING_LOOP_0", true)
		
    	scene:qWait(7000)
    	scene:qNotify("table stand up")
    	
    	tutorialProgress = "NULL"    	
    	
    elseif (notification == "table stand up") then	
    	groupTable:setPlateState(PLATES_EMPTY)
    	groupTable:stopSound("SOUND_CUSTOMER_EATING_LOOP_0")
    	groupTable:playSound("SOUND_CUSTOMER_FINISHED_EATING")
    	
    	groupCustomers[1].state = ""
    	groupCustomers[2].state = ""
    	groupCustomers[1]:addChild(self.order)
    	
    	groupCustomers[1]:qStand()
    	groupCustomers[1]:qWalkToXY(34,21)
    	groupCustomers[1]:qNotify("handle table payment")

	elseif (notification == "handle table payment") then
		self.order:setAlpha(1)
		self.order:popIn()
		register:qCreateOverhead("INGAME_ARROW")
		register:qSetClickable(true)
		cleaner:qSayClickable("TEXT_PAYMENTAGAIN")
		tutorialProgress = "CLICK_REGISTER_TABLE"
	
	elseif (notification == "start tutorial") then
		level:setSuspended(false)
		input:setInputActive(true)
	
	elseif (notification == "end tutorial") then
		self.tutorial = false
		coke:setClickable(true)
		coffee:setClickable(true)
		donut:setClickable(true)
		chips:setClickable(true)
		bunbottom:setClickable(true)
		burger:setClickable(true)
		buntop:setClickable(true)	
			
		for i = 0,4 do
			om:getTable(i):setClickable(true)
		
		end
		
		register:setClickable(true)	
		telephone:setClickable(true)
	
	end

end

function day0:onTick(time)

	if (not self.tutorial) then
		return
		
	end

	-- the fake customers have to read
	for index, value in ipairs(sitCustomers) do    
		if (value ~= nil) then
			if (value:isSitting()) then
				if (value.timer > 0) then
					value.timer = value.timer - time
					if (value.timer <= 0) then
						value:animate("READ", 1)
						value.timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)
					
					end
				end
			end
		end
	end
	
	-- the group customers have to do other stuff
	for index, value in ipairs(groupCustomers) do    
		if (value ~= nil) then
			if (value.state == "READ") then
				if (value.timer > 0) then
					value.timer = value.timer - time
					if (value.timer <= 0) then
						value:animate(value.state, 1)
						value.timer = CUSTOMER_READING_MIN_INTERVAL + getRandom(CUSTOMER_READING_RND_INTERVAL)
					
					end
				end			
			
			elseif (value.state == "ORDER") then
				if (value.timer > 0) then
					value.timer = value.timer - time
					if (value.timer <= 0) then
						value:animate(value.state, 1)
						value.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
					
					end
				end	
			
			
			elseif (value.state == "DRINK" or value.state == "EAT") then
				if (value.timer > 0) then
					value.timer = value.timer - time
					if (value.timer <= 0) then
						value:animate(value.state, 1)
						value.timer = CUSTOMER_ORDERING_MIN_INTERVAL + getRandom(CUSTOMER_ORDERING_RND_INTERVAL)
					
					end
				end
			
			end
		end
	end
	

end

-- set day
day = day0()