include("scripts/events/mailmanevent.lua")

-- set event
event = mailmanEvent()

-- day class
class 'day1' (interface)

function day1:__init() super()
end

function day1:onLevelGlobals()

	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- create francois
    francois = pm:createPerson("francois")    	

	-- position everyone
    francois:setPosition(grid:getNode(0, 3))
    emily:setPosition(grid:getCounterNode())    

	-- set event configuration
	event.baseName = "INGAME_PERSON_SPECIAL_MAILMAN"
	event.timeUntilEnterMin = 20000
	event.timeUntilEnterMax = 24000
	event.timeUntilAngry = 6000
	event.timeUntilLeave = 3000
	event.numPackages = 8
	event.entryX = entryX
	event.entryY = entryY
	event.waitX = 40
	event.waitY = 16
	event.workX = 36
	event.workY = 16
	event.angryAnim = "IDLE_WAITING"
	event.workAnim = "GIVE_LEFT"
	event.workAnimEmily = "WORK_RIGHT"
	event.scoreGotOne = 25
	event.scoreGotAll = 100
	event.package = "OBJECT_PACKAGE"
	event.sequenceStart = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "francois",		"qSetPosition",		movieNode					},
		{ "francois",		"qWalkToXY",		36,	17						},
		{ "francois",		"qWait",			500							},
		{ "francois",		"qSay",				"RESTAURANT0_DAY1_0"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY1_1"		},
		{ "francois",		"qSetAppearance",	"BLUSH"						},
		{ "francois",		"qSay",				"RESTAURANT0_DAY1_2"		},
		{ "emily",			"qAnimate",			"LAUGH", -1, 8				},
		{ "emily",			"qWait",			750							},
		{ "emily",			"qAnimate",			"IDLE", 0					},
		{ "emily",			"qSay",				"RESTAURANT0_DAY1_3"		},
		{ "francois",		"qSay",				"RESTAURANT0_DAY1_4"		},
		{ "francois",		"qWait",			500							},
		{ "francois",		"qWalkToNode",		movieNode					},
		{ "francois",		"qSetPosition",		entryNode					},
		{ "francois",		"qSetAppearance",	""							},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qStartGame" 									},
	}
	event.sequenceCompleted = 
	{
		{ "scene",			"qStartMovie" 									},
		{ "francois",		"qSetAppearance",	"ECSTATIC"					},
		{ "francois",		"qWalkToXY",		8, 24						},
		{ "francois",		"qSetAppearance",	"HAPPY"						},
		{ "francois",		"qWait",			500							},
		{ "francois",		"qSay",				"RESTAURANT0_DAY1_10"		},
		{ "francois",		"qSay",				"RESTAURANT0_DAY1_11"		},
		{ "emily",			"qWalkToXY",		12, 24						},
		{ "emily",			"qSay",				"RESTAURANT0_DAY1_12"		},
		{ "francois",		"qSay",				"RESTAURANT0_DAY1_13"		},
		{ "emily",			"qSay",				"RESTAURANT0_DAY1_14"		},
		{ "scene",			"qFinishMovie" 									},
		{ "scene",			"qFinishGame" 									},
	}	

end

function day1:onDayEnd()

	-- if we have gathered all francois' packages, we don't walk out right away
	-- but we do an animation first
	
	if (event.person.handed > 0) then
		-- prevent walking out
		autoAllPeopleWalkOut = false
		
		-- play completed sequence
		qSequence(event.sequenceCompleted)
	    
	end

end

-- set day
day = day1()