include("scripts/events/hiddenobjectevent.lua")

-- set event
event = hiddenObjectEvent()
event.registeredTypes =
{
	"Pearl",
}

-- day class
class 'day2' (interface)

day2.timeUntilSearchingMin = 8000
day2.timeUntilSearchingMax = 16000
day2.timer = 0

function day2:__init() super()
end

function day2:onLevelGlobals()

	-- set event configuration
	event.baseName = "INGAME_PERSON_MAYOR"					-- appearance of the person
	event.entryX = entryX									-- position person enters from
	event.entryY = entryY
	event.highlightX = 17
	event.highlightY = 15
	event.timeUntilEnterMin = 45000							-- minimum time the person waits outside
	event.timeUntilEnterMax = 55000							-- maximum time the person waits outside
	event.scoreFoundOne	= 50								-- score for finding one item
	event.scoreFoundAll	= 100								-- bonus for finding all items		
	event.sequenceStart	= 									-- text when event starts
	{
		{ "person",		"qWalkToXY",		39, 16						},
		{ "scene",		"qStartMovie" 									},
		{ "person",		"qSetAppearance",	"NOPEARLS"					},		
		{ "person",		"qAnimate",			"SEARCHING", 1				},
		{ "person",		"qWait",			800							},
		{ "person",		"qSetAppearance",	"NOPEARLS_SHOCK"			},		
		{ "person",		"qAnimate",			"IDLE", 0					},
		{ "person",		"qCreateOverhead",	"INGAME_EMPTY_PLATES_SIGN"	},
		{ "person",		"qPlaySound",		"SOUND_EVENT_ATTENTION"		},		
		{ "person",		"qWait",			1000						},
		{ "person",		"qRemoveOverhead"								},
		{ "person",		"qNotify",			"ho_arrived"				},
		{ "person", 	"qSay",				"RESTAURANT0_DAY2_0"		},
		{ "person",		"qSetAppearance",	"NOPEARLS_SAD"				},		
		{ "person", 	"qSay",				"RESTAURANT0_DAY2_1"		},
		{ "emily",		"qWalkToXY",		35, 16						},
		{ "emily", 		"qSetAppearance",	"NEUTRAL"					},
		{ "emily", 		"qSay",				"RESTAURANT0_DAY2_2"		},
		{ "emily", 		"qSetAppearance",	""							},
		{ "scene",		"qWait",			500							},
		{ "scene",		"qFinishMovie" 									},
		{ "scene",		"qNotify",			"show bar"					},
	}
	event.sequenceThanks = 									-- text when you find 1 item
	{
	}
	event.sequenceDone = 									-- text when you find all items
	{
		{ "person",		"qSetAppearance",	""							},
		{ "scene",		"qStartMovie" 									},
		{ "person", 	"qSay",				"RESTAURANT0_DAY2_4"		},
		{ "person",		"qWait",			1000						},
		{ "person",		"qWalkToNode",		movieNode					},
		{ "person",		"qDestroy",			"event.person"				},
		{ "scene",		"qFinishMovie" 									},
	}	
	
	autoStartGame = false
	autoAllPeopleWalkIn = false
	
	-- cleaner sequence
	
	-- position everyone
    emily:setPosition(grid:getCounterNode())		
    
    local sequenceCleaner =
    {
    	{ "scene",		"qStartMovie" 									},
    	{ "cleaner",	"qSetPosition",		movieNode					},
    	{ "cleaner",	"qWalkToXY",		29, 22						},
    	{ "cleaner",	"qSay",				"RESTAURANT0_DAY2_5"		},
    	{ "cleaner",	"qSay",				"RESTAURANT0_DAY2_6"		},
    	{ "emily",		"qSay",				"RESTAURANT0_DAY2_7"		},
    	{ "cleaner",	"qSay",				"RESTAURANT0_DAY2_8"		},
    	{ "emily",		"qSay",				"RESTAURANT0_DAY2_9"		},
    	{ "cleaner",	"qWalkToNode",		cleaner:getHomeNode()		},
    	{ "scene",		"qFinishMovie" 									},
    	{ "scene",		"qStartGame"									},
    }
    
    qSequence(sequenceCleaner)

end

function day2:onTick(time)

	if (event.completed == true) then
		return
	end
	
	if (self.timer > 0) then
		self.timer = self.timer - time
		if (self.timer <= 0) then
			event.person:animate("SEARCHING", 2, true, -1)		
			self.timer = getRandomRange(self.timeUntilSearchingMin, self.timeUntilSearchingMax)
			
		end		
	end

end

function day2:onNotify(notification)

	if (notification == "show bar") then
		self.timer = getRandomRange(self.timeUntilSearchingMin, self.timeUntilSearchingMax)
	
	end
	
end

-- set day
day = day2()